/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager;

import com.tandbergtv.metadatamanager.MetadataManagerDAO;
import com.tandbergtv.metadatamanager.exception.InvalidRevisionException;
import com.tandbergtv.metadatamanager.exception.MetadataException;
import com.tandbergtv.metadatamanager.exception.SearchException;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.AssetState;
import com.tandbergtv.metadatamanager.model.FieldRevision;
import com.tandbergtv.metadatamanager.model.Group;
import com.tandbergtv.metadatamanager.model.Relation;
import com.tandbergtv.metadatamanager.model.RootAssetRevision;
import com.tandbergtv.metadatamanager.search.AssetSearchService;
import com.tandbergtv.metadatamanager.specimpl.ttv.TTVId;
import com.tandbergtv.metadatamanager.util.AssetUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.Restrictions;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;

public class MetadataManagerDAOImpl
implements MetadataManagerDAO {
    private static final Logger logger = Logger.getLogger(MetadataManagerDAOImpl.class);
    private HibernateTemplate template;
    private PlatformTransactionManager platformTxMgr;
    private String tablePrefix;
    private AssetSearchService assetSearchService;

    public String getTablePrefix() {
        return this.tablePrefix;
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    public PlatformTransactionManager getPlatformTxMgr() {
        return this.platformTxMgr;
    }

    public void setPlatformTxMgr(PlatformTransactionManager platformTxMgr) {
        this.platformTxMgr = platformTxMgr;
    }

    public HibernateTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(HibernateTemplate template) {
        this.template = template;
    }

    @Override
    @Transactional
    public TTVId saveAsset(Asset asset) throws MetadataException {
        try {
            if (asset.getState() == AssetState.INACTIVE) {
                throw new MetadataException("Cannot add inactive assets to the store.");
            }
            asset = AssetUtil.deleteEmptyFields(asset);
            this.getTemplate().saveOrUpdate((Object)asset);
            logger.debug((Object)"+++ end of saveAsset()");
            return asset.getTTVId();
        }
        catch (DataAccessException e) {
            throw new MetadataException(e.getMessage(), e);
        }
    }

    @Override
    @Transactional
    public void delete(Asset a) throws SearchException {
        if (a.getRoot() == null) {
            this.inactivateAllChildren(a);
            this.getTemplate().update((Object)a);
        } else {
            this.deleteChildren(a);
            Asset root = a.getRoot();
            Asset parent = root.getAssetsParent(a);
            Relation toBeDeletedRelation = null;
            for (Relation r : parent.getRelations()) {
                if (r.getTargetAsset().getId() != a.getId()) continue;
                toBeDeletedRelation = r;
            }
            parent.getRelations().remove(toBeDeletedRelation);
            this.getTemplate().update((Object)root);
            this.getTemplate().delete((Object)a);
        }
    }

    private void deleteChildren(Asset asset) {
        ArrayList<Relation> relations = new ArrayList<Relation>();
        for (Relation relation : asset.getRelations()) {
            Asset target = relation.getTargetAsset();
            this.deleteChildren(target);
            this.getTemplate().delete((Object)target);
            relations.add(relation);
        }
        asset.getRelations().removeAll(relations);
    }

    private void inactivateAllChildren(Asset a) {
        a.setState(AssetState.INACTIVE);
        for (Relation relation : a.getRelations()) {
            Asset targetAsset = relation.getTargetAsset();
            targetAsset.setState(AssetState.INACTIVE);
            this.inactivateAllChildren(targetAsset);
        }
    }

    @Override
    @Transactional
    public Asset getAsset(TTVId id, int revisionNumber) throws SearchException, InvalidRevisionException {
        logger.debug((Object)("+++Start of getAsset(" + id.getId() + "," + revisionNumber + ")"));
        Session session = SessionFactoryUtils.getSession((SessionFactory)this.getTemplate().getSessionFactory(), (boolean)false);
        Asset asset = (Asset)this.getTemplate().get(Asset.class, (Serializable)Long.valueOf(id.getId()));
        if (revisionNumber != 0) {
            if (!this.isValidRevisionNumber(asset, revisionNumber)) {
                throw new InvalidRevisionException();
            }
        } else {
            revisionNumber = Integer.MAX_VALUE;
        }
        Hibernate.initialize(asset.getFieldRevisions());
        logger.debug((Object)"+++Start of running native sql for fieldRevisons");
        Query query = session.getNamedQuery("GetFieldRevisionsByRevison");
        List fieldRevisionList = query.setInteger("revisionParam", revisionNumber).setLong("assetIdParam", id.getId()).list();
        logger.debug((Object)"+++End of running native sql for fieldRevisons");
        asset.setFieldRevisions(fieldRevisionList);
        logger.debug((Object)"+++After setting fieldRevisons for an Asset");
        if (asset instanceof Group) {
            session.enableFilter("rootAssetRevisionFilter").setParameter("rootAssetRevisionParam", (Object)revisionNumber);
            Hibernate.initialize(((Group)asset).getRevisions());
        }
        session.enableFilter("relationRevisionFilter").setParameter("revisionParam", (Object)revisionNumber);
        List<Relation> relations = asset.getRelations();
        for (Relation relation : relations) {
            relation.setTargetAsset(this.getAsset(relation.getTargetAsset().getTTVId(), revisionNumber));
        }
        logger.debug((Object)("---END of getAsset(" + id.getId() + ")"));
        if (asset == null || asset.getState() == AssetState.INACTIVE) {
            throw new SearchException("Could not get asset with id: " + id.getId());
        }
        return asset;
    }

    private boolean isValidRevisionNumber(Asset asset, int revisionNumber) {
        boolean isValid = false;
        if (asset instanceof Group) {
            for (RootAssetRevision rootAssetRevision : ((Group)asset).getRevisions()) {
                if (rootAssetRevision.getRevisionNumber() != revisionNumber) continue;
                isValid = true;
                break;
            }
        } else {
            isValid = true;
        }
        return isValid;
    }

    @Override
    @Transactional
    public Asset getAsset(TTVId id) throws SearchException {
        try {
            return this.getAsset(id, 0);
        }
        catch (InvalidRevisionException e) {
            logger.error((Object)("Unable to get latest Asset with TTVid: " + id), (Throwable)e);
            throw new SearchException("Invalid Revision");
        }
    }

    @Override
    @Transactional
    public Relation getRelation(Asset owner, Asset target) throws SearchException {
        DetachedCriteria criteria = DetachedCriteria.forClass(Relation.class);
        criteria.add((Criterion)Restrictions.eq((String)"targetAsset.id", (Object)target.getTTVId().getId()));
        criteria.add((Criterion)Restrictions.eq((String)"ownerAsset.id", (Object)owner.getTTVId().getId()));
        List relations = this.getTemplate().findByCriteria(criteria);
        if (relations.size() > 1) {
            throw new SearchException("Multiple relations found between owner: " + owner.getTTVId().getId() + " and target: " + target.getTTVId().getId());
        }
        return relations.size() == 1 ? (Relation)relations.get(0) : null;
    }

    public AssetSearchService getAssetSearchService() {
        return this.assetSearchService;
    }

    public void setAssetSearchService(AssetSearchService assetSearchService) {
        this.assetSearchService = assetSearchService;
    }

    @Override
    public List<FieldRevision> getUnDeletedFieldRevsions(FieldRevision fieldRevision) {
        DetachedCriteria criteria = DetachedCriteria.forClass(FieldRevision.class).add((Criterion)Expression.eq((String)"parentAsset.id", (Object)fieldRevision.getParentAsset().getId()));
        criteria.add((Criterion)Expression.eq((String)"ttvXPath", (Object)fieldRevision.getTtvXPath()));
        criteria.add((Criterion)Expression.eq((String)"storedIndices", (Object)fieldRevision.getStoredIndices()));
        criteria.add((Criterion)Expression.lt((String)"revisionNumber", (Object)fieldRevision.getRevisionNumber()));
        criteria.add((Criterion)Expression.le((String)"deleteRevision", (Object)0));
        List fieldRevisions = this.getTemplate().findByCriteria(criteria);
        return fieldRevisions;
    }
}

