/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.factoryImpl;

import com.tandbergtv.metadatamanager.model.Spec;
import com.tandbergtv.metadatamanager.search.AssetSearchService;
import com.tandbergtv.metadatamanager.spec.IIdentifier;
import com.tandbergtv.metadatamanager.specimpl.cl1_1.CL1_1_Identifier;
import com.tandbergtv.metadatamanager.specimpl.mstv.MSTVIdentifier;
import com.tandbergtv.metadatamanager.specimpl.ttv.TTVId;

public class IdentifierFactory {
    private static AssetSearchService searchService;
    private static String mstvMappingResource;
    private static String cl1_1_MappingResource;

    public String getCl1_1_MappingResource() {
        return cl1_1_MappingResource;
    }

    public void setCl1_1_MappingResource(String cl1_1_MappingResource) {
        IdentifierFactory.cl1_1_MappingResource = cl1_1_MappingResource;
    }

    public String getMstvMappingResource() {
        return mstvMappingResource;
    }

    public void setMstvMappingResource(String mstvMappingResource) {
        IdentifierFactory.mstvMappingResource = mstvMappingResource;
    }

    public static AssetSearchService getSearchService() {
        return searchService;
    }

    public void setSearchService(AssetSearchService searchService) {
        IdentifierFactory.searchService = searchService;
    }

    public static IIdentifier getInstance(Spec specification) {
        if (specification == Spec.CL1_1) {
            CL1_1_Identifier id = new CL1_1_Identifier();
            id.setSearchService(searchService);
            id.setMappingResource(cl1_1_MappingResource);
            return id;
        }
        if (specification == Spec.MSTV) {
            MSTVIdentifier id = new MSTVIdentifier();
            id.setSearchService(searchService);
            id.setMappingResource(mstvMappingResource);
            return id;
        }
        if (specification == Spec.TTV) {
            TTVId id = new TTVId();
            id.setSearchService(searchService);
            return id;
        }
        return null;
    }
}

