/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.specimpl;

import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import com.tandbergtv.metadatamanager.MetadataManagerDAO;
import com.tandbergtv.metadatamanager.exception.InvalidRevisionException;
import com.tandbergtv.metadatamanager.exception.MetadataException;
import com.tandbergtv.metadatamanager.exception.SearchException;
import com.tandbergtv.metadatamanager.exception.TranslationException;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.FieldRevision;
import com.tandbergtv.metadatamanager.model.File;
import com.tandbergtv.metadatamanager.model.Group;
import com.tandbergtv.metadatamanager.model.IField;
import com.tandbergtv.metadatamanager.model.Item;
import com.tandbergtv.metadatamanager.model.NextRevision;
import com.tandbergtv.metadatamanager.model.Relation;
import com.tandbergtv.metadatamanager.model.RootAssetRevision;
import com.tandbergtv.metadatamanager.model.SearchCriteria;
import com.tandbergtv.metadatamanager.model.Spec;
import com.tandbergtv.metadatamanager.search.AssetSearchService;
import com.tandbergtv.metadatamanager.search.CriteriaBuilder;
import com.tandbergtv.metadatamanager.spec.IIdentifier;
import com.tandbergtv.metadatamanager.spec.IRuleManager;
import com.tandbergtv.metadatamanager.spec.ISpecHandler;
import com.tandbergtv.metadatamanager.spec.ITranslator;
import com.tandbergtv.metadatamanager.spec.IValidator;
import com.tandbergtv.metadatamanager.specimpl.ttv.TTVId;
import com.tandbergtv.metadatamanager.util.AssetUtil;
import com.tandbergtv.metadatamanager.util.Binder;
import com.tandbergtv.metadatamanager.util.MappingFileParser;
import com.tandbergtv.metadatamanager.validation.Schema.SchemaValidator;
import com.tandbergtv.metadatamanager.validation.Schematron.CustomSchematronBuilder;
import com.tandbergtv.metadatamanager.validation.Schematron.SchematronValidator;
import com.tandbergtv.metadatamanager.validation.ValidationError;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.springframework.transaction.annotation.Transactional;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public abstract class SpecHandlerBase
implements ISpecHandler {
    private static String SCHEMA_VALIDATOR = "SchemaValidator";
    protected MetadataManagerDAO metadataManagerDAO;
    protected AssetSearchService searchService;
    protected final Logger logger = Logger.getLogger(this.getClass());
    protected ITranslator toTTV;
    protected ITranslator fromTTV;
    protected String mappingResource;
    protected Map<String, IValidator> ruleValidators;
    protected String schemaResource;
    protected Spec spec;
    protected IRuleManager ruleManager;
    protected Map<String, Set<String>> specSpecificTTVXpaths;
    protected String specSpecificTTVXpathsFileName;

    public void setRuleManager(IRuleManager ruleManager) {
        this.ruleManager = ruleManager;
    }

    @Override
    public IRuleManager getRuleManager() {
        return this.ruleManager;
    }

    public Spec getSpec() {
        return this.spec;
    }

    public void setSpec(Spec spec) {
        this.spec = spec;
    }

    public String getSchemaResource() {
        return this.schemaResource;
    }

    public void setSchemaResource(String schemaResource) {
        this.schemaResource = schemaResource;
    }

    @Override
    public Map<String, IValidator> getRuleValidators() {
        return this.ruleValidators;
    }

    public void setRuleValidators(Map<String, IValidator> validators) {
        this.ruleValidators = validators;
    }

    public String getMappingResource() {
        return this.mappingResource;
    }

    public void setMappingResource(String mappingResource) {
        this.mappingResource = mappingResource;
    }

    public ITranslator getToTTV() {
        return this.toTTV;
    }

    public void setToTTV(ITranslator toTTV) {
        this.toTTV = toTTV;
    }

    public ITranslator getFromTTV() {
        return this.fromTTV;
    }

    public void setFromTTV(ITranslator fromTTV) {
        this.fromTTV = fromTTV;
    }

    public MetadataManagerDAO getMetadataManagerDAO() {
        return this.metadataManagerDAO;
    }

    public void setMetadataManagerDAO(MetadataManagerDAO metadataManagerDAO) {
        this.metadataManagerDAO = metadataManagerDAO;
    }

    public AssetSearchService getSearchService() {
        return this.searchService;
    }

    public void setSearchService(AssetSearchService searchService) {
        this.searchService = searchService;
    }

    public void setSpecSpecificTTVXpathsFileName(String specSpecificTTVXpathsFileName) {
        this.specSpecificTTVXpathsFileName = specSpecificTTVXpathsFileName;
        BufferedReader br = new BufferedReader(new InputStreamReader(MappingFileParser.class.getClassLoader().getResourceAsStream(specSpecificTTVXpathsFileName)));
        this.specSpecificTTVXpaths = new HashMap<String, Set<String>>();
        try {
            String line;
            String type = "";
            HashSet set = null;
            while ((line = br.readLine()) != null) {
                if (line.equals("")) continue;
                if (line.startsWith("[")) {
                    type = line.replaceAll("\\[", "");
                    type = type.replaceAll("\\]", "");
                    if (this.specSpecificTTVXpaths.containsKey(type = type.trim().toLowerCase())) continue;
                    set = new HashSet();
                    this.specSpecificTTVXpaths.put(type, set);
                    continue;
                }
                this.specSpecificTTVXpaths.get(type).add(line.trim());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, Set<String>> getSpecSpecificTTVXpaths() {
        return this.specSpecificTTVXpaths;
    }

    @Override
    @Transactional
    public List<IIdentifier> deleteAll(List<IIdentifier> ids) {
        ArrayList<IIdentifier> deletedAssetIds = new ArrayList<IIdentifier>();
        for (IIdentifier id : ids) {
            try {
                this.deleteUnique(id);
                deletedAssetIds.add(id);
            }
            catch (Exception e) {
                this.logger.error((Object)("Error deleting asset with id: " + id.toString()), (Throwable)e);
            }
        }
        return deletedAssetIds;
    }

    @Override
    @Transactional
    public void deleteUnique(IIdentifier id) throws SearchException {
        Asset asset = id.getAsset();
        this.logger.debug((Object)("TTV Id for: " + id.toString() + " is = " + asset.getId()));
        this.metadataManagerDAO.delete(asset);
    }

    private static Document kludge(Document doc) {
        if (doc == null) {
            return null;
        }
        try {
            OutputFormat format = new OutputFormat(doc);
            format.setIndenting(true);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XMLSerializer serializer = new XMLSerializer(baos, format);
            serializer.serialize(doc);
            byte[] docBytes = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(docBytes);
            Document input = null;
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            input = builder.parse(bais);
            return input;
        }
        catch (ParserConfigurationException e) {
        }
        catch (SAXException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Document get(IIdentifier id) throws MetadataException, SearchException, TranslationException {
        return this.get(id, null);
    }

    private void getRelationAssets(Asset asset) {
        for (Relation targetRelation : asset.getRelations()) {
            Asset ta = targetRelation.getTargetAsset();
            ta = new AssetUtil().unWrap(ta);
            targetRelation.setTargetAsset(ta);
            this.getRelationAssets(ta);
        }
    }

    @Override
    @Transactional
    public List<IIdentifier> getIdentifiers(Document doc) throws MetadataException {
        Document convertedDoc = null;
        try {
            convertedDoc = this.getToTTV().translate(doc);
        }
        catch (TranslationException e) {
            this.logger.error((Object)e);
            throw new MetadataException(e.getMessage(), e);
        }
        List<Asset> assets = Binder.bind(convertedDoc);
        ArrayList<IIdentifier> returnIdentifierList = new ArrayList<IIdentifier>();
        if (assets != null) {
            for (Asset a : assets) {
                IIdentifier identifier = this.extractId(a);
                returnIdentifierList.add(identifier);
            }
        }
        return returnIdentifierList;
    }

    @Override
    @Transactional
    public List<IIdentifier> put(Document doc) throws MetadataException {
        return this.put(doc, null, null, null);
    }

    @Override
    @Transactional
    public List<IIdentifier> put(Document doc, String revisionSource, String revisionComment, String externalRevision) throws MetadataException {
        RootAssetRevision rootAssetRevision = new RootAssetRevision(revisionSource, revisionComment, externalRevision);
        boolean prune = true;
        List<Asset> assetList = this.save(doc, prune, rootAssetRevision);
        ArrayList<IIdentifier> savedIdList = new ArrayList<IIdentifier>();
        for (Asset ma : assetList) {
            savedIdList.add(this.extractId(ma));
        }
        return savedIdList;
    }

    @Override
    @Transactional
    public List<Asset> save(Document doc) throws MetadataException {
        boolean prune = true;
        return this.save(doc, prune, new RootAssetRevision());
    }

    private List<Asset> save(Document doc, boolean prune, RootAssetRevision rootAssetRevision) throws MetadataException {
        Document convertedDoc = null;
        try {
            convertedDoc = this.getToTTV().translate(doc);
        }
        catch (TranslationException e) {
            this.logger.error((Object)e);
            throw new MetadataException(e.getMessage(), e);
        }
        List<Asset> assets = Binder.bind(convertedDoc);
        return this.mergeSaveAssets(assets, prune, rootAssetRevision);
    }

    protected List<Asset> mergeSaveAssets(List<Asset> toBeMergedAssets, boolean prune, RootAssetRevision rootAssetRevision) throws MetadataException {
        List<Asset> mergedAssets;
        ArrayList<Asset> assetList = new ArrayList<Asset>();
        try {
            mergedAssets = this.mergeAssets(toBeMergedAssets, prune);
        }
        catch (SearchException e) {
            this.logger.error((Object)e);
            throw new MetadataException(e.getMessage(), e);
        }
        for (Asset ma : mergedAssets) {
            if (ma instanceof Group) {
                ((Group)ma).addRootAssetRevision(rootAssetRevision);
            }
            this.getMetadataManagerDAO().saveAsset(ma);
            assetList.add(ma);
        }
        return assetList;
    }

    @Override
    @Transactional
    public List<Asset> incrementalSave(Document doc) throws MetadataException {
        boolean prune = false;
        return this.save(doc, prune, new RootAssetRevision());
    }

    @Override
    public List<ValidationError> validateSchema(Document doc) {
        SchemaValidator validator = new SchemaValidator(this.getSchemaValidatorName(), this.schemaResource);
        return validator.validate(doc);
    }

    @Override
    public List<ValidationError> customValidate(Document doc, IValidator baseRules, String ruleSet) {
        List<ValidationError> errors = baseRules.validate(doc);
        Map<String, Boolean> ruleMap = this.ruleManager.getRuleSet(ruleSet);
        errors = this.removeOverridenErrors(errors, ruleMap);
        errors.addAll(this.addRequiredErrors(doc, ruleMap));
        return errors;
    }

    private List<ValidationError> addRequiredErrors(Document doc, Map<String, Boolean> ruleMap) {
        InputStream is = CustomSchematronBuilder.buildSchematron(ruleMap);
        SchematronValidator customValidator = new SchematronValidator("custom", is);
        return customValidator.validate(doc);
    }

    private List<ValidationError> removeOverridenErrors(List<ValidationError> errors, Map<String, Boolean> ruleMap) {
        ArrayList<ValidationError> toDelete = new ArrayList<ValidationError>();
        for (ValidationError ve : errors) {
            if (!ve.getErrorCode().equals("ERR-02") || !this.errorFoundInMap(ve, ruleMap)) continue;
            toDelete.add(ve);
        }
        for (ValidationError ve : toDelete) {
            errors.remove(ve);
        }
        return errors;
    }

    private boolean errorFoundInMap(ValidationError ve, Map<String, Boolean> ruleMap) {
        for (Map.Entry<String, Boolean> entry : ruleMap.entrySet()) {
            try {
                if (!this.compareXPaths(entry.getKey(), ve.getErrorLocation() + "/" + ve.getErrorFields().get(0))) continue;
                return true;
            }
            catch (IndexOutOfBoundsException e) {
            }
        }
        return false;
    }

    private boolean compareXPaths(String string1, String string2) {
        String str1 = string1.replaceAll("\\[[0-9]*\\]|@", "");
        String str2 = string2.replaceAll("\\[[0-9]*\\]|@", "");
        return str1.equals(str2);
    }

    @Override
    public List<ValidationError> validateField(Document doc, IValidator baseRules, String xpath) {
        List<ValidationError> errors = baseRules.validate(doc);
        ArrayList<ValidationError> results = new ArrayList<ValidationError>();
        for (ValidationError ve : errors) {
            try {
                if (!this.compareXPaths(xpath, ve.getErrorLocation() + "/" + ve.getErrorFields().get(0))) continue;
                results.add(ve);
            }
            catch (IndexOutOfBoundsException e) {}
        }
        return results;
    }

    private String getSchemaValidatorName() {
        return this.getSpec().toString() + SCHEMA_VALIDATOR;
    }

    private List<Asset> mergeAssets(List<Asset> assets, boolean prune) throws SearchException, MetadataException {
        Iterator<Asset> assetIter = assets.iterator();
        ArrayList<Asset> mergedAssets = new ArrayList<Asset>();
        while (assetIter.hasNext()) {
            Asset currAsset = assetIter.next();
            if ((currAsset = AssetUtil.deleteEmptyFields(currAsset)) instanceof Group) {
                NextRevision nextRevision = new NextRevision();
                TTVId existingTTVId = this.getTTVId(currAsset, null);
                Asset mergedAsset = currAsset;
                if (existingTTVId != null) {
                    Asset existingAsset = this.getMetadataManagerDAO().getAsset(existingTTVId);
                    nextRevision.setRevisionNumber(existingAsset.getLatestRevisionNumber() + 1);
                    mergedAsset = this.mergeAsset(currAsset, existingAsset, prune, nextRevision);
                } else {
                    AssetUtil.copyFieldsToFieldRevisions(mergedAsset, nextRevision);
                }
                mergedAssets.add(mergedAsset);
                continue;
            }
            throw new MetadataException("Adding an ITEM is not supported yet! Add a Group");
        }
        return mergedAssets;
    }

    protected Asset mergeAsset(Asset newAsset, Asset oldAsset, boolean prune, NextRevision nextRevision) throws SearchException {
        Asset rootAsset = oldAsset;
        oldAsset = this.mergeAndAddIncomingIntoExistingAsset(newAsset, oldAsset, rootAsset, nextRevision);
        if (prune) {
            oldAsset = this.pruneExistingAssetTree(newAsset, oldAsset, nextRevision);
        }
        return oldAsset;
    }

    protected Asset mergeAndAddIncomingIntoExistingAsset(Asset newAsset, Asset oldAsset, Asset rootAsset, NextRevision nextRevision) throws SearchException {
        String assetType = this.getAssetType(newAsset);
        this.mergeFields(newAsset, oldAsset, assetType, nextRevision);
        for (Relation newRelation : newAsset.getRelations()) {
            Asset newTargetAsset = newRelation.getTargetAsset();
            if (this.requireSpecSpecificMerging(this.getAssetType(newTargetAsset))) {
                this.specSpecificMerging(oldAsset, nextRevision, newRelation, newTargetAsset);
                continue;
            }
            TTVId existingTtvId = this.getTTVId(newTargetAsset, rootAsset);
            if (existingTtvId != null) {
                Asset existingTargetAsset = this.getMetadataManagerDAO().getAsset(existingTtvId);
                Asset existingChildAsset = oldAsset.getAsset(existingTtvId.getId());
                if (existingChildAsset == null) {
                    oldAsset.addChild(existingTargetAsset, nextRevision);
                } else {
                    existingTargetAsset = existingChildAsset;
                }
                this.mergeAndAddIncomingIntoExistingAsset(newTargetAsset, existingTargetAsset, rootAsset, nextRevision);
                if (!existingTargetAsset.isRevisionNumberUpdated()) continue;
                oldAsset.setLatestRevisionNumber(nextRevision.getRevisionNumber());
                continue;
            }
            oldAsset.addChild(newTargetAsset, nextRevision);
        }
        return oldAsset;
    }

    protected void specSpecificMerging(Asset oldAsset, NextRevision nextRevision, Relation newRelation, Asset targetAsset) {
    }

    protected Asset pruneExistingAssetTree(Asset newAsset, Asset oldAsset, NextRevision nextRevision) throws SearchException {
        ArrayList<Relation> oldRelationsToBeDeleted = new ArrayList<Relation>();
        for (Relation oldRelation : oldAsset.getRelations()) {
            String oldAssetType;
            boolean assetFound = false;
            Asset oldTargetAsset = oldRelation.getTargetAsset();
            if (oldTargetAsset instanceof File || !this.isAssetTypePartOfSpec(oldAssetType = this.getAssetType(oldTargetAsset))) continue;
            Asset newTargetAsset = null;
            assetFound = this.searchNewTargetAsset(oldAssetType, newAsset, oldTargetAsset, newTargetAsset);
            if (!assetFound) {
                oldRelationsToBeDeleted.add(oldRelation);
                continue;
            }
            this.pruneExistingAssetTree(newTargetAsset, oldTargetAsset, nextRevision);
        }
        this.removeOldRelations(oldAsset, nextRevision, oldRelationsToBeDeleted);
        return oldAsset;
    }

    protected boolean searchNewTargetAsset(String oldAssetType, Asset newAsset, Asset oldTargetAsset, Asset newTargetAsset) {
        boolean assetFound = false;
        if (this.requireSpecSpecificSearchForPruning(oldAssetType)) {
            assetFound = this.specSpecificSearchForPruning(oldAssetType, newAsset, oldTargetAsset);
        } else {
            Relation rel;
            List<Field> fields;
            SearchCriteria crit = this.prepareSearchPathById(oldTargetAsset.getFields());
            Iterator<Relation> i$ = newAsset.getRelations().iterator();
            while (i$.hasNext() && !(assetFound = this.isSearchCriteriaPresent(crit, fields = (newTargetAsset = (rel = i$.next()).getTargetAsset()).getFields()))) {
            }
        }
        return assetFound;
    }

    protected boolean isAssetTypePartOfSpec(String assetType) {
        return this.specSpecificTTVXpaths.containsKey(assetType.toLowerCase());
    }

    protected void removeOldRelations(Asset oldAsset, NextRevision nextRevision, ArrayList<Relation> oldRelationsToBeDeleted) {
        for (Relation oldRelationToBeDeleted : oldRelationsToBeDeleted) {
            oldRelationToBeDeleted.setDeleteRevision(nextRevision.getRevisionNumber());
            List<Field> oldTargetAssetFields = oldRelationToBeDeleted.getTargetAsset().getFields();
            oldTargetAssetFields.removeAll(oldTargetAssetFields);
        }
        if (oldRelationsToBeDeleted.size() > 0) {
            oldAsset.setLatestRevisionNumber(nextRevision.getRevisionNumber());
        }
    }

    protected boolean specSpecificSearchForPruning(String assetType, Asset newAsset, Asset oldTargetAsset) {
        return false;
    }

    protected boolean requireSpecSpecificSearchForPruning(String assetType) {
        return false;
    }

    protected boolean requireSpecSpecificMerging(String assetType) {
        return false;
    }

    protected String getAssetType(Asset targetAsset) {
        String assetType = "";
        if ((targetAsset = new AssetUtil().unWrap(targetAsset)) instanceof Group) {
            Group g = (Group)targetAsset;
            assetType = g.getType();
        } else {
            Item i = (Item)targetAsset;
            assetType = i.getType();
        }
        return assetType;
    }

    protected boolean isSearchCriteriaPresent(SearchCriteria criteria, List<Field> fields) {
        Iterator entryIterator = criteria.entrySet().iterator();
        boolean fieldsFound = true;
        while (entryIterator.hasNext()) {
            Map.Entry entry = entryIterator.next();
            String xpath = (String)entry.getKey();
            String value = (String)entry.getValue();
            fieldsFound = false;
            for (Field f : fields) {
                if (!f.getTtvXPath().equals(xpath) || !f.getValue().equals(value)) continue;
                fieldsFound = true;
                break;
            }
            if (fieldsFound) continue;
            return false;
        }
        return true;
    }

    protected TTVId getTTVId(Asset asset, Asset rootAsset) throws SearchException {
        com.tandbergtv.workflow.util.SearchCriteria crit;
        SearchCriteria criteria = this.prepareSearchPathById(asset.getFields());
        if (rootAsset == null) {
            criteria.put("rootlevel", "true");
        }
        if ((crit = CriteriaBuilder.buildFieldRevisionSearchCriteria(criteria)).getSearchList().size() == 0) {
            return null;
        }
        ArrayList<TTVId> ids = new ArrayList<TTVId>();
        Collection<Asset> assets = this.searchService.search(crit);
        if (rootAsset == null) {
            for (Asset a : assets) {
                ids.add(a.getTTVId());
            }
        } else if (assets != null && assets.size() != 0) {
            long rootId = rootAsset.getId();
            for (Asset a : assets) {
                if (a.getRoot() == null || a.getRoot().getId() != rootId) continue;
                ids.add(a.getTTVId());
            }
        }
        if (ids.size() > 1) {
            throw new SearchException("Multiple assets with spec Id: " + criteria.toString() + " were found.");
        }
        return ids.size() == 1 ? (TTVId)ids.get(0) : null;
    }

    protected Map<String, String> translate(List<String> fields) {
        HashMap<String, String> fieldXpaths = new HashMap<String, String>();
        Map<String, String> fieldMappings = MappingFileParser.readFieldMapping(this.getMappingResource());
        for (String field : fields) {
            if (fieldMappings.containsKey(field)) {
                fieldXpaths.put(field, fieldMappings.get(field));
                continue;
            }
            throw new RuntimeException("Cannot map field: " + field + " to TTV equivalent.");
        }
        return fieldXpaths;
    }

    protected abstract SearchCriteria prepareSearchPathById(List<Field> var1);

    protected abstract IIdentifier extractId(Asset var1);

    public void mergeFields(Asset newAsset, Asset oldAsset, String assetType, NextRevision nextRevision) {
        List<Field> newFields = newAsset.getFields();
        List<Field> oldFields = oldAsset.getFields();
        List<Object> toBeDeletedFieldRevisions = new ArrayList();
        List<Object> toBeDeletedFields = new ArrayList();
        toBeDeletedFieldRevisions = this.getToBeDeleted(newFields, oldAsset.getFieldRevisions(), assetType);
        if (toBeDeletedFieldRevisions != null && toBeDeletedFieldRevisions.size() > 0) {
            this.removeFieldRevisions(oldAsset, toBeDeletedFieldRevisions, nextRevision);
        }
        toBeDeletedFields = this.getToBeDeleted(newFields, oldFields, assetType);
        oldFields.removeAll(toBeDeletedFields);
        this.updateExistingFields(newAsset, oldAsset, nextRevision);
    }

    protected void updateExistingFields(Asset newAsset, Asset oldAsset, NextRevision nextRevision) {
        List<Field> newFields = newAsset.getFields();
        List<FieldRevision> oldFieldRevisions = oldAsset.getFieldRevisions();
        List<Field> oldFields = oldAsset.getFields();
        for (Field newField : newFields) {
            Field oldField;
            FieldRevision oldFieldRevision = this.getFieldForXpathAndIndex(oldFieldRevisions, newField.getTtvXPath(), newField.getIndices());
            if (oldFieldRevision != null) {
                if (!newField.getValue().equalsIgnoreCase(oldFieldRevision.getValue())) {
                    FieldRevision newFieldRevision = new FieldRevision(oldFieldRevision, nextRevision);
                    newFieldRevision.setValue(newField.getValue());
                    oldAsset.addFieldRevision(newFieldRevision, nextRevision);
                }
            } else {
                FieldRevision newf = new FieldRevision(newField, nextRevision);
                newf.setDeleteRevision(0);
                newf.setAddRevision(nextRevision.getRevisionNumber());
                newf.setRevisionNumber(nextRevision.getRevisionNumber());
                oldAsset.addFieldRevision(newf, nextRevision);
            }
            if ((oldField = this.getFieldForXpathAndIndex(oldFields, newField.getTtvXPath(), newField.getIndices())) != null) {
                oldField.setValue(newField.getValue());
                continue;
            }
            Field newf = new Field(newField);
            oldAsset.addField(newf);
        }
    }

    protected <T extends IField> T getFieldForXpathAndIndex(List<T> fields, String xpath, List<Integer> indices) {
        for (IField f : fields) {
            if (!f.getTtvXPath().trim().equals(xpath.trim()) || !((Object)f.getIndices()).equals(indices)) continue;
            return (T)f;
        }
        return null;
    }

    @Override
    public Document get(IIdentifier id, String revision) throws MetadataException, SearchException, TranslationException {
        Asset asset = id.getAsset();
        return this.getRevision(asset.getTTVId(), revision);
    }

    protected Document getRevision(TTVId ttvId, String revision) throws SearchException, TranslationException {
        Asset asset = this.getAssetTree(ttvId, revision);
        Document tree = Binder.bind(asset);
        return this.getFromTTV().translate(SpecHandlerBase.kludge(tree));
    }

    protected void copyFromRevisionsToFields(Asset asset, int revisionNumber, boolean forceCopy) {
        if (revisionNumber < asset.getLatestRevisionNumber() || forceCopy) {
            List<Field> assetFields = asset.getFields();
            assetFields.removeAll(assetFields);
            for (FieldRevision fieldRevision : asset.getFieldRevisions()) {
                assetFields.add(new Field(fieldRevision));
            }
            for (Relation targetRelation : asset.getRelations()) {
                forceCopy = false;
                if (targetRelation.getDeleteRevision() != 0) {
                    forceCopy = true;
                }
                this.copyFromRevisionsToFields(targetRelation.getTargetAsset(), revisionNumber, forceCopy);
            }
        }
    }

    protected int parseThenGetInternalRevisionNumber(String revision) throws SearchException {
        int delimiterIndex = revision.lastIndexOf(Asset.EXTERNAL_INTERNAL_REVISION_DELIMITER);
        if (delimiterIndex < 0 || delimiterIndex == revision.length() - 1) {
            throw new SearchException("Revision: " + revision + " is not in the format of " + RootAssetRevision.REVISION_FORMAT);
        }
        return Integer.parseInt(revision.substring(delimiterIndex + 1));
    }

    protected String parseThenGetExternalRevisionNumber(String revision) throws SearchException {
        int delimiterIndex = revision.lastIndexOf(Asset.EXTERNAL_INTERNAL_REVISION_DELIMITER);
        if (delimiterIndex < 0) {
            throw new SearchException("Revision: " + revision + " is not in the format of " + RootAssetRevision.REVISION_FORMAT);
        }
        String externalRevision = revision.substring(0, delimiterIndex);
        if (externalRevision == null) {
            externalRevision = "";
        }
        return externalRevision;
    }

    @Override
    public List<RootAssetRevision> getRevisions(IIdentifier id) throws MetadataException, SearchException, TranslationException {
        Asset asset = id.getAsset();
        if (!(asset instanceof Group)) {
            throw new MetadataException("Asset identified by input id: " + id + " is not a top-level asset!");
        }
        asset = this.metadataManagerDAO.getAsset(asset.getTTVId());
        return ((Group)asset).getRevisions();
    }

    protected Asset findAsset(Asset searchCandidate, List<Asset> searchTargets) {
        SearchCriteria crit = this.prepareSearchPathById(searchCandidate.getFields());
        boolean assetFound = false;
        for (Asset searchTarget : searchTargets) {
            List<Field> fields = searchTarget.getFields();
            assetFound = this.isSearchCriteriaPresent(crit, fields);
            if (!assetFound) continue;
            return searchTarget;
        }
        return null;
    }

    protected Asset getAssetTree(TTVId ttvId, String revision) throws SearchException {
        Asset asset;
        int internalRevisionNumber = 0;
        if (revision != null && (internalRevisionNumber = this.parseThenGetInternalRevisionNumber(revision)) <= 0) {
            throw new SearchException("Version: " + revision + " is invalid, please provide a valid version.");
        }
        try {
            asset = this.metadataManagerDAO.getAsset(ttvId, internalRevisionNumber);
        }
        catch (InvalidRevisionException e) {
            throw new SearchException("Version: " + revision + " is invalid, please provide a valid version.");
        }
        this.copyFromRevisionsToFields(asset, internalRevisionNumber, false);
        this.getRelationAssets(asset);
        return asset;
    }

    @Override
    public Document rollBackToRevision(TTVId ttvId, String revision) throws MetadataException, SearchException, TranslationException {
        Asset oldAsset = this.getAssetTree(ttvId, revision);
        ArrayList<Asset> toBeMergedAssets = new ArrayList<Asset>();
        toBeMergedAssets.add(oldAsset);
        RootAssetRevision rootAssetRevision = new RootAssetRevision("test", "Rollback to revision " + revision, this.parseThenGetExternalRevisionNumber(revision));
        this.mergeSaveAssets(toBeMergedAssets, true, rootAssetRevision);
        return this.getRevision(ttvId, null);
    }

    @Override
    public List<Asset> save(Document doc, String revisionSource, String revisionComment, String externalRevision) throws MetadataException {
        return null;
    }

    protected <N extends IField, O extends IField> List<O> getToBeDeleted(List<N> newFields, List<O> oldFields, String assetType) {
        ArrayList<IField> toBeDeletedFields = new ArrayList<IField>();
        for (IField oldField : oldFields) {
            N newField;
            if (!this.isXPathPartOfSpec(assetType, oldField.getTtvXPath()) || (newField = this.getFieldForXpathAndIndex(newFields, oldField.getTtvXPath(), oldField.getIndices())) != null) continue;
            toBeDeletedFields.add(oldField);
        }
        return toBeDeletedFields;
    }

    protected boolean isXPathPartOfSpec(String assetType, String ttvXPath) {
        assetType = assetType.toLowerCase();
        Set<String> xpathSet = null;
        if (this.specSpecificTTVXpaths.containsKey(assetType)) {
            xpathSet = this.specSpecificTTVXpaths.get(assetType);
        }
        return xpathSet != null && xpathSet.contains(ttvXPath);
    }

    protected void removeFieldRevisions(Asset oldAsset, List<FieldRevision> toBeDeleted, NextRevision nextRevision) {
        if (toBeDeleted != null && toBeDeleted.size() > 0) {
            oldAsset.setLatestRevisionNumber(nextRevision.getRevisionNumber());
            for (FieldRevision field : toBeDeleted) {
                field.setDeleteRevision(nextRevision.getRevisionNumber());
                List<FieldRevision> previousUnDeletedFields = this.metadataManagerDAO.getUnDeletedFieldRevsions(field);
                for (FieldRevision previousUnDeletedField : previousUnDeletedFields) {
                    previousUnDeletedField.setDeleteRevision(nextRevision.getRevisionNumber());
                    oldAsset.addFieldRevision(previousUnDeletedField, nextRevision);
                }
            }
        }
    }
}

