/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.specimpl;

import com.tandbergtv.metadatamanager.exception.TranslationException;
import com.tandbergtv.metadatamanager.spec.ITranslator;
import com.tandbergtv.metadatamanager.util.ResourceResolver;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;

public class XslTranslator
implements ITranslator {
    private String xslPath;
    private Transformer transformer;

    public void setXslPath(String xslPath) {
        this.xslPath = xslPath;
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(xslPath);
        try {
            TransformerFactory tf = TransformerFactory.newInstance("net.sf.saxon.TransformerFactoryImpl", this.getClass().getClassLoader());
            tf.setURIResolver(new ResourceResolver());
            this.transformer = tf.newTransformer(new StreamSource(is));
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Document translate(Document doc) throws TranslationException {
        DocumentBuilder dBuilder;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            dBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        Document docOut = dBuilder.newDocument();
        DOMResult result = new DOMResult(docOut);
        try {
            this.transformer.transform(new DOMSource(doc), result);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
        return docOut;
    }
}

