/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.specimpl.cl1_1;

import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.SearchCriteria;
import com.tandbergtv.metadatamanager.model.Spec;
import com.tandbergtv.metadatamanager.spec.IIdentifier;
import com.tandbergtv.metadatamanager.specimpl.SingleTitleSpecHandler;
import com.tandbergtv.metadatamanager.specimpl.cl1_1.CL1_1_Identifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CL1_1SpecHandler
extends SingleTitleSpecHandler {
    public CL1_1SpecHandler() {
        this.spec = Spec.CL1_1;
    }

    @Override
    protected IIdentifier extractId(Asset asset) {
        CL1_1_Identifier id = new CL1_1_Identifier();
        id.setSearchService(this.getSearchService());
        id.setMappingResource(this.getMappingResource());
        Map<String, String> idXPaths = id.getTTVPaths();
        HashMap<String, String> idValues = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : idXPaths.entrySet()) {
            Field f = asset.getFirstField(entry.getValue());
            if (f == null) continue;
            idValues.put(entry.getKey(), f.getValue());
        }
        id.setSpecIdentifiers(idValues);
        return id;
    }

    @Override
    protected SearchCriteria prepareSearchPathById(List<Field> fields) {
        SearchCriteria criteria = new SearchCriteria();
        CL1_1_Identifier cl1_1Id = new CL1_1_Identifier();
        cl1_1Id.setMappingResource(this.getMappingResource());
        Map<String, String> idPaths = cl1_1Id.getTTVPaths();
        for (Map.Entry<String, String> entry : idPaths.entrySet()) {
            for (Field f : fields) {
                if (!f.getTtvXPath().equals(entry.getValue())) continue;
                criteria.put(entry.getValue(), f.getValue());
            }
        }
        return criteria;
    }
}

