/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.specimpl.cl1_1;

import com.tandbergtv.metadatamanager.specimpl.IdentifierBase;
import com.tandbergtv.metadatamanager.util.MappingFileParser;
import java.util.HashMap;
import java.util.Map;

public class CL1_1_Identifier
extends IdentifierBase {
    private static final long serialVersionUID = -8112844616094249184L;
    private static String PROVIDERID_XPATH = "ADI/Metadata/AMS/Provider_ID";
    private static String ASSETID_XPATH = "ADI/Metadata/AMS/Asset_ID";
    private String providerId;
    private String assetId;

    public String getAssetId() {
        return this.assetId;
    }

    public String getProviderId() {
        return this.providerId;
    }

    @Override
    public Map<String, String> getSpecIdentifiers() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(PROVIDERID_XPATH, this.providerId);
        map.put(ASSETID_XPATH, this.assetId);
        return map;
    }

    @Override
    public Map<String, String> getTTVPaths() {
        HashMap<String, String> ttvPaths = new HashMap<String, String>();
        String assetIdXpath = MappingFileParser.getMapping(this.getMappingResource(), ASSETID_XPATH);
        if (assetIdXpath.trim().length() == 0) {
            throw new RuntimeException("Identifying field: " + ASSETID_XPATH + " cannot be mapped to TTV xpath.");
        }
        String providerIdXpath = MappingFileParser.getMapping(this.getMappingResource(), PROVIDERID_XPATH);
        if (providerIdXpath.trim().length() == 0) {
            throw new RuntimeException("Identifying field: " + PROVIDERID_XPATH + " cannot be mapped to TTV xpath.");
        }
        ttvPaths.put(ASSETID_XPATH, assetIdXpath);
        ttvPaths.put(PROVIDERID_XPATH, providerIdXpath);
        return ttvPaths;
    }

    @Override
    public boolean isValidIdentifier() {
        return this.providerId != null && !this.providerId.equals("") && this.assetId != null && !this.assetId.equals("");
    }

    public void setAssetId(String assetId) {
        this.assetId = assetId;
    }

    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }

    @Override
    public void setSpecIdentifiers(Map<String, String> identifiers) {
        if (identifiers.containsKey(ASSETID_XPATH)) {
            this.setAssetId(identifiers.get(ASSETID_XPATH));
        }
        if (identifiers.containsKey(PROVIDERID_XPATH)) {
            this.setProviderId(identifiers.get(PROVIDERID_XPATH));
        }
    }
}

