/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.specimpl.mstv;

import com.tandbergtv.metadatamanager.specimpl.IdentifierBase;
import com.tandbergtv.metadatamanager.util.MappingFileParser;
import java.util.HashMap;
import java.util.Map;

public class MSTVIdentifier
extends IdentifierBase {
    private static final long serialVersionUID = 1240862770858580776L;
    private static String PROVIDERID_XPATH = "assetPackages/assetPackage/providerID";
    private static String ASSETID_XPATH = "assetPackages/assetPackage/metadata/assetID";
    private String providerId;
    private String assetId;

    public String getProviderId() {
        return this.providerId;
    }

    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }

    public String getAssetId() {
        return this.assetId;
    }

    public void setAssetId(String assetId) {
        this.assetId = assetId;
    }

    @Override
    public Map<String, String> getSpecIdentifiers() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(PROVIDERID_XPATH, this.providerId);
        map.put(ASSETID_XPATH, this.assetId);
        return map;
    }

    @Override
    public void setSpecIdentifiers(Map<String, String> identifiers) {
        if (identifiers.containsKey(ASSETID_XPATH)) {
            this.setAssetId(identifiers.get(ASSETID_XPATH));
        }
        if (identifiers.containsKey(PROVIDERID_XPATH)) {
            this.setProviderId(identifiers.get(PROVIDERID_XPATH));
        }
    }

    @Override
    public Map<String, String> getTTVPaths() {
        HashMap<String, String> ttvPaths = new HashMap<String, String>();
        String assetIdXpath = MappingFileParser.getMapping(this.getMappingResource(), ASSETID_XPATH);
        if (assetIdXpath.trim().length() == 0) {
            throw new RuntimeException("Identifying field: " + ASSETID_XPATH + " cannot be mapped to TTV xpath.");
        }
        String providerIdXpath = MappingFileParser.getMapping(this.getMappingResource(), PROVIDERID_XPATH);
        if (providerIdXpath.trim().length() == 0) {
            throw new RuntimeException("Identifying field: " + PROVIDERID_XPATH + " cannot be mapped to TTV xpath.");
        }
        ttvPaths.put(ASSETID_XPATH, assetIdXpath);
        ttvPaths.put(PROVIDERID_XPATH, providerIdXpath);
        return ttvPaths;
    }

    @Override
    public boolean isValidIdentifier() {
        return this.providerId != null && !this.providerId.equals("") && this.assetId != null && !this.assetId.equals("");
    }
}

