/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.specimpl.mstv;

import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.SearchCriteria;
import com.tandbergtv.metadatamanager.model.Spec;
import com.tandbergtv.metadatamanager.spec.IIdentifier;
import com.tandbergtv.metadatamanager.specimpl.SingleTitleSpecHandler;
import com.tandbergtv.metadatamanager.specimpl.mstv.MSTVIdentifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MSTVSpecHandler
extends SingleTitleSpecHandler {
    public MSTVSpecHandler() {
        this.spec = Spec.MSTV;
    }

    @Override
    public SearchCriteria prepareSearchPathById(List<Field> fields) {
        SearchCriteria criteria = new SearchCriteria();
        MSTVIdentifier mstvId = new MSTVIdentifier();
        mstvId.setMappingResource(this.getMappingResource());
        Map<String, String> idPaths = mstvId.getTTVPaths();
        for (Map.Entry<String, String> entry : idPaths.entrySet()) {
            for (Field f : fields) {
                if (!f.getTtvXPath().equals(entry.getValue())) continue;
                criteria.put(entry.getValue(), f.getValue());
            }
        }
        return criteria;
    }

    @Override
    protected IIdentifier extractId(Asset asset) {
        MSTVIdentifier id = new MSTVIdentifier();
        id.setMappingResource(this.getMappingResource());
        id.setSearchService(this.getSearchService());
        HashMap<String, String> idValues = new HashMap<String, String>();
        Map<String, String> idXPaths = id.getTTVPaths();
        for (Map.Entry<String, String> entry : idXPaths.entrySet()) {
            Field f = asset.getFirstField(entry.getValue());
            if (f == null) continue;
            idValues.put(entry.getKey(), f.getValue());
        }
        id.setSpecIdentifiers(idValues);
        return id;
    }
}

