/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.specimpl.ttv;

import com.tandbergtv.metadatamanager.ITTVDataModelHandler;
import com.tandbergtv.metadatamanager.exception.MetadataException;
import com.tandbergtv.metadatamanager.exception.SearchException;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.Group;
import com.tandbergtv.metadatamanager.model.NextRevision;
import com.tandbergtv.metadatamanager.model.RootAssetRevision;
import com.tandbergtv.metadatamanager.model.SearchCriteria;
import com.tandbergtv.metadatamanager.model.Spec;
import com.tandbergtv.metadatamanager.spec.IIdentifier;
import com.tandbergtv.metadatamanager.specimpl.SpecHandlerBase;
import com.tandbergtv.metadatamanager.specimpl.ttv.TTVId;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.transaction.annotation.Transactional;

public class TTVSpecHandler
extends SpecHandlerBase
implements ITTVDataModelHandler {
    public TTVSpecHandler() {
        this.spec = Spec.TTV;
    }

    @Override
    protected IIdentifier extractId(Asset asset) {
        return asset.getTTVId();
    }

    @Override
    protected SearchCriteria prepareSearchPathById(List<Field> fields) {
        return null;
    }

    @Override
    protected Map<String, String> translate(List<String> fields) {
        HashMap<String, String> fieldsXPath = new HashMap<String, String>();
        for (String field : fields) {
            fieldsXPath.put(field, field);
        }
        return fieldsXPath;
    }

    @Override
    protected TTVId getTTVId(Asset asset, Asset rootAsset) throws SearchException {
        if (asset.getTTVId().getId() <= 0L) {
            return null;
        }
        return asset.getTTVId();
    }

    @Override
    public boolean isXPathPartOfSpec(String assetType, String ttvXPath) {
        return true;
    }

    @Override
    public void delete(TTVId id) throws SearchException {
        Asset asset = id.getAsset();
        this.logger.debug((Object)("TTV Id for: " + id.toString() + " is = " + asset.getId()));
        this.metadataManagerDAO.delete(asset);
    }

    @Override
    public Asset getAsset(TTVId id) throws SearchException {
        return this.metadataManagerDAO.getAsset(id);
    }

    @Override
    @Transactional
    public TTVId saveAsset(Asset asset) throws MetadataException {
        return this.saveAsset(asset, null, null, null);
    }

    @Override
    public Asset getAsset(TTVId id, String revision) throws SearchException {
        return this.getAssetTree(id, revision);
    }

    @Override
    @Transactional
    public List<RootAssetRevision> getRevisions(TTVId id) throws SearchException {
        Asset topLevelAsset = this.metadataManagerDAO.getAsset(id);
        if (!(topLevelAsset instanceof Group)) {
            throw new SearchException("Asset with TTVID[" + id + "] is not a top level asset, thus no revision history.");
        }
        return ((Group)topLevelAsset).getRevisions();
    }

    @Override
    public TTVId saveAsset(Asset asset, String revisionSource, String revisionComment, String externalRevision) throws MetadataException {
        if (!(asset instanceof Group)) {
            throw new MetadataException("Asset:" + asset + ", is not a top level asset, can not be saved.");
        }
        TTVId id = null;
        RootAssetRevision rootAssetRevision = new RootAssetRevision(revisionSource, revisionComment, externalRevision);
        NextRevision nextRevision = new NextRevision();
        try {
            Asset old = this.metadataManagerDAO.getAsset(new TTVId(asset.getId()));
            nextRevision.setRevisionNumber(old.getLatestRevisionNumber() + 1);
            this.mergeAsset(asset, old, true, nextRevision);
            ((Group)old).addRootAssetRevision(rootAssetRevision);
            id = this.metadataManagerDAO.saveAsset(old);
        }
        catch (SearchException e) {
            id = this.metadataManagerDAO.saveAsset(asset);
        }
        return id;
    }

    @Override
    protected boolean isAssetTypePartOfSpec(String assetType) {
        return true;
    }

    @Override
    protected boolean searchNewTargetAsset(String oldAssetType, Asset newAsset, Asset oldTargetAsset, Asset newTargetAsset) {
        Asset newTarget = newAsset.getAsset(oldTargetAsset.getTTVId().getId());
        if (newTarget != null) {
            newTargetAsset = newTarget;
            return true;
        }
        return false;
    }
}

