/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.util;

import com.tandbergtv.metadatamanager.factoryImpl.RelationFactory;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Group;
import com.tandbergtv.metadatamanager.model.Item;
import com.tandbergtv.metadatamanager.model.Relation;
import com.tandbergtv.metadatamanager.specimpl.ttv.TTVId;
import com.tandbergtv.metadatamanager.util.FieldBinder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Binder {
    private static final String TTVSPEC = "tns:TTVSpec";
    private static final String GROUP = "tns:Group";
    private static final String FIELDS = "tns:Fields";
    private static final String TTVID = "tns:TTVId";
    private static final String ID = "tns:Id";
    private static final String RELATION = "tns:Relation";
    private static final String TARGET = "tns:Target";
    private static final String ITEM = "tns:Item";
    private static final String TYPE = "type";
    private static final String XMLNS_NAME = "xmlns";
    private static final String XMLNS_VALUE = "http://www.w3.org/2000/xmlns";
    private static final String XMLNS_TNS_NAME = "xmlns:tns";
    private static final String XMLNS_TNS_VALUE = "http://www.tandbergtv.com/TTVSchema";
    private static final String XMLNS_XSI_NAME = "xmlns:xsi";
    private static final String XMLNS_XSI_VALUE = "http://www.w3.org/2000/XMLSchema-instance";
    private static final String XSI_SCHEMA_LOCATION_NAME = "xsi:schemaLocation";
    private static final String XSI_SCHEMA_LOCATION_VALUE = "http://www.tandbergtv.com/TTVSchema TTVSpec.xsd";
    private static DocumentBuilder builder;

    public static Document bind(Asset asset) {
        ArrayList<Asset> assets = new ArrayList<Asset>();
        assets.add(asset);
        return Binder.bind(assets);
    }

    public static Document bind(List<Asset> assets) {
        if (assets == null) {
            return null;
        }
        HashSet<TTVId> assetIds = new HashSet<TTVId>();
        ArrayList<Element> elements = new ArrayList<Element>();
        for (Asset asset : assets) {
            elements.add(Binder.assetRoller(assetIds, asset));
            elements.addAll(Binder.relationshipRoller(assetIds, asset.getRelations()));
        }
        Document doc = builder.newDocument();
        Element root = doc.createElementNS(XMLNS_TNS_NAME, TTVSPEC);
        root.setAttribute(XMLNS_NAME, XMLNS_VALUE);
        root.setAttributeNS(XMLNS_VALUE, XMLNS_XSI_NAME, XMLNS_XSI_VALUE);
        root.setAttributeNS(XMLNS_TNS_VALUE, XMLNS_TNS_NAME, XMLNS_TNS_VALUE);
        root.setAttributeNS(XSI_SCHEMA_LOCATION_VALUE, XSI_SCHEMA_LOCATION_NAME, XSI_SCHEMA_LOCATION_VALUE);
        doc.appendChild(root);
        for (Element element : elements) {
            if (element == null) continue;
            Node elementCopy = doc.importNode(element, true);
            root.appendChild(elementCopy);
        }
        return doc;
    }

    public static List<Asset> bind(Document doc) {
        HashMap<Long, Asset> assetMap = new HashMap<Long, Asset>();
        ArrayList<Asset> assetList = new ArrayList<Asset>();
        ArrayList<Relation> docRelations = new ArrayList<Relation>();
        NodeList nodeList = doc.getDocumentElement().getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            Asset asset = null;
            if (element.getNodeName().equals(GROUP)) {
                asset = new Group();
                ((Group)asset).setType(element.getAttribute(TYPE));
            } else {
                asset = new Item();
                ((Item)asset).setType(element.getAttribute(TYPE));
            }
            Document fieldDoc = builder.newDocument();
            Element fields = Binder.getNamedChildren(element, FIELDS).get(0);
            Element fieldsCopy = (Element)fieldDoc.importNode(fields, true);
            Element ttvIdField = Binder.getNamedChildren(fieldsCopy, TTVID).get(0);
            Element idField = Binder.getNamedChildren(ttvIdField, ID).get(0);
            long assetId = Long.parseLong(idField.getTextContent());
            asset.setTTVId(new TTVId(assetId));
            fieldsCopy.removeChild(ttvIdField);
            asset.setRelations(new ArrayList<Relation>());
            List<Relation> relations = asset.getRelations();
            for (Element relationElement : Binder.getNamedChildren(element, RELATION)) {
                String type = relationElement.getAttribute(TYPE);
                Element targetElement = Binder.getNamedChildren(relationElement, TARGET).get(0);
                Element idElement = Binder.getNamedChildren(targetElement, ID).get(0);
                String id = idElement.getTextContent();
                Relation relation = RelationFactory.getInstance(type);
                relation.setOwnerAsset(asset);
                relation.setTargetAsset(new Item(Long.parseLong(id)));
                relations.add(relation);
                docRelations.add(relation);
            }
            fieldDoc.appendChild(fieldsCopy);
            asset.setFields(FieldBinder.extractXPaths(fieldDoc));
            assetMap.put(asset.getTTVId().getId(), asset);
            assetList.add(asset);
        }
        for (Relation relation : docRelations) {
            Asset asset = (Asset)assetMap.get(relation.getTargetAsset().getTTVId().getId());
            if (asset == null) continue;
            Asset ownerAsset = relation.getOwnerAsset();
            ownerAsset.addChild(asset);
            relation.setOwnerAsset(null);
            ownerAsset.getRelations().remove(relation);
            assetList.remove(asset);
        }
        docRelations.clear();
        for (Asset a : assetList) {
            if (a.getTTVId().getId() < 0L) {
                a.setTTVId(new TTVId(0L));
            }
            for (Relation r : a.getRelations()) {
                if (r.getTargetAsset().getTTVId().getId() >= 0L) continue;
                r.getTargetAsset().setTTVId(new TTVId(0L));
            }
        }
        return assetList;
    }

    private static List<Element> getNamedChildren(Element element, String name) {
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node elementChild = children.item(i);
            if (elementChild == null || !elementChild.getNodeName().equals(name)) continue;
            result.add((Element)elementChild);
        }
        return result;
    }

    private static List<Element> relationshipRoller(Set<TTVId> ids, List<Relation> relationships) {
        ArrayList<Element> elements = new ArrayList<Element>();
        for (Relation relation : relationships) {
            Asset asset = relation.getTargetAsset();
            elements.add(Binder.assetRoller(ids, asset));
            elements.addAll(Binder.relationshipRoller(ids, asset.getRelations()));
        }
        return elements;
    }

    private static Element assetRoller(Set<TTVId> ids, Asset asset) {
        if (ids.contains(asset.getTTVId())) {
            return null;
        }
        ids.add(asset.getTTVId());
        Document doc = builder.newDocument();
        Element element = null;
        if (asset instanceof Group) {
            element = doc.createElementNS(XMLNS_TNS_NAME, GROUP);
            element.setAttributeNS(XMLNS_TNS_NAME, TYPE, ((Group)asset).getType());
        } else if (asset instanceof Item) {
            element = doc.createElementNS(XMLNS_TNS_NAME, ITEM);
            element.setAttributeNS(XMLNS_TNS_NAME, TYPE, ((Item)asset).getType());
        } else {
            return null;
        }
        NodeList sourceFieldNodes = FieldBinder.buildXml(asset.getFields()).getDocumentElement().getChildNodes();
        Element movedFields = doc.createElementNS(XMLNS_TNS_NAME, FIELDS);
        for (int i = 0; i < sourceFieldNodes.getLength(); ++i) {
            Node item = sourceFieldNodes.item(i);
            if (!(item instanceof Element)) continue;
            movedFields.appendChild(doc.importNode(item, true));
        }
        Element ttvIdEle = doc.createElementNS(XMLNS_TNS_NAME, TTVID);
        Element idEle = doc.createElementNS(XMLNS_TNS_NAME, ID);
        idEle.setTextContent("" + asset.getTTVId().getId());
        ttvIdEle.appendChild(idEle);
        movedFields.appendChild(ttvIdEle);
        element.appendChild(movedFields);
        for (Relation relation : asset.getRelations()) {
            Element relationElement = doc.createElementNS(XMLNS_TNS_NAME, RELATION);
            relationElement.setAttributeNS(XMLNS_TNS_NAME, TYPE, RelationFactory.getType(relation));
            Element targetElement = doc.createElementNS(XMLNS_TNS_NAME, TARGET);
            Element idElement = doc.createElementNS(XMLNS_TNS_NAME, ID);
            idElement.setTextContent("" + relation.getTargetAsset().getTTVId().getId());
            targetElement.appendChild(idElement);
            relationElement.appendChild(targetElement);
            element.appendChild(relationElement);
        }
        return element;
    }

    static {
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            builder = null;
        }
    }
}

