/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.util;

import com.sun.org.apache.xpath.internal.XPathAPI;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.util.ResourceResolver;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FieldBinder {
    private static DocumentBuilder builder;
    private static Transformer transformer;
    private static final String FIELDS = "tns:Fields";
    private static final String XMLNS_NAME = "xmlns";
    private static final String XMLNS_VALUE = "http://www.w3.org/2000/xmlns";
    private static final String XMLNS_TNS_NAME = "xmlns:tns";
    private static final String XMLNS_TNS_VALUE = "http://www.tandbergtv.com/TTVSchema";
    private static final String XMLNS_XSI_NAME = "xmlns:xsi";
    private static final String XMLNS_XSI_VALUE = "http://www.w3.org/2000/XMLSchema-instance";
    private static final String XSI_SCHEMA_LOCATION_NAME = "xsi:schemaLocation";
    private static final String XSI_SCHEMA_LOCATION_VALUE = "http://www.tandbergtv.com/TTVSchema TTVSpec.xsd";
    private static final String XSLT = "com/tandbergtv/metadatamanager/util/xpath.xsl";

    public static Document buildXml(List<Field> fields) {
        Document doc = builder.newDocument();
        Element root = doc.createElementNS(XMLNS_TNS_NAME, FIELDS);
        root.setAttribute(XMLNS_NAME, XMLNS_VALUE);
        root.setAttributeNS(XMLNS_VALUE, XMLNS_XSI_NAME, XMLNS_XSI_VALUE);
        root.setAttributeNS(XMLNS_TNS_VALUE, XMLNS_TNS_NAME, XMLNS_TNS_VALUE);
        root.setAttributeNS(XSI_SCHEMA_LOCATION_VALUE, XSI_SCHEMA_LOCATION_NAME, XSI_SCHEMA_LOCATION_VALUE);
        doc.appendChild(root);
        for (Field field : fields) {
            String xpath = field.getTtvXPath();
            String attribute = "";
            if (xpath.indexOf("/@") > -1) {
                attribute = xpath.replaceFirst(".*/@", "");
                xpath = xpath.replaceFirst("/@.*", "");
            }
            String[] xpathSplit = xpath.split("/");
            List<Integer> indices = field.getIndices();
            String value = field.getValue();
            String xpathPart = "";
            Node node = null;
            for (int i = 0; i < indices.size(); ++i) {
                String xpathChild = xpathSplit[i + 1];
                int index = indices.get(i);
                try {
                    NodeList nl = XPathAPI.selectNodeList(root, xpathPart + "/" + xpathChild, root);
                    int numNodes = nl.getLength();
                    if (numNodes >= index) {
                        node = nl.item(index - 1);
                    } else {
                        for (int j = 0; j < index - numNodes; ++j) {
                            Node parent = XPathAPI.selectSingleNode(root, xpathPart, root);
                            node = parent.appendChild(doc.createElementNS(XMLNS_TNS_NAME, xpathChild));
                        }
                    }
                }
                catch (TransformerException e) {
                    e.printStackTrace();
                }
                xpathPart = xpathPart + "/" + xpathChild + "[" + index + "]";
            }
            if (!attribute.equals("")) {
                ((Element)node).setAttributeNS(XMLNS_TNS_NAME, attribute, value);
                continue;
            }
            ((Element)node).setTextContent(value);
        }
        return doc;
    }

    public static List<Field> extractXPaths(Document doc) {
        String[] xpaths;
        ArrayList<Field> fields = new ArrayList<Field>();
        StringWriter sw = new StringWriter();
        StreamResult result = new StreamResult(sw);
        try {
            transformer.transform(new DOMSource(doc), result);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
        for (String xpath : xpaths = sw.toString().split("#ttv#ttv#ttv#ttv#\n")) {
            String[] indexSplit;
            if (xpath.matches("/tns:Fields\\[[0-9]*\\]/@.*")) continue;
            Field field = new Field();
            int equalSign = xpath.indexOf("=");
            String indexedXPath = xpath.substring(0, equalSign);
            field.setValue(xpath.substring(equalSign + 1));
            field.setTtvXPath(indexedXPath.replaceAll("\\[[0-9]*\\]", ""));
            ArrayList<Integer> indices = new ArrayList<Integer>();
            for (String indexStr : indexSplit = indexedXPath.split("\\[")) {
                int bracket = indexStr.indexOf("]");
                if (bracket <= -1) continue;
                indices.add(Integer.parseInt(indexStr.substring(0, bracket)));
            }
            field.setIndices(indices);
            fields.add(field);
        }
        return fields;
    }

    static {
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            builder = null;
        }
        InputStream is = FieldBinder.class.getClassLoader().getResourceAsStream(XSLT);
        try {
            TransformerFactory tf = TransformerFactory.newInstance("net.sf.saxon.TransformerFactoryImpl", FieldBinder.class.getClassLoader());
            tf.setURIResolver(new ResourceResolver());
            transformer = tf.newTransformer(new StreamSource(is));
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new RuntimeException(e);
        }
    }
}

