/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

public class MappingFileParser {
    private static String MAPPING_DELIMITER = ",";

    public static Map<String, String> readFieldMapping(String mappingResource) {
        HashMap<String, String> mappings = new HashMap<String, String>();
        BufferedReader br = new BufferedReader(new InputStreamReader(MappingFileParser.class.getClassLoader().getResourceAsStream(mappingResource)));
        try {
            String line;
            while ((line = br.readLine()) != null) {
                String[] fieldMapping = line.split(MAPPING_DELIMITER);
                mappings.put(fieldMapping[0].trim(), fieldMapping[1].trim());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return mappings;
    }

    public static String getMapping(String mappingResource, String field) {
        Map<String, String> fields = MappingFileParser.readFieldMapping(mappingResource);
        return fields.containsKey(field) ? fields.get(field) : "";
    }
}

