<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns:fn="http://www.w3.org/2005/xpath-functions"
xmlns:tns="http://www.tandbergtv.com/TTVSchema"
exclude-result-prefixes="tns fn">
<xsl:import href="com/tandbergtv/metadatamanager/specimpl/cl1_1/from/common.xsl"/>

<xsl:template match="tns:TTVSpec/tns:Item[@type = 'BARKER']">
	<Asset>
		<Metadata>
			<AMS xsl:use-attribute-sets="AmsAttributeSet" >
				<xsl:attribute name="Asset_Class">
					<xsl:choose>
							<xsl:when test="fn:normalize-space(tns:Fields/tns:AssetClass) = ''">barker</xsl:when>
							<xsl:otherwise><xsl:value-of select="tns:Fields/tns:AssetClass" /></xsl:otherwise>
						</xsl:choose>
				</xsl:attribute>
			</AMS>
			<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
				<xsl:attribute name="Name">Type</xsl:attribute>
				<xsl:attribute name="Value">barker</xsl:attribute>
			</App_Data>
			<xsl:for-each select="tns:Fields/tns:Audio">
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet AudioTypeAttribute" />
			</xsl:for-each>
			<xsl:for-each select="tns:Fields/tns:Language">
				<App_Data xsl:use-attribute-sets="LanguagesAttribute" />
			</xsl:for-each>
			<xsl:for-each select="tns:Fields/tns:SubTitleLanguage">
				<App_Data xsl:use-attribute-sets="SubTitleLanguagesAttribute" />
			</xsl:for-each>
			<xsl:for-each select="tns:Fields/tns:DubbedLanguage">
				<App_Data xsl:use-attribute-sets="DubbedLanguagesAttribute" />
			</xsl:for-each>
			<App_Data xsl:use-attribute-sets="ApplicationAttributeSet ContentFileSizeAttribute" />
			<App_Data xsl:use-attribute-sets="ApplicationAttributeSet ContentChecksumAttribute" />
		</Metadata>
		<Content xsl:use-attribute-sets="ContentAttributeSet" />
	</Asset>
</xsl:template>


</xsl:stylesheet>