<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns:fn="http://www.w3.org/2005/xpath-functions"
xmlns:tns="http://www.tandbergtv.com/TTVSchema"
exclude-result-prefixes="tns fn">
<xsl:import href="com/tandbergtv/metadatamanager/specimpl/cl1_1/from/common.xsl"/>

<xsl:template match="tns:TTVSpec/tns:Item[@type = 'BOXCOVER']">
	<Asset>
		<Metadata>
			<AMS xsl:use-attribute-sets="AmsAttributeSet" >
				<xsl:attribute name="Asset_Class">
					<xsl:choose>
						<xsl:when test="fn:normalize-space(tns:Fields/tns:AssetClass) = ''">box cover</xsl:when>
						<xsl:otherwise><xsl:value-of select="tns:Fields/tns:AssetClass" /></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</AMS>
			<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
				<xsl:attribute name="Name">Type</xsl:attribute>
				<xsl:attribute name="Value">box cover</xsl:attribute>
			</App_Data>
			<App_Data xsl:use-attribute-sets="ApplicationAttributeSet ContentFileSizeAttribute" />
			<App_Data xsl:use-attribute-sets="ApplicationAttributeSet ContentChecksumAttribute" />
			<xsl:if test="tns:Fields/tns:Image/tns:AspectRatio">
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet ImageAspectRatioAttribute" />
			</xsl:if>
		</Metadata>
		<Content xsl:use-attribute-sets="ContentAttributeSet" />
	</Asset>
</xsl:template>


</xsl:stylesheet>