<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns:fn="http://www.w3.org/2005/xpath-functions"
xmlns:tns="http://www.tandbergtv.com/TTVSchema"
exclude-result-prefixes="tns fn">
<xsl:import href="com/tandbergtv/metadatamanager/specimpl/cl1_1/from/common.xsl"/>

<xsl:template match="tns:TTVSpec/tns:Item[@type = 'PREVIEW']">
	<Asset>
		<Metadata>
			<AMS xsl:use-attribute-sets="AmsAttributeSet" >
				<xsl:attribute name="Asset_Class">
					<xsl:choose>
						<xsl:when test="fn:normalize-space(tns:Fields/tns:AssetClass) = ''">preview</xsl:when>
						<xsl:otherwise><xsl:value-of select="tns:Fields/tns:AssetClass" /></xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</AMS>
			<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
				<xsl:attribute name="Name">Type</xsl:attribute>
				<xsl:attribute name="Value">preview</xsl:attribute>
			</App_Data>
			<xsl:for-each select="tns:Fields/tns:Rating">
				<xsl:if test="tns:Value">
					<App_Data xsl:use-attribute-sets="ApplicationAttributeSet RatingAttribute" />
				</xsl:if>
				<xsl:if test="tns:MSORating">
					<App_Data xsl:use-attribute-sets="ApplicationAttributeSet MSORatingAttribute" />
				</xsl:if>
				<xsl:if test="tns:TargetAudience">
					<App_Data xsl:use-attribute-sets="ApplicationAttributeSet TargetAudienceAttribute" />
				</xsl:if>
			</xsl:for-each>
			<App_Data xsl:use-attribute-sets="ApplicationAttributeSet RunTimeAttribute" />
			<xsl:for-each select="tns:Fields/tns:Audio">
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet AudioTypeAttribute" />
			</xsl:for-each>
			<xsl:if test="tns:Fields/tns:Video/tns:ScreenFormat">
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet ScreenFormatAttribute" />
			</xsl:if>
			<xsl:if test="tns:Fields/tns:Video/tns:HDContent">
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet HDContentAttribute" />
			</xsl:if>
			<xsl:for-each select="tns:Fields/tns:Language">
				<App_Data xsl:use-attribute-sets="LanguagesAttribute" />
			</xsl:for-each>
			<xsl:for-each select="tns:Fields/tns:SubTitleLanguage">
				<App_Data xsl:use-attribute-sets="SubTitleLanguagesAttribute" />
			</xsl:for-each>
			<xsl:for-each select="tns:Fields/tns:DubbedLanguage">
				<App_Data xsl:use-attribute-sets="DubbedLanguagesAttribute" />
			</xsl:for-each>
			<xsl:if test="tns:Fields/tns:Video/tns:BitRate">
				<App_Data xsl:use-attribute-sets="ApplicationAttributeSet BitRateAttribute" />
			</xsl:if>
			<App_Data xsl:use-attribute-sets="ApplicationAttributeSet ContentFileSizeAttribute" />
			<App_Data xsl:use-attribute-sets="ApplicationAttributeSet ContentChecksumAttribute" />
		</Metadata>
		<Content xsl:use-attribute-sets="ContentAttributeSet" />
	</Asset>
</xsl:template>


</xsl:stylesheet>