<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns:fn="http://www.w3.org/2005/xpath-functions"
xmlns:tns="http://www.tandbergtv.com/TTVSchema"
exclude-result-prefixes="tns fn">
<xsl:import href="com/tandbergtv/metadatamanager/specimpl/cl1_1/from/common.xsl"/>

<xsl:output method="xml" indent="yes"/>

<xsl:template match="tns:TTVSpec/tns:Item[@type = 'TITLE']">
	<AMS xsl:use-attribute-sets="AmsAttributeSet" >
		<xsl:attribute name="Asset_Class">
			<xsl:choose>
					<xsl:when test="fn:normalize-space(tns:Fields/tns:AssetClass) = ''">title</xsl:when>
					<xsl:otherwise><xsl:value-of select="tns:Fields/tns:AssetClass" /></xsl:otherwise>
			</xsl:choose>
		</xsl:attribute>
	</AMS>
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
		<xsl:attribute name="Name">Type</xsl:attribute>
		<xsl:attribute name="Value">title</xsl:attribute>
	</App_Data>
	<xsl:if test="tns:Fields/tns:Title/tns:SortTitle">
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
		<xsl:attribute name="Name">Title_Sort_Name</xsl:attribute>
		<xsl:attribute name="Value">
			<xsl:value-of select="tns:Fields/tns:Title/tns:SortTitle" />
		</xsl:attribute>
	</App_Data>
	</xsl:if>
	<xsl:if test="tns:Fields/tns:Rights/tns:MaxViewLimit">
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
		<xsl:attribute name="Name">Subscriber_View_Limit</xsl:attribute>
		<xsl:attribute name="Value">
	    	<xsl:value-of select="tns:Fields/tns:Rights/tns:MaxViewLimit" />
		</xsl:attribute>
	</App_Data>
	</xsl:if>
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
		<xsl:attribute name="Name">Title_Brief</xsl:attribute>
		<xsl:attribute name="Value">
	    	<xsl:value-of select="tns:Fields/tns:Title/tns:ShortTitle" />
		</xsl:attribute>
	</App_Data>
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet TitleAttribute" />
	<xsl:if test="tns:Fields/tns:ISAN">
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
		<xsl:attribute name="Name">ISAN</xsl:attribute>
		<xsl:attribute name="Value">
	    	<xsl:value-of select="tns:Fields/tns:ISAN" />
		</xsl:attribute>
	</App_Data>
	</xsl:if>
	<xsl:if test="tns:Fields/tns:Episode/tns:Name">
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
		<xsl:attribute name="Name">Episode_Name</xsl:attribute>
		<xsl:attribute name="Value">
	    	<xsl:value-of select="tns:Fields/tns:Episode/tns:Name" />
		</xsl:attribute>
	</App_Data>
	</xsl:if>
	<xsl:if test="tns:Fields/tns:Episode/tns:Number">
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
		<xsl:attribute name="Name">Episode_ID</xsl:attribute>
		<xsl:attribute name="Value">
	    	<xsl:value-of select="tns:Fields/tns:Episode/tns:Number" />
		</xsl:attribute>
	</App_Data>
	</xsl:if>
	<xsl:if test="tns:Fields/tns:Summary/tns:DisplaySummary">
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
		<xsl:attribute name="Name">Summary_Long</xsl:attribute>
		<xsl:attribute name="Value">
	    	<xsl:value-of select="tns:Fields/tns:Summary/tns:DisplaySummary/tns:Value" />
		</xsl:attribute>
	</App_Data>
	</xsl:if>
	<xsl:if test="tns:Fields/tns:Summary/tns:MediumSummary">
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
		<xsl:attribute name="Name">Summary_Medium</xsl:attribute>
		<xsl:attribute name="Value">
	    	<xsl:value-of select="tns:Fields/tns:Summary/tns:MediumSummary/tns:Value" />
		</xsl:attribute>
	</App_Data>
	</xsl:if>
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet ShortSummaryAttribute" />
	<xsl:for-each select="tns:Fields/tns:Rating">
		<xsl:if test="tns:Value">
			<App_Data xsl:use-attribute-sets="RatingAttribute" />
		</xsl:if>
		<xsl:if test="tns:MSORating">
			<App_Data xsl:use-attribute-sets="MSORatingAttribute" />
		</xsl:if>
		<xsl:if test="tns:ContentAdvisory">
			<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
				<xsl:attribute name="Name">Advisories</xsl:attribute>
				<xsl:attribute name="Value">
			    	<xsl:value-of select="tns:ContentAdvisory" />
				</xsl:attribute>
			</App_Data>
		</xsl:if>
		<xsl:if test="tns:TargetAudience">
			<App_Data xsl:use-attribute-sets="TargetAudienceAttribute" />
		</xsl:if>
	</xsl:for-each>
	<xsl:if test="tns:Fields/tns:Caption">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet CaptionAttribute" />
	</xsl:if>
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet RunTimeAttribute" />
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet DisplayRunTimeAttribute" />
	<xsl:if test="tns:Fields/tns:CreationInfo/tns:PublicationDate">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet YearAttribute" />
	</xsl:if>
	<xsl:if test="tns:Fields/tns:CreationInfo/tns:Place/tns:Country">
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
		<xsl:attribute name="Name">Country_of_Origin</xsl:attribute>
		<xsl:attribute name="Value">
	    	<xsl:value-of select="tns:Fields/tns:CreationInfo/tns:Place/tns:Country" />
		</xsl:attribute>
	</App_Data>
	</xsl:if>
	<xsl:for-each select="tns:Fields/tns:Source">
		<App_Data>
			<xsl:attribute name="App">
				<xsl:value-of select="../tns:ApplicationInfo/tns:Name" />
			</xsl:attribute>

			<xsl:choose>
				<xsl:when test="tns:Contact/tns:DisplayName">
					<xsl:attribute name="Name">
						<xsl:choose>
							<xsl:when test="tns:Role/tns:Name = 'ACTOR'">Actors_Display</xsl:when>
							<xsl:when test="tns:Role/tns:Name = 'WRITER'">Writer_Display</xsl:when>
						</xsl:choose>
					</xsl:attribute>
					<xsl:attribute name="Value">
				    	<xsl:value-of select="tns:Contact/tns:DisplayName" />
					</xsl:attribute>
				</xsl:when>
				<xsl:when test="tns:Contact/tns:LastName">
					<xsl:attribute name="Name">
						<xsl:choose>
							<xsl:when test="tns:Role/tns:Name = 'ACTOR'">Actors</xsl:when>
							<xsl:when test="tns:Role/tns:Name = 'DIRECTOR'">Director</xsl:when>
							<xsl:when test="tns:Role/tns:Name = 'PRODUCER'">Producers</xsl:when>
						</xsl:choose>
					</xsl:attribute>
					<xsl:attribute name="Value">
						<xsl:choose>
							<xsl:when test="fn:normalize-space(tns:Contact/tns:FirstName) = ''">
								<xsl:value-of select="tns:Contact/tns:LastName" />							
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="tns:Contact/tns:LastName" />,<xsl:value-of select="tns:Contact/tns:FirstName"></xsl:value-of>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:attribute>
				</xsl:when>
			</xsl:choose>

		</App_Data>
	</xsl:for-each>
	<xsl:if test="tns:Fields/tns:CreationInfo/tns:Studio">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet StudioAttribute" />
	</xsl:if>
	<xsl:for-each select="tns:Fields/tns:Category">
		<App_Data xsl:use-attribute-sets="CategoryAttribute" />
	</xsl:for-each>
	<xsl:if test="tns:Fields/tns:Episode/tns:SeasonPremier">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">Season_Premiere</xsl:attribute>
			<xsl:attribute name="Value">
				<xsl:choose>
					<xsl:when test="fn:lower-case(tns:Fields/tns:Episode/tns:SeasonPremier) = 'true'">Y</xsl:when>
					<xsl:otherwise>N</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
		</App_Data>
	</xsl:if>
	<xsl:if test="tns:Fields/tns:Episode/tns:SeasonFinale">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">Season_Finale</xsl:attribute>
			<xsl:attribute name="Value">
				<xsl:choose>
					<xsl:when test="fn:lower-case(tns:Fields/tns:Episode/tns:SeasonFinale) = 'true'">Y</xsl:when>
					<xsl:otherwise>N</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
		</App_Data>
	</xsl:if>

	<xsl:for-each select="tns:Fields/tns:Genre">
	<App_Data>
		<xsl:attribute name="App">
			<xsl:value-of select="../tns:ApplicationInfo/tns:Name" />
		</xsl:attribute>
		<xsl:attribute name="Name">Genre</xsl:attribute>
		<xsl:attribute name="Value">
	    	<xsl:value-of select="tns:Value" />
		</xsl:attribute>
	</App_Data>
	</xsl:for-each>

	<xsl:if test="tns:Fields/tns:ShowType">
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
		<xsl:attribute name="Name">Show_Type</xsl:attribute>
		<xsl:attribute name="Value">
	    	<xsl:value-of select="tns:Fields/tns:ShowType" />
		</xsl:attribute>
	</App_Data>
	</xsl:if>

	<xsl:for-each select="tns:Fields/tns:Chapter">
	<App_Data>
		<xsl:attribute name="App">
			<xsl:value-of select="../tns:ApplicationInfo/tns:Name" />
		</xsl:attribute>
		<xsl:attribute name="Name">Chapter</xsl:attribute>
		<xsl:attribute name="Value">
	    	<xsl:value-of select="." />
		</xsl:attribute>
	</App_Data>
	</xsl:for-each>

	<xsl:if test="tns:Fields/tns:BoxOffice/tns:Value">
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
		<xsl:attribute name="Name">Box_Office</xsl:attribute>
		<xsl:attribute name="Value">
		    <xsl:value-of select="tns:Fields/tns:BoxOffice/tns:Value" />
		</xsl:attribute>
	</App_Data>
	</xsl:if>

	<xsl:if test="tns:Fields/tns:PropagationPriority">
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
		<xsl:attribute name="Name">Propagation_Priority</xsl:attribute>
		<xsl:attribute name="Value">
		    <xsl:value-of select="tns:Fields/tns:PropagationPriority" />
		</xsl:attribute>
	</App_Data>
	</xsl:if>

	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
		<xsl:attribute name="Name">Billing_ID</xsl:attribute>
		<xsl:attribute name="Value">
		    <xsl:value-of select="tns:Fields/tns:BillingInfo/tns:Identifier/tns:Id" />
		</xsl:attribute>
	</App_Data>
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet LicensingWindowStartAttribute" />
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet LicensingWindowEndAttribute" />
	<xsl:if test="tns:Fields/tns:Rights/tns:PreviewPeriod/tns:Duration">
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
		<xsl:attribute name="Name">Preview_Period</xsl:attribute>
		<xsl:attribute name="Value">
		    <xsl:value-of select="tns:Fields/tns:Rights/tns:PreviewPeriod/tns:Duration" />
		</xsl:attribute>
	</App_Data>
	</xsl:if>
	<xsl:if test="tns:Fields/tns:Rights/tns:HomeVideoWindow">
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
		<xsl:attribute name="Name">Home_Video_Window</xsl:attribute>
		<xsl:attribute name="Value">
		    <xsl:value-of select="tns:Fields/tns:Rights/tns:HomeVideoWindow" />
		</xsl:attribute>
	</App_Data>
	</xsl:if>
	<xsl:if test="tns:Fields/tns:Rights/tns:NewReleaseWindow">
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
		<xsl:attribute name="Name">Display_As_New</xsl:attribute>
		<xsl:attribute name="Value">
		    <xsl:value-of select="tns:Fields/tns:Rights/tns:NewReleaseWindow" />
		</xsl:attribute>
	</App_Data>
	</xsl:if>
	<xsl:if test="tns:Fields/tns:Rights/tns:DisplayAsLastChance">
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
		<xsl:attribute name="Name">Display_As_Last_Chance</xsl:attribute>
		<xsl:attribute name="Value">
		    <xsl:value-of select="tns:Fields/tns:Rights/tns:DisplayAsLastChance" />
		</xsl:attribute>
	</App_Data>
	</xsl:if>
	<xsl:if test="tns:Fields/tns:Rights/tns:MaxViewingLimit">
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
		<xsl:attribute name="Name">Maximum_Viewing_Length</xsl:attribute>
		<xsl:attribute name="Value">
		    <xsl:value-of select="tns:Fields/tns:Rights/tns:MaxViewingLimit" />
		</xsl:attribute>
	</App_Data>
	</xsl:if>
	<xsl:if test="tns:Fields/tns:Rights/tns:Contract/tns:Name">
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
		<xsl:attribute name="Name">Contract_Name</xsl:attribute>
		<xsl:attribute name="Value">
		    <xsl:value-of select="tns:Fields/tns:Rights/tns:Contract/tns:Name" />
		</xsl:attribute>
	</App_Data>
	</xsl:if>
	<xsl:if test="tns:Fields/tns:BillingInfo/tns:SuggestedPrice/tns:Value">
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
		<xsl:attribute name="Name">Suggested_Price</xsl:attribute>
		<xsl:attribute name="Value">
		    <xsl:value-of select="tns:Fields/tns:BillingInfo/tns:SuggestedPrice/tns:Value" />
		</xsl:attribute>
	</App_Data>
	</xsl:if>
	<xsl:if test="tns:Fields/tns:Distributor/tns:RoyaltyInfo/tns:RoyaltyPercent">
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
		<xsl:attribute name="Name">Distributor_Royalty_Percent</xsl:attribute>
		<xsl:attribute name="Value">
		    <xsl:value-of select="tns:Fields/tns:Distributor/tns:RoyaltyInfo/tns:RoyaltyPercent" />
		</xsl:attribute>
	</App_Data>
	</xsl:if>
	<xsl:if test="tns:Fields/tns:Distributor/tns:RoyaltyInfo/tns:RoyaltyMinimum">
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
		<xsl:attribute name="Name">Distributor_Royalty_Minimum</xsl:attribute>
		<xsl:attribute name="Value">
		    <xsl:value-of select="tns:Fields/tns:Distributor/tns:RoyaltyInfo/tns:RoyaltyMinimum" />
		</xsl:attribute>
	</App_Data>
	</xsl:if>
	<xsl:if test="tns:Fields/tns:Distributor/tns:RoyaltyInfo/tns:RoyaltyFlatRate">
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
		<xsl:attribute name="Name">Distributor_Royalty_Flat_Rate</xsl:attribute>
		<xsl:attribute name="Value">
		    <xsl:value-of select="tns:Fields/tns:Distributor/tns:RoyaltyInfo/tns:RoyaltyFlatRate" />
		</xsl:attribute>
	</App_Data>
	</xsl:if>
	<xsl:if test="tns:Fields/tns:Distributor/tns:Name">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">Distributor_Name</xsl:attribute>
			<xsl:attribute name="Value">
		    	<xsl:value-of select="tns:Fields/tns:Distributor/tns:Name" />
			</xsl:attribute>
		</App_Data>
	</xsl:if>
	<xsl:if test="tns:Fields/tns:CreationInfo/tns:Studio/tns:RoyaltyInfo/tns:RoyaltyPercent">
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
		<xsl:attribute name="Name">Studio_Royalty_Percent</xsl:attribute>
		<xsl:attribute name="Value">
		    <xsl:value-of select="tns:Fields/tns:CreationInfo/tns:Studio/tns:RoyaltyInfo/tns:RoyaltyPercent" />
		</xsl:attribute>
	</App_Data>
	</xsl:if>
	<xsl:if test="tns:Fields/tns:CreationInfo/tns:Studio/tns:RoyaltyInfo/tns:RoyaltyMinimum">
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
		<xsl:attribute name="Name">Studio_Royalty_Minimum</xsl:attribute>
		<xsl:attribute name="Value">
		    <xsl:value-of select="tns:Fields/tns:CreationInfo/tns:Studio/tns:RoyaltyInfo/tns:RoyaltyMinimum" />
		</xsl:attribute>
	</App_Data>
	</xsl:if>
	<xsl:if test="tns:Fields/tns:CreationInfo/tns:Studio/tns:RoyaltyInfo/tns:RoyaltyFlatRate">
	<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
		<xsl:attribute name="Name">Studio_Royalty_Flat_Rate</xsl:attribute>
		<xsl:attribute name="Value">
		    <xsl:value-of select="tns:Fields/tns:CreationInfo/tns:Studio/tns:RoyaltyInfo/tns:RoyaltyFlatRate" />
		</xsl:attribute>
	</App_Data>
	</xsl:if>
	<xsl:if test="tns:Fields/tns:CreationInfo/tns:Studio/tns:Name">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">Studio_Name</xsl:attribute>
			<xsl:attribute name="Value">
		    	<xsl:value-of select="tns:Fields/tns:CreationInfo/tns:Studio/tns:Name" />
			</xsl:attribute>
		</App_Data>
	</xsl:if>
	<xsl:if test="tns:Fields/tns:CreationInfo/tns:Studio/tns:Code">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">Studio_Code</xsl:attribute>
			<xsl:attribute name="Value">
		    	<xsl:value-of select="tns:Fields/tns:CreationInfo/tns:Studio/tns:Code" />
			</xsl:attribute>
		</App_Data>
	</xsl:if>
	<xsl:if test="tns:Fields/tns:ProviderQAContact">
		<App_Data xsl:use-attribute-sets="ApplicationAttributeSet">
			<xsl:attribute name="Name">Provider_QA_Contact</xsl:attribute>
			<xsl:attribute name="Value">
		    	<xsl:value-of select="tns:Fields/tns:ProviderQAContact/tns:Value" /> 
			</xsl:attribute>
		</App_Data>
	</xsl:if>
</xsl:template>

</xsl:stylesheet>