<?xml version="1.0" encoding="utf-8"?>

<iso:schema    
  xmlns="http://purl.oclc.org/dsdl/schematron" 
  xmlns:iso="http://purl.oclc.org/dsdl/schematron"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:ext="http://www.schematron.com/namespace/extensionsAndExperiments"
  queryBinding='xslt2'
  schemaVersion='ISO19757-3'>
  
  <iso:title>CL 1.1 Validation Rules</iso:title>
  
  <iso:pattern>
  	<!-- AMS Attribute rules -->
  	<iso:rule abstract="true" id="amsAttributeRules">
  		<report test="not(@Provider)">ERR-02 : Provider</report>
  		<report test="not(@Product)">ERR-02 : Product</report>
  		<report test="(@Product) and ((string-length(@Product) = 0) or (string-length(@Product) > 20))">ERR-01 : Product : 1,20</report>
  		<report test="not(@Asset_Name)">ERR-02 : Asset_Name</report>
  		<report test="(@Asset_Name) and ((string-length(@Asset_Name) = 0) or (string-length(@Asset_Name) > 50))">ERR-01 : Asset_Name : 1,50</report>
  		<report test="not(@Version_Major)">ERR-02 : Version_Major</report>
  		<report test="(@Version_Major) and (not(@Version_Major castable as xs:integer))">ERR-07 : Version_Major : Integer</report>
  		<report test="not(@Version_Minor)">ERR-02 : Version_Minor</report>
  		<report test="(@Version_Minor) and (not(@Version_Minor castable as xs:integer))">ERR-07 : Version_Minor : Integer</report>
  		<report test="not(@Description)">ERR-02 : Description</report>
  		<report test="not(@Creation_Date)">ERR-02 : Creation_Date</report>
		<report test="(@Creation_Date) and (not(@Creation_Date castable as xs:date))">ERR-07 : Creation_Date : date</report>
  		<report test="not(@Provider_ID)">ERR-02 : Provider_ID</report>
  		<report test="(@Provider_ID) and ((string-length(@Provider_ID) = 0) or (string-length(@Provider_ID) > 20))">ERR-01 : Provider_ID : 1,20</report>
  		<report test="not(@Asset_ID)">ERR-02 : Asset_ID</report>
  		<report test="(@Asset_ID) and (string-length(@Asset_ID) != 20)">ERR-01 : Asset_ID : 20,20</report>
  		<report test="(@Asset_ID) and not(matches(@Asset_ID, '^([a-z]|[A-Z]){4}[0-9]{16}$'))">ERR-07 : Asset_ID : ([a-z]|[A-Z]){4}[0-9]{16}</report>
  		<report test="not(@Asset_Class)">ERR-02 : Asset_Class</report>
  		<!-- TODO: Mapping of Asset_Class values -->
  		<report test="(@Verb) and ((string-length(@Verb) > 0) and (compare(lower-case(@Verb), 'delete') != 0)) ">ERR-04 : Verb : ''|DELETE</report>
  	</iso:rule>

	<!-- Package Level rules -->  	
  	<iso:rule context="/ADI/Metadata/AMS">
  		<extends rule="amsAttributeRules" />
  	</iso:rule>
  	<iso:rule context="/ADI/Metadata">
  		<report test="count(App_Data[@Name = 'Metadata_Spec_Version']) = 0">ERR-02 : App_Data[@Name = 'Metadata_Spec_Version']</report>
  		<report test="(@Name = 'Metadata_Spec_Version') and (compare(lower-case(@Value), 'cablelabsvod1.1') != 0)">ERR-04 : Metadata_Spec_Version : CableLabsVOD1.1</report>
  	</iso:rule>
  	<iso:rule context="/ADI/Metadata/App_Data">
  		<report test="(@Name = 'Metadata_Spec_Version') and (compare(lower-case(@Value), 'cablelabsvod1.1') != 0)">ERR-04 : Metadata_Spec_Version : CableLabsVOD1.1</report>
  	</iso:rule>
	
	
	<!-- Title Level rules -->
  	<iso:rule context="/ADI/Asset/Metadata/AMS">
  		<extends rule="amsAttributeRules" />
  	</iso:rule>
  	<iso:rule context="/ADI/Asset/Metadata">
  		<report test="count(App_Data[@Name = 'Type']) = 0">ERR-02 : App_Data[@Name = 'Type']</report>
  		<report test="count(App_Data[@Name = 'Title_Brief']) = 0">ERR-02 : App_Data[@Name = 'Title_Brief']</report>
  		<report test="count(App_Data[@Name = 'Title']) = 0">ERR-02 : App_Data[@Name = 'Title']</report>
  		<report test="count(App_Data[@Name = 'Summary_Short']) = 0">ERR-02 : App_Data[@Name = 'Summary_Short']</report>
  		<report test="count(App_Data[@Name = 'Rating']) = 0">ERR-02 : App_Data[@Name = 'Rating']</report>
  		<report test="count(App_Data[@Name = 'Run_Time']) = 0">ERR-02 : App_Data[@Name = 'Run_Time']</report>
  		<report test="count(App_Data[@Name = 'Display_Run_Time']) = 0">ERR-02 : App_Data[@Name = 'Display_Run_Time']</report>
  		<report test="count(App_Data[@Name = 'Category']) = 0">ERR-02 : App_Data[@Name = 'Category']</report>
  		<report test="count(App_Data[@Name = 'Genre']) > 5">ERR-05 : App_Data[@Name = 'Genre'] : 5</report>
  		<report test="count(App_Data[@Name = 'Billing_ID']) = 0">ERR-02 : App_Data[@Name = 'Billing_ID']</report>
  		<report test="count(App_Data[@Name = 'Licensing_Window_Start']) = 0">ERR-02 : App_Data[@Name = 'Licensing_Window_Start']</report>
  		<report test="count(App_Data[@Name = 'Licensing_Window_End']) = 0">ERR-02 : App_Data[@Name = 'Licensing_Window_End']</report>
  		<report test="(App_Data[@App = 'MOD']) and (count(App_Data[@Name = 'Preview_Period']) = 0)">ERR-02 : App_Data[@Name = 'Preview_Period']</report>
  		<report test="(App_Data[@App = 'MOD']) and (count(App_Data[@Name = 'Provider_QA_Contact']) = 0)">ERR-02 : App_Data[@Name = 'Provider_QA_Contact']</report>
  	</iso:rule>
  	<iso:rule context="/ADI/Asset/Metadata/App_Data">
  		<report test="(@Name = 'Title_Sort_Name') and (string-length(@Value) > 22) ">ERR-01 : Title_Sort_Name : 0,22</report>
  		<report test="(@Name = 'Title_Brief') and ((string-length(@Value) = 0) or (string-length(@Value) > 19)) ">ERR-01 : Title_Brief : 1,19</report>
  		<report test="(@Name = 'Title') and ((string-length(@Value) = 0) or (string-length(@Value) > 128)) ">ERR-01 : Title : 1,128</report>
  		<report test="(@Name = 'Summary_Long') and (string-length(@Value) > 4096) ">ERR-01 : Summary_Long : 0,4096</report>
  		<report test="(@Name = 'Summary_Medium') and (string-length(@Value) > 1024) ">ERR-01 : Summary_Medium : 0,1024</report>
  		<report test="(@Name = 'Summary_Short') and ((string-length(@Value) = 0) or (string-length(@Value) > 256)) ">ERR-01 : Summary_Short : 1,256</report>
  		<report test="(@Name = 'Closed_Captioning') and (not(@Value = 'Y' or @Value = 'N')) ">ERR-07 : Closed_Captioning : boolean(Y/N)</report>
  		<report test="(@Name = 'Run_Time') and (not(@Value castable as xs:time)) ">ERR-07 : Run_Time : time</report>
  		<report test="(@Name = 'Display_Run_Time') and (not(matches(@Value, '(([01][0-9])|(2[0-3]))(:[0-5][0-9])'))) ">ERR-07 : Display_Run_Time : hh:mm</report>
  		<report test="(@Name = 'Year') and (not(@Value castable as xs:gYear)) ">ERR-07 : Year : gYear</report>
  		<report test="(@Name = 'Country_of_Origin') and (not(matches(@Value, '^([a-z]|[A-Z]){2}$'))) ">ERR-07 : Country_of_Origin : ^([a-z]|[A-Z]){2}$</report>
  		<report test="(@Name = 'Actors') and (string-length(@Value) > 35) ">ERR-01 : Actors : 0,35</report>
  		<report test="(@Name = 'Actors_Display') and (string-length(@Value) > 1024) ">ERR-01 : Actors_Display : 0,1024</report>
  		<report test="(@Name = 'Writer_Display') and (string-length(@Value) > 1024) ">ERR-01 : Writer_Display : 0,1024</report>
  		<report test="(@Name = 'Director') and (string-length(@Value) > 35) ">ERR-01 : Director : 0,35</report>
  		<report test="(@Name = 'Producers') and (string-length(@Value) > 91) ">ERR-01 : Producers : 0,91</report>
  		<report test="(@Name = 'Studio') and (string-length(@Value) > 32) ">ERR-01 : Studio : 0,32</report>
  		<report test="(@Name = 'Category') and ((string-length(@Value) = 0) or (string-length(@Value) > 256)) ">ERR-01 : Category : 1,256</report> 
  		<report test="(@Name = 'Season_Premiere') and (not(@Value = 'Y' or @Value = 'N')) ">ERR-07 : Season_Premiere : boolean(Y/N)</report>
  		<report test="(@Name = 'Season_Finale') and (not(@Value = 'Y' or @Value = 'N')) ">ERR-07 : Season_Finale : boolean(Y/N)</report>
  		<let name="showTypeValues" value="'Series;Sports;Music;Ad;Miniseries;Movie;Other'"/>
  		<report test="(@Name = 'Show_Type') and (not((@Value = 'Series') or (@Value = 'Sports') or (@Value = 'Music') or (@Value = 'Ad') or (@Value = 'Miniseries')or (@Value = 'Movie') or (@Value = 'Other'))) ">ERR-04 : Show_Type : <value-of select="$showTypeValues"/></report>
  		<report test="(@Name = 'Chapter') and (string-length(@Value) > 128) ">ERR-01 : Chapter : 0,128</report>
  		<report test="(@Name = 'Box_Office') and (not(@Value castable as xs:integer)) ">ERR-07 : Box_Office : integer</report>
  		<report test="(@Name = 'Propagation_Priority') and (not((@Value castable as xs:integer) and (xsd:integer(@Value) > 0) and (xsd:integer(@Value) &lt; 11) )) ">ERR-04 : Propagation_Priority : 1-10</report>
  		<report test="(@Name = 'Billing_ID') and (not(matches(@Value, '^([0-9]|[A-Z]){1,5}$'))) ">ERR-07 : Billing_ID : ^([0-9]|[A-Z]){1,5}$</report>
  		<report test="(@Name = 'Licensing_Window_Start') and (not(@Value castable as xs:dateTime or @Value castable as xs:date or matches(@Value, '((000[1-9])|(00[1-9][0-9])|(0[1-9][0-9]{2})|([1-9][0-9]{3}))-((0[1-9])|(1[012]))-((0[1-9])|([12][0-9])|(3[01]))T(([01][0-9])|(2[0-3]))(:[0-5][0-9])'))) ">ERR-07 : Licensing_Window_Start : dateTime/date/yyyy-mm-ddThh:mm</report>
  		<report test="(@Name = 'Licensing_Window_End') and (not(@Value castable as xs:dateTime or @Value castable as xs:date or matches(@Value, '((000[1-9])|(00[1-9][0-9])|(0[1-9][0-9]{2})|([1-9][0-9]{3}))-((0[1-9])|(1[012]))-((0[1-9])|([12][0-9])|(3[01]))T(([01][0-9])|(2[0-3]))(:[0-5][0-9])'))) ">ERR-07 : Licensing_Window_End : dateTime/date/yyyy-mm-ddThh:mm</report>
  		<report test="(@Name = 'Preview_Period') and (not(@Value castable as xs:integer)) ">ERR-07 : Preview_Period : integer</report>
  		<report test="(@Name = 'Home_Video_Window') and (not(@Value castable as xs:integer)) ">ERR-07 : Home_Video_Window : integer</report>
  		<report test="(@Name = 'Display_As_New') and (not(@Value castable as xs:integer)) ">ERR-07 : Display_As_New : integer</report>
  		<report test="(@Name = 'Display_As_Last_Chance') and (not(@Value castable as xs:integer)) ">ERR-07 : Display_As_Last_Chance : integer</report>
  		<report test="(@Name = 'Maximum_Viewing_Length') and (not(matches(@Value, '((0[1-9])|([12][0-9])|(3[01]))((:[01][0-9])|(2[0-3]))(:[0-5][0-9])'))) ">ERR-07 : Maximum_Viewing_Length : DDHHMM</report>
  		<report test="(@Name = 'Suggested_Price') and (not(@Value castable as xs:decimal)) ">ERR-07 : Suggested_Price : decimal</report>
  		<report test="(@Name = 'Distributor_Royalty_Percent') and (not(@Value castable as xs:decimal)) ">ERR-07 : Distributor_Royalty_Percent : decimal</report>
  		<report test="(@Name = 'Distributor_Royalty_Minimum') and (not(@Value castable as xs:decimal)) ">ERR-07 : Distributor_Royalty_Minimum : decimal</report>
  		<report test="(@Name = 'Distributor_Royalty_Flat_Rate') and (not(@Value castable as xs:decimal)) ">ERR-07 : Distributor_Royalty_Flat_Rate : decimal</report>
  		<report test="(@Name = 'Distributor_Name') and (string-length(@Value) > 128) ">ERR-01 : Distributor_Name : 0,128</report>
  		<report test="(@Name = 'Studio_Royalty_Percent') and (not(@Value castable as xs:decimal)) ">ERR-07 : Studio_Royalty_Percent : decimal</report>
  		<report test="(@Name = 'Studio_Royalty_Minimum') and (not(@Value castable as xs:decimal)) ">ERR-07 : Studio_Royalty_Minimum : decimal</report>
  		<report test="(@Name = 'Studio_Royalty_Flat_Rate') and (not(@Value castable as xs:decimal)) ">ERR-07 : Studio_Royalty_Flat_Rate : decimal</report>
  		<report test="(@Name = 'Studio_Name') and (string-length(@Value) > 128) ">ERR-01 : Studio_Name : 0,128</report>
  		<report test="(@Name = 'Studio_Code') and (string-length(@Value) > 8) ">ERR-01 : Studio_Code : 0,8</report>
  	</iso:rule>

	<!-- Asset Level rules -->
  	<iso:rule context="/ADI/Asset/Asset/Metadata/AMS">
  		<extends rule="amsAttributeRules" />
  	</iso:rule>
  	<iso:rule context="/ADI/Asset/Asset/Metadata">
  		<!-- Common -->
  		<report test="(AMS[@Asset_Class != 'trickfile']) and (AMS[@Asset_Class != 'encrypted']) and count(App_Data[@Name = 'Type']) = 0">ERR-02 : App_Data[@Name = 'Type']</report>
  		<report test="(AMS[@Asset_Class = 'movie'] or AMS[@Asset_Class = 'preview']) and (count(App_Data[@Name = 'Audio_Type']) = 0)">ERR-02 : App_Data[@Name = 'Audio_Type']</report>
  		<report test="count(App_Data[@Name = 'Content_FileSize']) = 0">ERR-02 : App_Data[@Name = 'Content_FileSize']</report>
  		<report test="count(App_Data[@Name = 'Content_CheckSum']) = 0">ERR-02 : App_Data[@Name = 'Content_CheckSum']</report>
  		<!-- Movie -->
  		<report test="(AMS[@Asset_Class = 'movie'] and (App_Data[@Name = 'Copy_Protection'] and App_Data[@Value = 'Y']) and (App_Data[@Name = 'Copy_Protection_Verbose'] and App_Data[@Value = 'Y'])) and (count(App_Data[@Name = 'Analog_Protection_System']) = 0)">ERR-02 : App_Data[@Name = 'Analog_Protection_System']</report>
  		<report test="(AMS[@Asset_Class = 'movie'] and (App_Data[@Name = 'Copy_Protection'] and App_Data[@Value = 'Y']) and (App_Data[@Name = 'Copy_Protection_Verbose'] and App_Data[@Value = 'Y'])) and (count(App_Data[@Name = 'Encryption_Mode_Indicator']) = 0)">ERR-02 : App_Data[@Name = 'Encryption_Mode_Indicator']</report>
  		<report test="(AMS[@Asset_Class = 'movie'] and (App_Data[@Name = 'Copy_Protection'] and App_Data[@Value = 'Y']) and (App_Data[@Name = 'Copy_Protection_Verbose'] and App_Data[@Value = 'Y'])) and (count(App_Data[@Name = 'Constrained_Image_Trigger']) = 0)">ERR-02 : App_Data[@Name = 'Constrained_Image_Trigger']</report>
  		<report test="(AMS[@Asset_Class = 'movie'] and (App_Data[@Name = 'Copy_Protection'] and App_Data[@Value = 'Y']) and (App_Data[@Name = 'Copy_Protection_Verbose'] and App_Data[@Value = 'Y'])) and (count(App_Data[@Name = 'CGMS_A']) = 0)">ERR-02 : App_Data[@Name = 'CGMS_A']</report>
  		<!-- Preview -->
  		<report test="(AMS[@Asset_Class = 'preview']) and (count(App_Data[@Name = 'Rating']) = 0)">ERR-02 : App_Data[@Name = 'Rating']</report>
  		<report test="(AMS[@Asset_Class = 'preview']) and (count(App_Data[@Name = 'Run_Time']) = 0)">ERR-02 : App_Data[@Name = 'Run_Time']</report>
  		<!-- Trick -->
  		<report test="(AMS[@Asset_Class = 'trickfile']) and (count(App_Data[@Name = 'Vendor_Product']) = 0)">ERR-02 : App_Data[@Name = 'Vendor_Product']</report>
  		<report test="(AMS[@Asset_Class = 'trickfile']) and (count(App_Data[@Name = 'Trick_Mode']) = 0)">ERR-02 : App_Data[@Name = 'Trick_Mode']</report>
  		<!-- Encrypted -->
  		<report test="(AMS[@Asset_Class = 'encrypted']) and (count(App_Data[@Name = 'Receiver_Type']) = 0)">ERR-02 : App_Data[@Name = 'Receiver_Type']</report>
  	</iso:rule>
  	
  	<iso:rule context="/ADI/Asset/Asset/Metadata/App_Data">
  		<!-- Common Asset rules -->
  		<report test="(../AMS[@Asset_Class = 'movie'] or ../AMS[@Asset_Class = 'preview']) and (@Name = 'HDContent') and (not(@Value = 'Y' or @Value = 'N')) ">ERR-07 : HDContent : boolean(Y/N)</report>
  		<report test="(../AMS[@Asset_Class = 'movie'] or ../AMS[@Asset_Class = 'preview'] or ../AMS[@Asset_Class = 'barker']) and (@Name = 'Languages') and (not(matches(@Value, '^([a-z]){2}$'))) ">ERR-07 : Languages : ^([a-z]){2}$</report>
  		<report test="(../AMS[@Asset_Class = 'movie'] or ../AMS[@Asset_Class = 'preview'] or ../AMS[@Asset_Class = 'barker']) and (@Name = 'Subtitle_Languages') and (not(matches(@Value, '^([a-z]){2}$'))) ">ERR-07 : Subtitle_Languages : ^([a-z]){2}$</report>
  		<report test="(../AMS[@Asset_Class = 'movie'] or ../AMS[@Asset_Class = 'preview'] or ../AMS[@Asset_Class = 'barker']) and (@Name = 'Dubbed_Languages') and (not(matches(@Value, '^([a-z]){2}$'))) ">ERR-07 : Dubbed_Languages : ^([a-z]){2}$</report>
  		<report test="(@Name = 'Bit_Rate') and (not(@Value castable as xs:integer)) ">ERR-07 : Bit_Rate : integer</report>
  		<report test="(@Name = 'Content_FileSize') and (not((@Value castable as xs:long) and (xsd:long(@Value) > 0))) ">ERR-07 : Content_FileSize : positive integer</report>
  		<report test="(@Name = 'Content_CheckSum') and (not(matches(@Value, '^([0-9A-Fa-f]){32}')))">ERR-07 : Content_CheckSum : ^([0-9A-Fa-f]){32}</report>
  		
  		
  		<!-- Movie Asset rules -->
  		<report test="(../AMS[@Asset_Class = 'movie']) and (@Name = 'Encryption') and (not(@Value = 'Y' or @Value = 'N')) ">ERR-07 : Encryption : boolean(Y/N)</report>
  		<report test="(../AMS[@Asset_Class = 'movie']) and (@Name = 'Copy_Protection') and (not(@Value = 'Y' or @Value = 'N')) ">ERR-07 : Copy_Protection : boolean(Y/N)</report>
  		<report test="(../AMS[@Asset_Class = 'movie']) and (@Name = 'Copy_Protection_Verbose') and (not(@Value = 'Y' or @Value = 'N')) ">ERR-07 : Copy_Protection_Verbose : boolean(Y/N)</report>
  		<report test="(../AMS[@Asset_Class = 'movie']) and (@Name = 'Analog_Protection_System') and (not(matches(@Value, '^[0-3]{1}$'))) ">ERR-07 : Analog_Protection_System : ^[0-3]{1}$</report>
  		<report test="(../AMS[@Asset_Class = 'movie']) and (@Name = 'Encryption_Mode_Indicator') and (not(matches(@Value, '^[0-3]{1}$'))) ">ERR-07 : Encryption_Mode_Indicator : ^[0-3]{1}$</report>
  		<report test="(../AMS[@Asset_Class = 'movie']) and (@Name = 'Constrained_Image_Trigger') and (not(matches(@Value, '^[0-1]{1}$'))) ">ERR-07 : Constrained_Image_Trigger : ^[0-1]{1}$</report>
  		<report test="(../AMS[@Asset_Class = 'movie']) and (@Name = 'CGMS_A') and (not(matches(@Value, '^[0-3]{1}$'))) ">ERR-07 : CGMS_A : ^[0-3]{1}$</report>
  		<report test="(../AMS[@Asset_Class = 'movie']) and (@Name = 'Viewing_Can_Be_Resumed') and (not(@Value = 'Y' or @Value = 'N')) ">ERR-07 : Viewing_Can_Be_Resumed : boolean(Y/N)</report>
  		<!-- Preview Asset rules -->
  		<report test="(../AMS[@Asset_Class = 'preview']) and (@Name = 'Run_Time') and (not(@Value castable as xs:time)) ">ERR-07 : Run_Time : time</report>
  		<!-- Encrypted Asset rules -->
  		<report test="(../AMS[@Asset_Class = 'encrypted']) and (@Name = 'Receiver_Version') and (not(@Value castable as xs:integer)) ">ERR-07 : Receiver_Version : integer</report>
  		<report test="(../AMS[@Asset_Class = 'encrypted']) and (@Name = 'Encryption_Date') and (not(@Value castable as xs:date)) ">ERR-07 : Encryption_Date : date</report>
  		<report test="(../AMS[@Asset_Class = 'encrypted']) and (@Name = 'Encryption_Time') and (not(@Value castable as xs:time)) ">ERR-07 : Encryption_Time : time</report>
  		<report test="(../AMS[@Asset_Class = 'encrypted']) and (@Name = 'Encryption_Key_Block') and (string-length(@Value) > 4096) ">ERR-01 : Encryption_Key_Block : 0,4096</report>
  	</iso:rule>

  </iso:pattern>                  
</iso:schema>