<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:tns="http://www.tandbergtv.com/TTVSchema" version="1.0">
	<xsl:output method="xml" indent="yes"/>

	<!-- Encrypted -->
	<xsl:template match="AMS" mode="encrypted">
		<xsl:element name="tns:Receiver">
			<xsl:element name="tns:Type">
				<xsl:value-of select="../App_Data[@Name = 'Receiver_Type']/@Value" />
			</xsl:element>
			<xsl:apply-templates select="../*" mode="receiver_optional"/>
		</xsl:element>
		<xsl:apply-templates select="../*" mode="encrypted_optional"/>
		<xsl:if test="../App_Data[@Name = 'Asset_Encrypted'] or ../App_Data[@Name = 'Encryption_Type'] or ../App_Data[@Name = 'Encryption_Algorithm'] or ../App_Data[@Name = 'Encryption_Date'] or ../App_Data[@Name = 'Encryption_Time'] or ../App_Data[@Name = 'Encryption_System_Info'] or ../App_Data[@Name = 'Encryption_Key_Block']">
			<xsl:element name="tns:Encryption">
				<xsl:apply-templates select="../*" mode="encryption_optional"/>
			</xsl:element>
		</xsl:if>
	</xsl:template>

	<!-- encrypted_optional -->
	<xsl:template match="App_Data[@Name = 'Vendor_Name']" mode="encrypted_optional">
		<xsl:element name="tns:Vendor">
			<xsl:element name="tns:Name">
				<xsl:value-of select="@Value" />
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<xsl:template match="App_Data[@Name = 'Bit_Rate']" mode="encrypted_optional">
		<xsl:element name="tns:Video">
			<xsl:element name="tns:BitRate">
				<xsl:attribute name="value">
					<xsl:value-of select="@Value" />
				</xsl:attribute>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<xsl:template match="*" mode="encrypted_optional"/>

	<!-- receiver_optional -->
	<xsl:template match="App_Data[@Name = 'Receiver_Version']" mode="receiver_optional">
		<xsl:element name="tns:Version">
			<xsl:element name="tns:Value">
				<xsl:value-of select="@Value" />
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<xsl:template match="*" mode="receiver_optional"/>

	<!-- encryption_optional -->
	<xsl:template match="App_Data[@Name = 'Asset_Encrypted']" mode="encryption_optional">
		<xsl:element name="tns:Asset">
			<xsl:element name="tns:Identifier">
				<xsl:element name="tns:Id">
					<xsl:value-of select="@Value" />
				</xsl:element>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<xsl:template match="App_Data[@Name = 'Encryption_Type']" mode="encryption_optional">
		<xsl:element name="tns:Type">
			<xsl:value-of select="@Value" />
		</xsl:element>
	</xsl:template>
	<xsl:template match="App_Data[@Name = 'Encryption_Algorithm']" mode="encryption_optional">
		<xsl:element name="tns:Algorithm">
			<xsl:value-of select="@Value" />
		</xsl:element>
	</xsl:template>
	<xsl:template match="App_Data[@Name = 'Encryption_Date']" mode="encryption_optional">
		<xsl:element name="tns:Date">
			<xsl:value-of select="@Value" />
		</xsl:element>
	</xsl:template>
	<xsl:template match="App_Data[@Name = 'Encryption_Time']" mode="encryption_optional">
		<xsl:element name="tns:Time">
			<xsl:value-of select="@Value" />
		</xsl:element>
	</xsl:template>
	<xsl:template match="App_Data[@Name = 'Encryption_System_Info']" mode="encryption_optional">
		<xsl:element name="tns:SystemInfo">
			<xsl:value-of select="@Value" />
		</xsl:element>
	</xsl:template>
	<xsl:template match="App_Data[@Name = 'Encryption_Key_Block']" mode="encryption_optional">
		<xsl:element name="tns:KeyBlock">
			<xsl:value-of select="@Value" />
		</xsl:element>
	</xsl:template>
	<xsl:template match="*" mode="encryption_optional"/>

</xsl:stylesheet>
