<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:tns="http://www.tandbergtv.com/TTVSchema" version="1.0">
	<xsl:import href="com/tandbergtv/metadatamanager/specimpl/cl1_1/to/common.xsl"/>
	<xsl:output method="xml" indent="yes"/>

	<!-- Preview -->
	<xsl:template match="AMS" mode="preview">
		<xsl:element name="tns:Rating">
			<xsl:element name="tns:Value">
				<xsl:value-of select="../App_Data[@Name = 'Rating']/@Value" />
			</xsl:element>
			<xsl:apply-templates select="../*" mode="rating_optional"/>
		</xsl:element>
		<xsl:element name="tns:Duration">
			<xsl:element name="tns:Duration">
				<xsl:value-of select="../App_Data[@Name = 'Run_Time']/@Value" />
			</xsl:element>
		</xsl:element>
		<xsl:element name="tns:Audio">
			<xsl:element name="tns:Type">
				<xsl:value-of select="../App_Data[@Name = 'Audio_Type']/@Value" />
			</xsl:element>
		</xsl:element>
		<xsl:apply-templates select="../*" mode="language_optional"/>
		<xsl:if test="../App_Data[@Name = 'Screen_Format'] or ../App_Data[@Name = 'HDContent'] or ../App_Data[@Name = 'Bit_Rate']">
			<xsl:element name="tns:Video">
				<xsl:apply-templates select="../*" mode="video_optional"/>
			</xsl:element>
		</xsl:if>
	</xsl:template>

	<!-- rating_optional -->
	<xsl:template match="App_Data[@Name = 'MSORating']" mode="rating_optional">
		<xsl:element name="tns:MSORating">
			<xsl:value-of select="@Value" />
		</xsl:element>
	</xsl:template>
	<xsl:template match="App_Data[@Name = 'Audience']" mode="rating_optional">
		<xsl:element name="tns:TargetAudience">
			<xsl:value-of select="@Value" />
		</xsl:element>
	</xsl:template>
	<xsl:template match="*" mode="rating_optional"/>

</xsl:stylesheet>
