<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:tns="http://www.tandbergtv.com/TTVSchema" version="1.0">
	<xsl:output method="xml" indent="yes"/>

	<!-- Title -->
	<xsl:template match="AMS" mode="title">
		<tns:CreationInfo>
			<tns:CreateDate><xsl:value-of select="@Creation_Date" /></tns:CreateDate>
			<xsl:if test="../App_Data/@Name = 'Year'">
				<tns:PublicationDate><xsl:value-of select="../App_Data[@Name = 'Year']/@Value" />-01-01</tns:PublicationDate>
			</xsl:if>
			<xsl:if test="../App_Data/@Name = 'Studio' or ../App_Data/@Name = 'Studio_Name' or ../App_Data/@Name = 'Studio_Code' or ../App_Data/@Name = 'Studio_Royalty_Percent' or ../App_Data/@Name = 'Studio_Royalty_Minimum' or ../App_Data/@Name = 'Studio_Royalty_Flat_Rate'">
				<tns:Studio>
					<xsl:if test="../App_Data/@Name = 'Studio'">
						<tns:DisplayName><xsl:value-of select="../App_Data[@Name = 'Studio']/@Value" /></tns:DisplayName>
					</xsl:if>
					<xsl:if test="../App_Data/@Name = 'Studio_Name'">
						<tns:Name><xsl:value-of select="../App_Data[@Name = 'Studio_Name']/@Value" /></tns:Name>
					</xsl:if>
					<xsl:if test="../App_Data/@Name = 'Studio_Code'">
						<tns:Code><xsl:value-of select="../App_Data[@Name = 'Studio_Code']/@Value" /></tns:Code>
					</xsl:if>
					<xsl:if test="../App_Data/@Name = 'Studio_Royalty_Percent' or ../App_Data/@Name = 'Studio_Royalty_Minimum' or ../App_Data/@Name = 'Studio_Royalty_Flat_Rate'">
						<tns:RoyaltyInfo>
							<xsl:if test="../App_Data/@Name = 'Studio_Royalty_Percent'">
								<tns:RoyaltyPercent><xsl:value-of select="../App_Data[@Name = 'Studio_Royalty_Percent']/@Value" /></tns:RoyaltyPercent>
							</xsl:if>
							<xsl:if test="../App_Data/@Name = 'Studio_Royalty_Minimum'">
								<tns:RoyaltyMinimum><xsl:value-of select="../App_Data[@Name = 'Studio_Royalty_Minimum']/@Value" /></tns:RoyaltyMinimum>
							</xsl:if>
							<xsl:if test="../App_Data/@Name = 'Studio_Royalty_Flat_Rate'">
								<tns:RoyaltyFlatRate><xsl:value-of select="../App_Data[@Name = 'Studio_Royalty_Flat_Rate']/@Value" /></tns:RoyaltyFlatRate>
							</xsl:if>
						</tns:RoyaltyInfo>
					</xsl:if>
				</tns:Studio>
			</xsl:if>
			<xsl:if test="../App_Data/@Name = 'Country_of_Origin'">
				<tns:Place><tns:Country><xsl:value-of select="../App_Data[@Name = 'Country_of_Origin']/@Value" /></tns:Country></tns:Place>
			</xsl:if>
		</tns:CreationInfo>
		<xsl:if test="../App_Data/@Name = 'ISAN'">
			<tns:ISAN><xsl:value-of select="../App_Data[@Name = 'ISAN']/@Value" /></tns:ISAN>
		</xsl:if>
		<xsl:if test="../App_Data/@Name = 'Episode_Name' or ../App_Data/@Name = 'Episode_ID' or ../App_Data/@Name = 'Season_Premiere' or ../App_Data/@Name = 'Season_Finale'">
			<tns:Episode>
				<xsl:if test="../App_Data/@Name = 'Episode_Name'">
					<tns:Name><xsl:value-of select="../App_Data[@Name = 'Episode_Name']/@Value" /></tns:Name>
				</xsl:if>
				<xsl:if test="../App_Data/@Name = 'Episode_ID'">
					<tns:Number><xsl:value-of select="../App_Data[@Name = 'Episode_ID']/@Value" /></tns:Number>
				</xsl:if>
				<xsl:if test="../App_Data/@Name = 'Season_Premiere'">
					<tns:SeasonPremier>
						<xsl:if test="../App_Data[@Name = 'Season_Premiere']/@Value = 'Y'">true</xsl:if>
						<xsl:if test="../App_Data[@Name = 'Season_Premiere']/@Value = 'N'">false</xsl:if>
					</tns:SeasonPremier>
				</xsl:if>
				<xsl:if test="../App_Data/@Name = 'Season_Finale'">
					<tns:SeasonFinale>
						<xsl:if test="../App_Data[@Name = 'Season_Finale']/@Value = 'Y'">true</xsl:if>
						<xsl:if test="../App_Data[@Name = 'Season_Finale']/@Value = 'N'">false</xsl:if>
					</tns:SeasonFinale>
				</xsl:if>
			</tns:Episode>
		</xsl:if>
		<tns:Rating>
			<tns:Value><xsl:value-of select="../App_Data[@Name = 'Rating']/@Value" /></tns:Value>
			<xsl:if test="../App_Data/@Name = 'MSORating'">
				<tns:MSORating><xsl:value-of select="../App_Data[@Name = 'MSORating']/@Value" /></tns:MSORating>
			</xsl:if>
			<xsl:if test="../App_Data/@Name = 'Advisories'">
				<tns:ContentAdvisory><xsl:value-of select="../App_Data[@Name = 'Advisories']/@Value" /></tns:ContentAdvisory>
			</xsl:if>
			<xsl:if test="../App_Data/@Name = 'Audience'">
				<tns:TargetAudience><xsl:value-of select="../App_Data[@Name = 'Audience']/@Value" /></tns:TargetAudience>
			</xsl:if>
		</tns:Rating>
		<xsl:if test="../App_Data/@Name = 'Closed_Captioning'">
			<tns:Caption>
				<tns:Value>
					<xsl:if test="../App_Data[@Name = 'Closed_Captioning']/@Value = 'Y'">true</xsl:if>
					<xsl:if test="../App_Data[@Name = 'Closed_Captioning']/@Value = 'N'">false</xsl:if>
				</tns:Value>
			</tns:Caption>
		</xsl:if>
		<xsl:if test="../App_Data/@Name = 'Propagation_Priority'">
			<tns:PropagationPriority>
				<xsl:value-of select="../App_Data[@Name = 'Propagation_Priority']/@Value" />
			</tns:PropagationPriority>
		</xsl:if>
		<tns:Duration>
			<tns:Duration><xsl:value-of select="../App_Data[@Name = 'Run_Time']/@Value" /></tns:Duration>
			<tns:DisplayDuration><xsl:value-of select="../App_Data[@Name = 'Display_Run_Time']/@Value" /></tns:DisplayDuration>
		</tns:Duration>
		<tns:Title>
			<tns:DisplayTitle><xsl:value-of select="../App_Data[@Name = 'Title']/@Value" /></tns:DisplayTitle>
			<tns:ShortTitle><xsl:value-of select="../App_Data[@Name = 'Title_Brief']/@Value" /></tns:ShortTitle>
			<xsl:if test="../App_Data/@Name = 'Title_Sort_Name'">
				<tns:SortTitle><xsl:value-of select="../App_Data[@Name = 'Title_Sort_Name']/@Value" /></tns:SortTitle>
			</xsl:if>
		</tns:Title>
		<tns:Summary>
			<xsl:if test="../App_Data/@Name = 'Summary_Long'">
				<tns:DisplaySummary><tns:Value><xsl:value-of select="../App_Data[@Name = 'Summary_Long']/@Value" /></tns:Value></tns:DisplaySummary>
			</xsl:if>
			<xsl:if test="../App_Data/@Name = 'Summary_Medium'">
				<tns:MediumSummary><tns:Value><xsl:value-of select="../App_Data[@Name = 'Summary_Medium']/@Value" /></tns:Value></tns:MediumSummary>
			</xsl:if>
			<tns:ShortSummary><tns:Value><xsl:value-of select="../App_Data[@Name = 'Summary_Short']/@Value" /></tns:Value></tns:ShortSummary>
		</tns:Summary>
		<xsl:for-each select="../App_Data[@Name = 'Actors']">
			<tns:Source>
				<tns:Role>
					<tns:Name>ACTOR</tns:Name>
				</tns:Role>
				<tns:Contact>
					<xsl:choose>
						<xsl:when test="fn:contains(@Value, ',')">
							<tns:FirstName><xsl:value-of select="substring-after(@Value,',')" /></tns:FirstName>
							<tns:LastName><xsl:value-of select="substring-before(@Value,',')" /></tns:LastName>
						</xsl:when>
						<xsl:otherwise>
							<tns:LastName><xsl:value-of select="@Value" /></tns:LastName>
						</xsl:otherwise>
					</xsl:choose>
				</tns:Contact>
			</tns:Source>
		</xsl:for-each>
		<xsl:for-each select="../App_Data[@Name = 'Actors_Display']">
			<tns:Source>
				<tns:Role>
					<tns:Name>ACTOR</tns:Name>
				</tns:Role>
				<tns:Contact>
					<tns:DisplayName><xsl:value-of select="@Value" /></tns:DisplayName>
				</tns:Contact>
			</tns:Source>
		</xsl:for-each>
		<xsl:for-each select="../App_Data[@Name = 'Writer_Display']">
			<tns:Source>
				<tns:Role>
					<tns:Name>WRITER</tns:Name>
				</tns:Role>
				<tns:Contact>
					<tns:DisplayName><xsl:value-of select="@Value" /></tns:DisplayName>
				</tns:Contact>
			</tns:Source>
		</xsl:for-each>
		<xsl:for-each select="../App_Data[@Name = 'Director']">
			<tns:Source>
				<tns:Role>
					<tns:Name>DIRECTOR</tns:Name>
				</tns:Role>
				<tns:Contact>
					<xsl:choose>
						<xsl:when test="fn:contains(@Value, ',')">
							<tns:FirstName><xsl:value-of select="substring-after(@Value,',')" /></tns:FirstName>
							<tns:LastName><xsl:value-of select="substring-before(@Value,',')" /></tns:LastName>
						</xsl:when>
						<xsl:otherwise>
							<tns:LastName><xsl:value-of select="@Value" /></tns:LastName>
						</xsl:otherwise>
					</xsl:choose>
				</tns:Contact>
			</tns:Source>
		</xsl:for-each>
		<xsl:for-each select="../App_Data[@Name = 'Producers']">
			<tns:Source>
				<tns:Role>
					<tns:Name>PRODUCER</tns:Name>
				</tns:Role>
				<tns:Contact>
					<xsl:choose>
						<xsl:when test="fn:contains(@Value, ',')">
							<tns:FirstName><xsl:value-of select="substring-after(@Value,',')" /></tns:FirstName>
							<tns:LastName><xsl:value-of select="substring-before(@Value,',')" /></tns:LastName>
						</xsl:when>
						<xsl:otherwise>
							<tns:LastName><xsl:value-of select="@Value" /></tns:LastName>
						</xsl:otherwise>
					</xsl:choose>
				</tns:Contact>
			</tns:Source>
		</xsl:for-each>
		<xsl:for-each select="../App_Data[@Name = 'Genre']">
			<tns:Genre>
				<tns:Value><xsl:value-of select="@Value" /></tns:Value>
			</tns:Genre>
		</xsl:for-each>
		<xsl:if test="../App_Data/@Name = 'Show_Type'">
			<tns:ShowType><xsl:value-of select="../App_Data[@Name = 'Show_Type']/@Value" /></tns:ShowType>
		</xsl:if>
		<xsl:if test="../App_Data/@Name = 'Chapter'">
			<tns:Chapter><xsl:value-of select="../App_Data[@Name = 'Chapter']/@Value" /></tns:Chapter>
		</xsl:if>
		<tns:Rights>
			<tns:LicensingWindowStart>
				<xsl:choose>
					<xsl:when test="fn:normalize-space(../App_Data[@Name = 'Licensing_Window_Start']/@Value) = ''"></xsl:when>
					<xsl:otherwise><xsl:value-of select="substring-after(substring-after(../App_Data[@Name = 'Licensing_Window_Start']/@Value,'-'), '-')" />-<xsl:value-of select="substring-before(substring-after(../App_Data[@Name = 'Licensing_Window_Start']/@Value,'-'), '-')" />-<xsl:value-of select="substring-before(../App_Data[@Name = 'Licensing_Window_Start']/@Value,'-')" />T00:00:00</xsl:otherwise>
				</xsl:choose>
			</tns:LicensingWindowStart>
			<tns:LicensingWindowEnd>
				<xsl:choose>
					<xsl:when test="fn:normalize-space(../App_Data[@Name = 'Licensing_Window_End']/@Value) = ''"></xsl:when>
					<xsl:otherwise><xsl:value-of select="substring-after(substring-after(../App_Data[@Name = 'Licensing_Window_End']/@Value,'-'), '-')" />-<xsl:value-of select="substring-before(substring-after(../App_Data[@Name = 'Licensing_Window_End']/@Value,'-'), '-')" />-<xsl:value-of select="substring-before(../App_Data[@Name = 'Licensing_Window_End']/@Value,'-')" />T00:00:00</xsl:otherwise>
				</xsl:choose>
			</tns:LicensingWindowEnd>
			<xsl:if test="../App_Data/@Name = 'Subscriber_View_Limit'">
				<tns:MaxViewLimit><xsl:value-of select="../App_Data[@Name = 'Subscriber_View_Limit']/@Value" /></tns:MaxViewLimit>
			</xsl:if>
			<xsl:if test="../App_Data/@Name = 'Preview_Period'">
				<tns:PreviewPeriod><tns:Duration><xsl:value-of select="../App_Data[@Name = 'Preview_Period']/@Value" /></tns:Duration></tns:PreviewPeriod>
			</xsl:if>
			<xsl:if test="../App_Data/@Name = 'Home_Video_Window'">
				<tns:HomeVideoWindow><xsl:value-of select="../App_Data[@Name = 'Home_Video_Window']/@Value" /></tns:HomeVideoWindow>
			</xsl:if>
			<xsl:if test="../App_Data/@Name = 'Display_As_New'">
				<tns:NewReleaseWindow><xsl:value-of select="../App_Data[@Name = 'Display_As_New']/@Value" /></tns:NewReleaseWindow>
			</xsl:if>
			<xsl:if test="../App_Data/@Name = 'Display_As_Last_Chance'">
				<tns:DisplayAsLastChance><xsl:value-of select="../App_Data[@Name = 'Display_As_Last_Chance']/@Value" /></tns:DisplayAsLastChance>
			</xsl:if>
			<xsl:if test="../App_Data/@Name = 'Maximum_Viewing_Length'">
				<tns:MaxViewingLimit><xsl:value-of select="../App_Data[@Name = 'Maximum_Viewing_Length']/@Value" /></tns:MaxViewingLimit>
			</xsl:if>
			<xsl:if test="../App_Data/@Name = 'Contract_Name'">
				<tns:Contract>
					<tns:Name><xsl:value-of select="../App_Data[@Name = 'Contract_Name']/@Value" /></tns:Name>
				</tns:Contract>
			</xsl:if>
		</tns:Rights>
		<xsl:if test="../App_Data/@Name = 'Distributor_Name' or ../App_Data/@Name = 'Distributor_Royalty_Percent' or ../App_Data/@Name = 'Distributor_Royalty_Minimum' or ../App_Data/@Name = 'Distributor_Royalty_Flat_Rate'">
			<tns:Distributor>
				<xsl:if test="../App_Data/@Name = 'Distributor_Royalty_Percent' or ../App_Data/@Name = 'Distributor_Royalty_Minimum' or ../App_Data/@Name = 'Distributor_Royalty_Flat_Rate'">
					<tns:RoyaltyInfo>
						<xsl:if test="../App_Data/@Name = 'Distributor_Royalty_Percent'">
							<tns:RoyaltyPercent><xsl:value-of select="../App_Data[@Name = 'Distributor_Royalty_Percent']/@Value" /></tns:RoyaltyPercent>
						</xsl:if>
						<xsl:if test="../App_Data/@Name = 'Distributor_Royalty_Minimum'">
							<tns:RoyaltyMinimum><xsl:value-of select="../App_Data[@Name = 'Distributor_Royalty_Minimum']/@Value" /></tns:RoyaltyMinimum>
						</xsl:if>
						<xsl:if test="../App_Data/@Name = 'Distributor_Royalty_Flat_Rate'">
							<tns:RoyaltyFlatRate><xsl:value-of select="../App_Data[@Name = 'Distributor_Royalty_Flat_Rate']/@Value" /></tns:RoyaltyFlatRate>
						</xsl:if>
					</tns:RoyaltyInfo>
				</xsl:if>
				<xsl:if test="../App_Data/@Name = 'Distributor_Name'">
					<tns:Name><xsl:value-of select="../App_Data[@Name = 'Distributor_Name']/@Value" /></tns:Name>
				</xsl:if>
			</tns:Distributor>
		</xsl:if>
		<tns:BillingInfo>
			<tns:Identifier><tns:Id><xsl:value-of select="../App_Data[@Name = 'Billing_ID']/@Value" /></tns:Id></tns:Identifier>
			<xsl:if test="../App_Data/@Name = 'Suggested_Price'">
				<tns:SuggestedPrice>
					<tns:Value><xsl:value-of select="../App_Data[@Name = 'Suggested_Price']/@Value" /></tns:Value>
				</tns:SuggestedPrice>
			</xsl:if>
		</tns:BillingInfo>
		<xsl:if test="../App_Data/@Name = 'Box_Office'">
			<tns:BoxOffice>
				<tns:Value><xsl:value-of select="../App_Data[@Name = 'Box_Office']/@Value" /></tns:Value>
			</tns:BoxOffice>
		</xsl:if>
		<xsl:for-each select="../App_Data[@Name = 'Category']">
			<xsl:call-template name="Category">
				<xsl:with-param name="catlist" select="@Value" />
			</xsl:call-template>
		</xsl:for-each>
		<xsl:if test="../App_Data/@Name = 'Provider_QA_Contact'">
			<tns:ProviderQAContact>
				<tns:Value><xsl:value-of select="../App_Data[@Name = 'Provider_QA_Contact']/@Value" /></tns:Value>
			</tns:ProviderQAContact>
		</xsl:if>
	</xsl:template>

	<xsl:template name="Category">
		<xsl:param name="catlist" />
		<xsl:variable name="cat" select="substring-before($catlist,'/')" />
		<xsl:choose>
			<xsl:when test="string-length($cat) > 0">
				<tns:Category>
					<tns:Text><xsl:value-of select="$cat"/></tns:Text>
					<xsl:call-template name="Category">
						<xsl:with-param name="catlist">
							<xsl:value-of select="substring-after($catlist,'/')"/>
						</xsl:with-param>
					</xsl:call-template>
				</tns:Category>
			</xsl:when>
			<xsl:otherwise>
				<tns:Category>
					<tns:Text><xsl:value-of select="$catlist"/></tns:Text>
				</tns:Category>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="*" />

</xsl:stylesheet>
