<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:tns="http://www.tandbergtv.com/TTVSchema" version="1.0">
	<xsl:import href="com/tandbergtv/metadatamanager/specimpl/cl1_1/to/barker.xsl"/>
	<xsl:import href="com/tandbergtv/metadatamanager/specimpl/cl1_1/to/encrypted.xsl"/>
	<xsl:import href="com/tandbergtv/metadatamanager/specimpl/cl1_1/to/movie.xsl"/>
	<xsl:import href="com/tandbergtv/metadatamanager/specimpl/cl1_1/to/preview.xsl"/>
	<xsl:import href="com/tandbergtv/metadatamanager/specimpl/cl1_1/to/stillimage.xsl"/>
	<xsl:import href="com/tandbergtv/metadatamanager/specimpl/cl1_1/to/title.xsl"/>
	<xsl:import href="com/tandbergtv/metadatamanager/specimpl/cl1_1/to/trick.xsl"/>
	<xsl:output method="xml" indent="yes"/>
	<xsl:variable name="smallcase" select="'abcdefghijklmnopqrstuvwxyz'" />
	<xsl:variable name="uppercase" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZ'" />
	<xsl:template match="/ADI">
		<xsl:element name="tns:TTVSpec">
			<xsl:element name="tns:Group">
				<xsl:attribute name="type">PACKAGE</xsl:attribute>
				<xsl:element name="tns:Fields">
					<xsl:apply-templates select="Metadata" />
					<xsl:element name="tns:TTVId">
						<xsl:element name="tns:Id">
							<xsl:value-of select="-1"/>
						</xsl:element>
					</xsl:element>
				</xsl:element>
				<xsl:for-each select="//*/Asset">
					<xsl:element name="tns:Relation">
						<xsl:attribute name="type">PARENT_CHILD</xsl:attribute>
						<xsl:element name="tns:Target">
							<xsl:element name="tns:Id">
								<xsl:value-of select="-position() - 1" />
							</xsl:element>
						</xsl:element>
					</xsl:element>
				</xsl:for-each>
			</xsl:element>
			<xsl:for-each select="//*/Asset">
				<xsl:element name="tns:Item">
					<xsl:attribute name="type">
						<xsl:if test="not(Metadata/AMS/@Asset_Class = 'box cover' or Metadata/AMS/@Asset_Class = 'trickfile')">
							<xsl:value-of select="translate(Metadata/AMS/@Asset_Class, $smallcase, $uppercase)" />
						</xsl:if>
						<xsl:if test="Metadata/AMS/@Asset_Class = 'box cover'">BOXCOVER</xsl:if>
						<xsl:if test="Metadata/AMS/@Asset_Class = 'trickfile'">TRICK</xsl:if>
					</xsl:attribute>
					<xsl:element name="tns:Fields">
						<xsl:apply-templates select="Metadata" />
						<xsl:element name="tns:TTVId">
							<xsl:element name="tns:Id">
								<xsl:value-of select="-position() - 1"/>
							</xsl:element>
						</xsl:element>
					</xsl:element>
				</xsl:element>
			</xsl:for-each>
		</xsl:element>
	</xsl:template>

	<!-- Metadata -->
	<xsl:template match="Metadata">
		<xsl:apply-templates select="AMS" />
		<xsl:element name="tns:Content">
			<xsl:element name="tns:Size">
				<xsl:element name="tns:length">
					<xsl:value-of select="App_Data[@Name = 'Content_FileSize']/@Value" />
				</xsl:element>
			</xsl:element>
			<xsl:element name="tns:Checksum">
					<xsl:value-of select="App_Data[@Name = 'Content_CheckSum']/@Value" />
			</xsl:element>
			<xsl:element name="tns:Locator">
				<xsl:element name="tns:Uri">
					<xsl:value-of select="../Content/@Value" />
				</xsl:element>
			</xsl:element>
		</xsl:element>
		<!-- Get the first "App" attribute for App_Data -->
		<xsl:element name="tns:ApplicationInfo">
			<xsl:element name="tns:Name">
				<xsl:value-of select="App_Data/@App" />
			</xsl:element>
		</xsl:element>
	</xsl:template>

	<!-- AMS -->
	<xsl:template match="AMS">
		<xsl:element name="tns:AssetName">
			<xsl:value-of select="@Asset_Name" />
		</xsl:element>
		<xsl:element name="tns:AssetClass">
			<xsl:value-of select="@Asset_Class" />
		</xsl:element>
		<xsl:if test="not(@Asset_Class = 'title')">
			<xsl:element name="tns:CreationInfo">
				<xsl:element name="tns:CreateDate">
					<xsl:value-of select="@Creation_Date" />
				</xsl:element>
			</xsl:element>
		</xsl:if>
		<xsl:element name="tns:Description">
			<xsl:element name="tns:Text">
				<xsl:value-of select="@Description" />
			</xsl:element>
		</xsl:element>
		<xsl:element name="tns:Identifier">
			<xsl:element name="tns:Id">
				<xsl:value-of select="@Asset_ID" />
			</xsl:element>
		</xsl:element>
		<xsl:element name="tns:ProductInfo">
			<xsl:element name="tns:Name">
				<xsl:value-of select="@Product" />
			</xsl:element>
		</xsl:element>
		<xsl:element name="tns:ProviderInfo">
			<xsl:element name="tns:Identifier">
				<xsl:element name="tns:Id">
					<xsl:value-of select="@Provider_ID" />
				</xsl:element>
			</xsl:element>
			<xsl:element name="tns:Name">
				<xsl:value-of select="@Provider" />
			</xsl:element>
		</xsl:element>
		<xsl:element name="tns:Version">
			<xsl:element name="tns:Major">
				<xsl:value-of select="@Version_Major" />
			</xsl:element>
			<xsl:element name="tns:Minor">
				<xsl:value-of select="@Version_Minor" />
			</xsl:element>
		</xsl:element>
		<xsl:if test="@Verb">
			<xsl:element name="tns:Verb">
				<xsl:value-of select="@Verb" />
			</xsl:element>
		</xsl:if>

		<xsl:if test="@Asset_Class = 'package'">
			<xsl:apply-templates select="." mode="package" />
		</xsl:if>
		<xsl:if test="@Asset_Class = 'title'">
			<xsl:apply-templates select="." mode="title" />
		</xsl:if>
		<xsl:if test="@Asset_Class = 'movie'">
			<xsl:apply-templates select="." mode="movie" />
		</xsl:if>
		<xsl:if test="@Asset_Class = 'box cover' or @Asset_Class = 'poster'">
			<xsl:apply-templates select="." mode="stillimage" />
		</xsl:if>
		<xsl:if test="@Asset_Class = 'preview'">
			<xsl:apply-templates select="." mode="preview" />
		</xsl:if>
		<xsl:if test="@Asset_Class = 'trickfile'">
			<xsl:apply-templates select="." mode="trick" />
		</xsl:if>
		<xsl:if test="@Asset_Class = 'encrypted'">
			<xsl:apply-templates select="." mode="encrypted" />
		</xsl:if>
		<xsl:if test="@Asset_Class = 'barker'">
			<xsl:apply-templates select="." mode="barker" />
		</xsl:if>
	</xsl:template>

	<!-- Package -->
	<xsl:template match="AMS" mode="package">
		<xsl:if test="../App_Data/@Name = 'Provider_Content_Tier'">
			<xsl:element name="tns:ProviderContentTier">
				<xsl:element name="tns:Value">
					<xsl:value-of select="../App_Data[@Name = 'Provider_Content_Tier']/@Value" />
				</xsl:element>
			</xsl:element>
		</xsl:if>
		<xsl:element name="tns:MetadateSpecVersion">
			<xsl:value-of select="../App_Data[@Name = 'Metadata_Spec_Version']/@Value" />
		</xsl:element>
	</xsl:template>

</xsl:stylesheet>
