<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:tns="http://www.tandbergtv.com/TTVSchema" version="1.0">
	<xsl:import href="com/tandbergtv/metadatamanager/specimpl/cl1_1/to/common.xsl"/>
	<xsl:output method="xml" indent="yes"/>

	<!-- Trick -->
	<xsl:template match="AMS" mode="trick">
		<xsl:element name="tns:Vendor">
			<xsl:element name="tns:Product">
				<xsl:value-of select="../App_Data[@Name = 'Vendor_Product']/@Value" />
			</xsl:element>
			<xsl:apply-templates select="../*" mode="vendor_optional"/>
		</xsl:element>
		<xsl:element name="tns:TrickMode">
			<xsl:value-of select="../App_Data[@Name = 'Trick_Mode']/@Value" />
		</xsl:element>
		<xsl:if test="../App_Data[@Name = 'Bit_Rate']">
			<xsl:element name="tns:Video">
				<xsl:apply-templates select="../App_Data[@Name = 'Bit_Rate']" mode="video_optional"/>
			</xsl:element>
		</xsl:if>
	</xsl:template>

	<!-- vendor_optional -->
	<xsl:template match="App_Data[@Name = 'Vendor_Name']" mode="vendor_optional">
		<xsl:element name="tns:Name">
			<xsl:value-of select="@Value" />
		</xsl:element>
	</xsl:template>
	<xsl:template match="App_Data[@Name = 'For_Version']" mode="vendor_optional">
		<xsl:element name="tns:ForVersion">
			<xsl:value-of select="@Value" />
		</xsl:element>
	</xsl:template>
	<xsl:template match="*" mode="vendor_optional"/>

</xsl:stylesheet>
