<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns:tns="http://www.tandbergtv.com/TTVSchema"
exclude-result-prefixes="tns">
<xsl:import href="com/tandbergtv/metadatamanager/specimpl/mstv/from/rating.xsl"/>

<xsl:template match="tns:TTVSpec/tns:Item[@type = 'MOVIE' or @type = 'PREVIEW' or @type = 'POSTER']">
	<asset>
		<xsl:attribute name="asset_name">
			<xsl:value-of select="tns:Fields/tns:AssetName" />
		</xsl:attribute>
		<xsl:attribute name="type"><xsl:if test="@type = 'MOVIE'"><xsl:text>feature</xsl:text></xsl:if><xsl:if test="@type = 'PREVIEW'"><xsl:text>trailer</xsl:text></xsl:if><xsl:if test="@type = 'POSTER'"><xsl:text>poster</xsl:text></xsl:if></xsl:attribute>
		<xsl:if test="tns:Fields/tns:Profile">
			<xsl:attribute name="profile">
				<xsl:value-of select="tns:Fields/tns:Profile" />
			</xsl:attribute>
		</xsl:if>
		<xsl:if test="tns:Fields/tns:ProductInfo/tns:Name">
			<xsl:attribute name="product">
				<xsl:value-of select="tns:Fields/tns:ProductInfo/tns:Name" />
			</xsl:attribute>
		</xsl:if>
		<xsl:if test="tns:Fields/tns:AutoImport">
			<xsl:attribute name="autoImport">
				<xsl:value-of select="tns:Fields/tns:AutoImport" />
			</xsl:attribute>
		</xsl:if>
		<xsl:if test="tns:Fields/tns:AutoDeploy">
			<xsl:attribute name="autoDeploy">
				<xsl:value-of select="tns:Fields/tns:AutoDeploy" />
			</xsl:attribute>
		</xsl:if>
		<xsl:if test="tns:Fields/tns:AutoDelete">
			<xsl:attribute name="autoDelete">
				<xsl:value-of select="tns:Fields/tns:AutoDelete" />
			</xsl:attribute>
		</xsl:if>
		<xsl:if test="tns:Fields/tns:Verb">
			<xsl:attribute name="verb">
				<xsl:value-of select="tns:Fields/tns:Verb" />
			</xsl:attribute>
		</xsl:if>
		<metadata>
			<assetID>
				<xsl:value-of select="tns:Fields/tns:Identifier/tns:Id" />
			</assetID>
			<xsl:if test="tns:Fields/tns:ProviderInfo/tns:Identifier/tns:Id">
				<providerID>
					<xsl:value-of select="tns:Fields/tns:ProviderInfo/tns:Identifier/tns:Id" />
				</providerID>
			</xsl:if>
			<xsl:if test="tns:Fields/tns:Video/tns:ScreenFormat">
				<screenFormat>
					<xsl:value-of select="tns:Fields/tns:Video/tns:ScreenFormat" />
				</screenFormat>
			</xsl:if>
			<xsl:if test="tns:Fields/tns:Video/tns:HDContent">
				<HD>
					<xsl:value-of select="tns:Fields/tns:Video/tns:HDContent" />
				</HD>
			</xsl:if>
			<xsl:for-each select="tns:Fields/tns:Language">
				<language_iso639>
					<xsl:value-of select="@value" />
				</language_iso639>
			</xsl:for-each>
			<xsl:for-each select="tns:Fields/tns:Audio">
				<audio>
					<xsl:value-of select="tns:Type" />
				</audio>
			</xsl:for-each>
			<xsl:apply-templates select="tns:Fields/tns:Rating" />
			<xsl:for-each select="tns:Fields/tns:SubTitleLanguage">
				<subtitleLanguage_iso639>
					<xsl:value-of select="@value" />
				</subtitleLanguage_iso639>
			</xsl:for-each>
			<xsl:for-each select="tns:Fields/tns:DubbedLanguage">
				<dubbedLanguage_iso639>
					<xsl:value-of select="@value" />
				</dubbedLanguage_iso639>
			</xsl:for-each>
		</metadata>
		<content><xsl:value-of select="tns:Fields/tns:Content/tns:Locator/tns:Uri" /></content>
	</asset>
</xsl:template>
</xsl:stylesheet>
