<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns:tns="http://www.tandbergtv.com/TTVSchema"
exclude-result-prefixes="tns">
<xsl:import href="com/tandbergtv/metadatamanager/specimpl/mstv/from/title.xsl"/>
<xsl:import href="com/tandbergtv/metadatamanager/specimpl/mstv/from/asset.xsl"/>
<xsl:import href="com/tandbergtv/metadatamanager/specimpl/mstv/from/rules.xsl"/>
<xsl:import href="com/tandbergtv/metadatamanager/specimpl/mstv/from/categoryTheme.xsl"/>

<xsl:template match="/">
	<assetPackages xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema">
		<xsl:if test="tns:TTVSpec/tns:Group/tns:Fields/tns:OriginalFile/tns:Path">
			<xsl:element name="originalADIFile">
				<xsl:value-of select="tns:TTVSpec/tns:Group/tns:Fields/tns:OriginalFile/tns:Path" />
			</xsl:element>
		</xsl:if>
		<xsl:element name="assetPackage">
			<xsl:attribute name="asset_name">
				<xsl:value-of select="tns:TTVSpec/tns:Item[@type = 'TITLE']/tns:Fields/tns:AssetName" />
			</xsl:attribute>
			<xsl:attribute name="type">
				<xsl:value-of select="tns:TTVSpec/tns:Item[@type = 'TITLE']/tns:Fields/tns:ContentType/tns:ContentType" />
			</xsl:attribute>
			<xsl:attribute name="providerID">
				<xsl:value-of select="tns:TTVSpec/tns:Group[@type = 'PACKAGE']/tns:Fields/tns:ProviderInfo/tns:Identifier/tns:Id" />
			</xsl:attribute>
			<xsl:if test="tns:TTVSpec/tns:Group[@type = 'PACKAGE']/tns:Fields/tns:ProviderInfo/tns:Name">
				<xsl:attribute name="providerName">
					<xsl:value-of select="tns:TTVSpec/tns:Group[@type = 'PACKAGE']/tns:Fields/tns:ProviderInfo/tns:Name" />
				</xsl:attribute>
			</xsl:if>
			<xsl:if test="tns:TTVSpec/tns:Item[@type = 'TITLE']/tns:Fields/tns:Name">
				<xsl:attribute name="name">
					<xsl:value-of select="tns:TTVSpec/tns:Item[@type = 'TITLE']/tns:Fields/tns:Name" />
				</xsl:attribute>
			</xsl:if>
			<xsl:if test="tns:TTVSpec/tns:Item[@type = 'TITLE']/tns:Fields/tns:Verb">
				<xsl:attribute name="verb">
					<xsl:value-of select="tns:TTVSpec/tns:Item[@type = 'TITLE']/tns:Fields/tns:Verb" />
				</xsl:attribute>
			</xsl:if>
			<xsl:if test="tns:TTVSpec/tns:Item[@type = 'TITLE']/tns:Fields/tns:ProductInfo/tns:Name">
				<xsl:attribute name="product">
					<xsl:value-of select="tns:TTVSpec/tns:Item[@type = 'TITLE']/tns:Fields/tns:ProductInfo/tns:Name" />
				</xsl:attribute>
			</xsl:if>
			<xsl:apply-templates select="tns:TTVSpec/tns:Item[@type = 'TITLE']" />
			<xsl:apply-templates select="tns:TTVSpec/tns:Item[@type = 'MOVIE' or @type = 'PREVIEW' or @type = 'POSTER']" />
			<xsl:apply-templates select="tns:TTVSpec/tns:Item[@type = 'TITLE']/tns:Fields/tns:CategoryTheme" />
			<xsl:apply-templates select="tns:TTVSpec/tns:Item[@type = 'TITLE']/tns:Fields/tns:RulesApplied" />
			<xsl:apply-templates select="tns:TTVSpec/tns:Item[@type = 'TITLE']/tns:Fields/tns:Rule" />
		</xsl:element>
	</assetPackages>
</xsl:template>

</xsl:stylesheet>
