<?xml version="1.0" encoding="utf-8"?>

<iso:schema    
  xmlns="http://purl.oclc.org/dsdl/schematron" 
  xmlns:iso="http://purl.oclc.org/dsdl/schematron"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:ext="http://www.schematron.com/namespace/extensionsAndExperiments"
  queryBinding='xslt2'
  schemaVersion='ISO19757-3'>                  
  
  <iso:title>MSTV Spec Vaildations</iso:title>

 <iso:pattern>
  <!-- package element checks -->	
  <iso:rule context="/assetPackages/assetPackage">
  	<!-- asset name checks -->
  	<iso:report test="not(@asset_name)">ERR-02 : asset_name</iso:report>                                
    <iso:report test="(@asset_name) and (string-length(@asset_name) = 0) or (string-length(@asset_name) > 255)">ERR-01 : asset_name : 1,255</iso:report>  
    
    <!-- provider Id checks -->
    <iso:report test="not(@providerID)">ERR-02 : providerID</iso:report>
    <iso:report test="(@providerID) and ((string-length(@providerID) = 0) or (string-length(@providerID) > 50))">ERR-01 : providerID : 1,50</iso:report>  
    <iso:report test="(@providerID) and not((matches(@providerID, '^([a-zA-Z0-9.])*$')))">ERR-07 : providerID : [a-zA-Z0-9.]</iso:report>  

    <!-- providerName checks -->
    <iso:report test="(@providerName) and ((string-length(@providerName) = 0) or (string-length(@providerName) > 50))">ERR-01 : providerName : 1,50</iso:report>  
    
    <!-- type check -->
    <iso:report test="not(@type)">ERR-02 : type</iso:report>
    <iso:report test="not((@type='VOD') or (@type='SVOD') or (@type='MOD') or (@type='WMSVOD') or (@type='RDP') or (@type='SRDP'))">ERR-04 : type : VOD;SVOD;MOD;WMSVOD;RDP;SRDP</iso:report>
    
    <!-- name if type = SVOD -->
    <iso:report test="(@type = 'SVOD' and not(@name))">ERR-03 : name : type is SVOD</iso:report>
    <iso:report test="(@type = 'SVOD' and string-length(@name) = 0)">ERR-09 : name : name,metadata/category</iso:report>
    <iso:report test="(@type = 'SVOD' and (string-length(@name) &gt; 0) and (contains(./metadata/category[1], '/')) and not(substring-before(./metadata/category[1], '/') = @name))">ERR-09 : name : name,metadata/category</iso:report>
    <iso:report test="(@type = 'SVOD' and (string-length(@name) &gt; 0) and (not(contains(./metadata/category[1], '/'))) and (compare(./metadata/category[1], @name) != 0))">ERR-09 : name : name,metadata/category</iso:report>

	<!-- metadata element -->
    <iso:report test="count(metadata) = 0">ERR-02 : metadata</iso:report>
    <iso:report test="count(metadata) > 1">ERR-05 : metadata : 1</iso:report>    
    
	<!-- businessMetadata element -->
    <iso:report test="count(businessMetadata) = 0">ERR-02 : businessMetadata</iso:report>
    <iso:report test="count(businessMetadata) > 1">ERR-05 : businessMetadata : 1</iso:report>
        
	<!-- rightsMetadata element -->
    <iso:report test="count(rightsMetadata) = 0">ERR-02 : rightsMetadata</iso:report>
    <iso:report test="count(rightsMetadata) > 1">ERR-05 : rightsMetadata : 1</iso:report>

    <!-- verb check -->
    <iso:report test="@verb and not((@verb='') or (@verb='DELETE'))">ERR-04 : verb : DELETE or null</iso:report>
    
  	<iso:report test="(count(rulesapplied) = 1) and (not(string(lower-case(rulesapplied)) castable as xs:boolean))">ERR-07 : rulesapplied : boolean</iso:report>
    
  </iso:rule>
  
  <!-- metadata title checks -->
  <iso:rule context="/assetPackages/assetPackage/metadata/title[1]">
  	<iso:report test="(string-length(text()) = 0) or (string-length(text()) > 500)">ERR-01 : title : 1,500</iso:report>
  	<iso:report test="not(@language)">ERR-02 : language</iso:report>
  </iso:rule>
 
  <iso:rule context="/assetPackages/assetPackage/metadata/title[1]/@language">
  	 <extends rule="languageCheck" /> 
  </iso:rule> 

  <!-- sort title checks -->
  <iso:rule context="/assetPackages/assetPackage/metadata/sortTitle[1]">
  	<iso:report test="string-length(text()) > 100">ERR-01 : sortTitle : 0,100</iso:report>
  	<iso:report test="not(@language)">ERR-02 : language</iso:report>
  </iso:rule>
  
  <iso:rule context="/assetPackages/assetPackage/metadata/sortTitle[1]/@language">
  	 <extends rule="languageCheck" /> 
  </iso:rule>
  
  <!-- reduced title checks -->
  <iso:rule context="/assetPackages/assetPackage/metadata/reducedTitle[1]">
  	<iso:report test="string-length(text()) > 100">ERR-01 : reducedTitle : 0,100</iso:report>
  	<iso:report test="not(@language)">ERR-02 : language</iso:report>
  </iso:rule>
  
  <iso:rule context="/assetPackages/assetPackage/metadata/reducedTitle[1]/@language">
  	 <extends rule="languageCheck" /> 
  </iso:rule>  
  
  <!-- original title checks -->
  <iso:rule context="/assetPackages/assetPackage/metadata/originalTitle[1]">
  	<iso:report test="string-length(text()) > 255">ERR-01 : originalTitle : 0,255</iso:report>
  	<iso:report test="not(@language)">ERR-02 : language</iso:report>
  </iso:rule>
  
  <iso:rule context="/assetPackages/assetPackage/metadata/originalTitle[1]/@language">
  	 <extends rule="languageCheck" /> 
  </iso:rule>  
  
  <!-- summary checks -->
  <iso:rule context="/assetPackages/assetPackage/metadata/summary[1]">
  	<iso:report test="(string-length(text()) = 0) or (string-length(text()) > 1024)">ERR-01 : summary : 1,1024</iso:report>
  	<iso:report test="not(@language)">ERR-02 : language</iso:report>
  </iso:rule>
  
  <iso:rule context="/assetPackages/assetPackage/metadata/summary[1]/@language">
  	 <extends rule="languageCheck" /> 
  </iso:rule>
  
  <!-- short summary checks -->
  <iso:rule context="/assetPackages/assetPackage/metadata/shortSummary[1]">
  	<iso:report test="string-length(text()) > 255">ERR-01 : shortSummary : 0,255</iso:report>
  	<iso:report test="not(@language)">ERR-02 : language</iso:report>
  </iso:rule>
  
  <iso:rule context="/assetPackages/assetPackage/metadata/shortSummary[1]/@language">
  	 <extends rule="languageCheck" /> 
  </iso:rule>  
  
  <!-- episode title checks -->
  <iso:rule context="/assetPackages/assetPackage/metadata/episodeTitle[1]">
  	<iso:report test="string-length(text()) > 255">ERR-01 : episodeTitle : 0,255</iso:report>
  	<iso:report test="not(@language)">ERR-02 : language</iso:report>
  </iso:rule>
  
  <iso:rule context="/assetPackages/assetPackage/metadata/episodeTitle[1]/@language">
  	 <extends rule="languageCheck" /> 
  </iso:rule>
  
  <!-- episode number checks -->
  <iso:rule context="/assetPackages/assetPackage/metadata/episodeNumber[1]">
   	<iso:report test="string-length(text()) > 50">ERR-01 : episodeNumber : 0,50</iso:report>
  </iso:rule>
  
  <!-- metadata element checks -->  
  <iso:rule context="/assetPackages/assetPackage/metadata">
    <!-- assetID checks -->
    <iso:report test="count(assetID) = 0">ERR-02 : assetID</iso:report>
    <iso:report test="count(assetID) > 1">ERR-05 : assetID : 1</iso:report>
    <iso:report test="(string-length(assetID) = 0) or (string-length(assetID) > 50)">ERR-01 : assetID : 1,50</iso:report>
    <iso:report test="(assetID) and not((matches(assetID, '^([a-zA-Z0-9.])*$')))">ERR-07 : assetID : [a-zA-Z0-9.]</iso:report>  
  
  
    <!-- title checks -->
    <iso:report test="count(title) = 0">ERR-02 : title</iso:report>
    <iso:report test="count(title) > 1">ERR-05 : title : 1</iso:report>
  	
  	<!-- sort title checks -->
    <iso:report test="count(sortTitle) > 1">ERR-05 : sortTitle : 1</iso:report>    

  	<!-- reduced title checks -->
    <iso:report test="count(reducedTitle) > 1">ERR-05 : reducedTitle : 1</iso:report>    

  	<!-- original title checks -->
    <iso:report test="count(originalTitle) > 1">ERR-05 : originalTitle : 1</iso:report>    

    <!-- summary checks -->
    <iso:report test="count(summary) = 0">ERR-02 : summary</iso:report>
    <iso:report test="count(summary) > 1">ERR-05 : summary : 1</iso:report>    

    <!-- short summary checks -->
    <iso:report test="count(shortSummary) > 1">ERR-05 : shortSummary : 1</iso:report>    
  	
  	<!-- episode title checks -->
    <iso:report test="count(episodeTitle) > 1">ERR-05 : episodeTitle : 1</iso:report>    
  	
  	<!-- episode number checks -->
  	<iso:report test="count(episodeNumber) > 1">ERR-05 : episodeNumber : 1</iso:report>
  	
  	<!-- macrovisionLevel checks -->
  	<iso:report test="count(macrovisionLevel) > 1">ERR-05 : macrovisionLevel : 1</iso:report>
  	<iso:report test="(count(macrovisionLevel) = 1) and (not((macrovisionLevel/text()='none') or (macrovisionLevel/text()='level1') or (macrovisionLevel/text()='level2') or (macrovisionLevel/text()='level3')))">ERR-04 : macrovisionLevel : none;level1;level2;level3</iso:report>
  	
  	<!-- cgmsaLevel checks -->
  	<iso:report test="count(cgmsaLevel) > 1">ERR-05 : cgmsaLevel : 1</iso:report>
  	<iso:report test="(count(cgmsaLevel) = 1) and (not((cgmsaLevel/text()='copyfreely') or (cgmsaLevel/text()='copynomore') or (cgmsaLevel/text()='copyonce') or (cgmsaLevel/text()='copynever')))">ERR-04 : cgmsaLevel : copyfreely;copynomore;copyonce;copynever</iso:report>
  	
  	<!-- disableHDCP checks -->
  	<iso:report test="count(disableHDCP) > 1">ERR-05 : disableHDCP : 1</iso:report>
  	<iso:report test="(count(disableHDCP) = 1) and (not(string(lower-case(disableHDCP)) castable as xs:boolean))">ERR-07 : disableHDCP : boolean</iso:report>
  	 
  	<!-- Rating checks -->
  	<iso:report test="count(rating) = 0">ERR-02 : rating</iso:report>
    
    <!-- categorization checks -->
    <iso:report test="count(categorization) = 0">ERR-02 : categorization</iso:report>
    
    <!-- runTimeMinutes checks -->      
    <iso:report test="count(runTimeMinutes) > 1">ERR-05 : runTimeMinutes : 1</iso:report>
    <iso:report test="(count(runTimeMinutes) = 1) and (not(string(runTimeMinutes) castable as xs:unsignedShort))">ERR-07 : runTimeMinutes : short</iso:report>
    
    <!-- Release year -->
    <iso:report test="count(release_year) > 1">ERR-05 : release_year : 1</iso:report>
    <iso:report test="(count(release_year) = 1) and (not(string(release_year) castable as xs:gYear)  or not(string-length(release_year) = 4))">ERR-07 : release_year : gYear (length 4) </iso:report>
    
    <!-- countryRegionCode checks -->
    <iso:report test="count(countryRegionCode) > 1">ERR-05 : countryRegionCode : 1</iso:report>
    <iso:report test="(count(countryRegionCode) = 1) and (not(matches(countryRegionCode/text(), '^[A-Z,a-z]{2}$')))" >ERR-07 : countryRegionCode : [A-Z or a-z]{2}</iso:report>
  	
  	<!-- person checks -->
    <iso:report test="count(person) > 100">ERR-05 : person : 100</iso:report>
    
    <!-- studio checks -->
    <iso:report test="count(studio) > 1">ERR-05 : studio : 1</iso:report>
    <iso:report test="(count(studio) = 1) and (string-length(studio/text()) > 50)">ERR-01 : studio : 0,50</iso:report>
  	
  	<!-- category checks -->
  	<iso:report test="count(category) = 0">ERR-02 : category</iso:report>
  	<iso:report test="count(category) > 100">ERR-05 : category : 100</iso:report>
  	 
  	<!-- pipurl --> 
  	<iso:report test="count(pipurl) > 0 and ((../@type='VOD') or (../@type='RDP'))">ERR-06 : pipurl : type='VOD' or type='RDP'</iso:report>
  	
  	<!-- importPriority checks -->
  	<iso:report test="count(importPriority) > 1">ERR-05 : importPriority : 1</iso:report>
  	<iso:report test="(count(importPriority) = 1) and not(matches(importPriority/text(), '^[0-9]{1,2}$'))">ERR-07 : importPriority : integer</iso:report>
  	<iso:report test="(count(importPriority) = 1) and (matches(importPriority/text(), '^[0-9]{1,2}$')) and ((importPriority &lt; 1) or (importPriority &gt; 10))">ERR-10 : importPriority : 1,10</iso:report>  
  	
  	<!-- autoImport checks -->
  	<iso:report test="count(autoImport) > 1">ERR-05 : autoImport : 1</iso:report>
  	<iso:report test="(count(autoImport) = 1) and (not(string(lower-case(autoImport)) castable as xs:boolean))">ERR-07 : autoImport : boolean</iso:report>

  	<!-- autoDeploy checks -->
  	<iso:report test="count(autoDeploy) > 1">ERR-05 : autoDeploy : 1</iso:report>
  	<iso:report test="(count(autoDeploy) = 1) and (not(string(lower-case(autoDeploy)) castable as xs:boolean))">ERR-07 : autoDeploy : boolean</iso:report>

  	<!-- autoDelete checks -->
  	<iso:report test="count(autoDelete) > 1">ERR-05 : autoDelete : 1</iso:report>
  	<iso:report test="(count(autoDelete) = 1) and (not(string(lower-case(autoDelete)) castable as xs:boolean))">ERR-07 : autoDelete : boolean</iso:report>
   </iso:rule>
   
   <iso:rule abstract="true" id="ratingRules">
	    <iso:report test="not(@rating_system)">ERR-02 : rating_system</iso:report>
	    <iso:report test="not(@value)">ERR-02 : value</iso:report>
   </iso:rule>
   
   <!-- Rating checks -->
   <iso:rule context="/assetPackages/assetPackage/metadata/rating">
   	<extends rule="ratingRules" />
   </iso:rule>
   
   	<!-- category 1 checks -->
   <iso:rule context="/assetPackages/assetPackage/metadata/categorization/category1">
      <iso:let name="c1Values" value="'MSEPGC_MOVIES;MSEPGC_MV;MSEPGC_EDUCATIONAL;MSEPGC_KIDS;MSEPGC_LIFESTYLE;MSEPGC_LS;MSEPGC_NEWS;MSEPGC_SERIES;MSEPGC_SPECIAL;MSEPGC_SPORTS'" />
   	  <iso:report test="not(
   	     (upper-case(@name) = 'MSEPGC_MOVIES') or
   	     (upper-case(@name) = 'MSEPGC_MV') or
   	     (upper-case(@name) = 'MSEPGC_EDUCATIONAL') or
   	     (upper-case(@name) = 'MSEPGC_KIDS') or
   	     (upper-case(@name) = 'MSEPGC_LIFESTYLE') or
   	     (upper-case(@name) = 'MSEPGC_LS') or
   	     (upper-case(@name) = 'MSEPGC_NEWS') or
   	     (upper-case(@name) = 'MSEPGC_SERIES') or
   	     (upper-case(@name) = 'MSEPGC_SPECIAL') or
   	     (upper-case(@name) = 'MSEPGC_SPORTS'))">ERR-04 : name : <iso:value-of select="$c1Values"/></iso:report>
   </iso:rule>

   <!-- categoryTheme checks -->
   <iso:rule context="/assetPackages/assetPackage/categoryTheme">
      <iso:report test="(../../@type = 'SVOD') and ((not(@name)) or (string-length(@name) = 0))">ERR-09 : name : name,metadata/category</iso:report>
      <iso:report test="(../../@type = 'SVOD') and not(contains(../category[1], @name))">ERR-09 : name : name,metadata/category</iso:report>
   </iso:rule>
   
   <!-- Category theme checks -->
   <iso:rule context="/assetPackages/assetPackage/categoryTheme/theme">
   	  <iso:report test="not((@name='display style') or (@name='menu style') or (@name='color') or (@name='background') or (@name='banner') or (@name='mini-banner') or (@name='description') or (@name='adult'))">ERR-04 : name : display style;menu style;color;background;banner;mini-banner;description;adult</iso:report>
   	  <iso:report test="(@name='display style') and (not((@value='list') or (@value='poster')))">ERR-04 : value : list;poster</iso:report>
   	  <iso:report test="(@name='menu style') and (not((@value='none') or (@value='siblings') or (@value='subcategories')))">ERR-04 : value : none;siblings;subcategories</iso:report>
   	  <iso:report test="(@name='color') and (not((@value='black') or (@value='blue') or (@value='green') or (@value='orange') or (@value='purple') or (@value='red') or (@value='yellow')))">ERR-04 : value : black;blue;green;orange;purple;red;yellow</iso:report>
   	  <iso:report test="(@name='adult') and (not((@value='true') or (@value='')))">ERR-04 : value : true;''</iso:report>
   </iso:rule>
   
   <!-- person checks -->
   <iso:rule context="/assetPackages/assetPackage/metadata/person">
     <iso:report test="not(@role)">ERR-02 : role</iso:report>
   	 <iso:report test="not(
   	 						(lower-case(@role)='actor') or 
   	 						(lower-case(@role)='director') or 
   	 						(lower-case(@role)='writer') or 
   	 						(lower-case(@role)='producer') or 
   	 						(lower-case(@role)='executiveproducer') or 
   	 						(lower-case(@role)='host') or 
   	 						(lower-case(@role)='gueststar')
   	 					)">ERR-04 : role : actor;director;writer;producer;executiveproducer;host;guestStar</iso:report>
     <iso:report test="not(@lname)">ERR-02 : lname</iso:report>
   	 <iso:report test="(@lname) and (string-length(@lname) > 50)">ERR-01 : lname : 0,50</iso:report>
   	 <iso:report test="not(@fname)">ERR-02 : fname</iso:report>
   	 <iso:report test="(@fname) and (string-length(@fname) > 50)">ERR-01 : fname : 0,50</iso:report>
   	 <iso:report test="not(@mname)">ERR-02 : mname</iso:report>
   	 <iso:report test="(@mname) and (string-length(@mname) > 50)">ERR-01 : mname : 0,50</iso:report>
   </iso:rule>
   
   <!-- category checks -->
   <iso:rule context="/assetPackages/assetPackage/metadata/category">
     <iso:report test="(string-length(text()) &lt; 1) or ((string-length(text()) > 255))">ERR-01 : category : 1,255</iso:report>
   </iso:rule>
  
   <!-- businessMetadata checks -->
   <iso:rule context="/assetPackages/assetPackage/businessMetadata">
   	 <!-- suggestedPrice checks -->
  	 <iso:report test="count(suggestedPrice) > 1">ERR-05 : suggestedPrice : 1</iso:report>
  	 <iso:report test="(count(suggestedPrice) = 1) and (not(string(suggestedPrice) castable as xs:decimal))">ERR-07 : suggestedPrice : NonNegative decimal</iso:report>
  	 <iso:report test="(count(suggestedPrice) = 1) and (string(suggestedPrice) castable as xs:decimal) and (suggestedPrice &lt; 0)">ERR-07 : suggestedPrice : NonNegative decimal</iso:report>

	 <!-- currency_iso3166-2 checks -->  	 
	 <iso:report test="count(currency_iso3166-2) > 1">ERR-05 : currency_iso3166-2 : 1</iso:report>
     <iso:report test="(count(currency_iso3166-2) = 1) and (not(matches(currency_iso3166-2/text(), '^[A-Za-z]{2}$') ))" >ERR-07 : currency_iso3166-2 : 2 characters (A - Z a - z)</iso:report> -->
	 
	 <!-- createOffer checks -->
	 <iso:report test="count(createOffer) > 1">ERR-05 : createOffer : 1</iso:report>
	 <iso:report test="(count(createOffer) = 1) and (not(string(lower-case(createOffer)) castable as xs:boolean))">ERR-07 : createOffer : boolean</iso:report>
   </iso:rule>
   
   <!-- rightsMetadata checks -->	
   <iso:rule context="/assetPackages/assetPackage/rightsMetadata">
     <!-- licensingWindowStart checks -->
   	 <iso:report test="(count(licensingWindowStart) = 0) or (count(licensingWindowStart) > 1)">ERR-05 : licensingWindowStart : 1</iso:report>

     <!-- licensingWindowEnd checks -->
   	 <iso:report test="(count(licensingWindowEnd) = 0) or (count(licensingWindowEnd) > 1)">ERR-05 : licensingWindowEnd : 1</iso:report>
   	 
   	 <!-- availabilityWindowStart checks -->
   	 <iso:report test="count(availabilityWindowStart) > 1">ERR-05 : availabilityWindowStart : 1</iso:report>
   	 
   	 <!-- availabilityWindowEnd checks --> 
   	 <iso:report test="count(availabilityWindowEnd) > 1">ERR-05 : availabilityWindowEnd : 1</iso:report>
   	 
   	 <!-- newReleaseWindow checks -->
   	 <iso:report test="count(newReleaseWindow) > 1">ERR-05 : newReleaseWindow : 1</iso:report>
   	 <iso:report test="(count(newReleaseWindow) = 1) and not(string(newReleaseWindow/text()) castable as xs:integer) and not(matches(newReleaseWindow/text(), '^[0-9]*$'))">ERR-07 : newReleaseWindow : non-negative integer</iso:report>

   	 <!-- maximumPlayCount checks  --> 
   	 <iso:report test="(count(maximumPlayCount) = 1) and (not(string(maximumPlayCount) castable as xs:integer))">ERR-07 : maximumPlayCount : integer</iso:report>
   	 
   	 <!-- maximumViewingLimit checks -->
   	 <iso:report test="count(maximumViewingLimit) > 1">ERR-05 : maximumViewingLimit : 1</iso:report>
   	 <iso:report test="(count(maximumViewingLimit) = 1) and not(string(maximumViewingLimit) castable as xs:integer) and not((matches(maximumViewingLimit, '^[0-9]*$')) )">ERR-07 : maximumViewingLimit : non-negative integer</iso:report>
   	 
   	 <!-- minimumViewingLimit checks -->
   	 <iso:report test="count(minimumViewingLimit) > 1">ERR-05 : minimumViewingLimit : 1</iso:report>   	 
   	 <iso:report test="(count(minimumViewingLimit) = 1) and not(string(minimumViewingLimit) castable as xs:integer) and not((matches(minimumViewingLimit, '^[0-9]*$')) )">ERR-07 : minimumViewingLimit : non-negative integer</iso:report>
   	 
   	 <!-- previewPeriod checks -->
   	 <iso:report test="(count(previewPeriod) = 1) and (not(string(previewPeriod) castable as xs:integer))">ERR-07 : previewPeriod : integer</iso:report>
   </iso:rule>
 
    <!-- detailed licensingWindowStart checks --> 
   <iso:rule context="/assetPackages/assetPackage/rightsMetadata/licensingWindowStart">
   	 <extends rule="dateValidation" />
	</iso:rule>   	

   <!-- detailed licensingWindowEnd checks -->
   <iso:rule context="/assetPackages/assetPackage/rightsMetadata/licensingWindowEnd">
   	 <extends rule="dateValidation" />
	</iso:rule>
	
   <!-- detailed availabilityWindowStart checks --> 
   <iso:rule context="/assetPackages/assetPackage/rightsMetadata/availabilityWindowStart">
   	 <extends rule="dateValidation" />
	</iso:rule>   	
	   	
   <!-- detailed availabilityWindowEnd checks --> 
   <iso:rule context="/assetPackages/assetPackage/rightsMetadata/availabilityWindowEnd">
   	 <extends rule="dateValidation" />
	</iso:rule>   	
 
    <!-- checks if the date is in yyyy-mm-dd, yyyy-mm-ddThh:mm:ss[.sss][-hh:mm], yyyy-mm-ddThh:mm format -->
    <iso:rule abstract="true" id="dateValidation">
        <iso:report test="(string-length(text()) &lt; 10) or (string-length(text()) > 25)">ERR-08 : <iso:value-of select='name()' /> : a valid MSTV date</iso:report>
        
    	<iso:report test="(string-length(text()) >= 10) and (not(matches(substring(text(), 1, 10), '^[1-9][0-9]{3}-[0-9]{2}-[0-3][0-9]$')))">ERR-08 : <iso:value-of select='name()' /> : a valid MSTV date</iso:report>
        <iso:report test="(string-length(text()) >= 10) and (matches(substring(text(), 1, 10), '^[1-9][0-9]{3}-[0-9]{2}-[0-3][0-9]$')) and ((xs:integer(substring(text(), 6, 2)) >= 13) or ((xs:integer(substring(text(), 9, 2)) > 31)))">ERR-08 : <iso:value-of select='name()' /> : a valid MSTV date</iso:report>
                
    	<iso:report test="(string-length(text()) >= 16) and (not(matches(substring(text(), 11, 6), '^T[0-2][0-9]:[0-6][0-9]$')))">ERR-08 : <iso:value-of select='name()' /> : a valid MSTV date</iso:report>
    	<iso:report test="(string-length(text()) >= 16) and (matches(substring(text(), 11, 6), '^T[0-2][0-9]:[0-6][0-9]$') and ((xs:integer(substring(text(), 12, 2)) >= 24) or(xs:integer(substring(text(), 15, 2)) >= 60)))">ERR-08 : <iso:value-of select='name()' /> : a valid MSTV date</iso:report>
    	    	
    	<iso:report test="(string-length(text()) >= 19) and (not(matches(substring(text(), 17, 3), '^:[0-6][0-9]$')))">ERR-08 : <iso:value-of select='name()' /> : a valid MSTV date</iso:report>
    	<iso:report test="(string-length(text()) >= 19) and (matches(substring(text(), 17, 3), '^:[0-6][0-9]$') and (xsd:integer(substring(text(), 18, 2)) >= 60))">ERR-08 : <iso:value-of select='name()' /> : a valid MSTV date</iso:report>
    	
    	<iso:report test="((string-length(text()) > 19) and (string-length(text()) &lt;= 23)) and (not(matches(substring(text(), 20, 4), '^\.[0-9]{3}')))">ERR-08 : <iso:value-of select='name()' /> : a valid MSTV date</iso:report>
		<!-- this following check is to make sure that the millisecond part is not 4 digit-->
    	<iso:report test="((string-length(text()) > 19) and (string-length(text()) = 24)) and ((matches(substring(text(), 20, 5), '^\.[0-9]{4}')))">ERR-08 : <iso:value-of select='name()' /> : a valid MSTV date</iso:report>
    	
    	<iso:report test="(string-length(text()) > 19) and (string-length(text()) = 25) and (not(matches(substring(text(), 20, 6), '^[\-\+][0-9]{2}:[0-9]{2}')))">ERR-08 : <iso:value-of select='name()' /> : a valid MSTV date</iso:report>
		<!-- the following 2 lines check for -12:00 to +14:00 -->
		<iso:report	test="(string-length(text()) > 19) and (string-length(text()) = 25) and (matches(substring(text(), 20, 6), '^[\-\+][0-9]{2}:[0-9]{2}') and ((substring(text(), 20, 1)) = '-')) and (xsd:integer(substring(text(), 21, 2)) > 12)">ERR-08 : <iso:value-of select='name()' /> : a valid MSTV date</iso:report>
		<iso:report	test="(string-length(text()) > 19) and (string-length(text()) = 25) and (matches(substring(text(), 20, 6), '^[\-\+][0-9]{2}:[0-9]{2}') and ((substring(text(), 20, 1)) = '+')) and (xsd:integer(substring(text(), 21, 2)) > 14)">ERR-08 : <iso:value-of select='name()' /> : a valid MSTV date</iso:report>

	</iso:rule>
   	
	<!-- asset checks -->
	<iso:rule context="/assetPackages/assetPackage/asset">
  	 <!-- asset name checks -->
  	 <iso:report test="not(@asset_name)">ERR-02 : asset_name</iso:report>                                
     <iso:report test="(string-length(@asset_name) = 0) or (string-length(@asset_name) > 255)">ERR-01 : asset_name : 1,255</iso:report>  

     <!-- type check -->
     <iso:report test="not(@type)">ERR-02 : type</iso:report>
     <iso:report test="not((@type='feature') or (@type='trailer') or (@type='poster'))">ERR-04 : type : feature;trailer;poster</iso:report>

	 <!-- profile checks -->
	 <iso:report test="(@profile) and (not((@profile='no-encode') or (@profile='standard') or (@profile='high-quality') or (@profile='no-tricks') or (@profile='default')))">ERR-04 : profile : no-encode;standard;high-quality;no-tricks;default</iso:report>
	  
	 <!-- autoImport checks -->
	 <iso:report test="(@autoImport) and (not(lower-case(@autoImport) castable as xs:boolean))">ERR-07 : autoImport : boolean</iso:report>

	 <!-- autoDeploy checks -->
	 <iso:report test="(@autoDeploy) and (not(lower-case(@autoDeploy) castable as xs:boolean))">ERR-07 : autoDeploy : boolean</iso:report>

	 <!-- autoDelete checks -->
	 <iso:report test="(@autoDelete) and (not(lower-case(@autoDelete) castable as xs:boolean))">ERR-07 : autoDelete : boolean</iso:report>
	 
	 <!-- content checks -->
	 <iso:report test="count(content) = 0">ERR-02 : content</iso:report>
	 <iso:report test="count(content) > 1">ERR-05 : content : 1</iso:report>
	 <iso:report test="not((matches(content/text(), '^([a-zA-Z0-9_.\-\?!$\(\)\+,;=@^`\\\[\]~\s])*$')))">ERR-11 : content : '0-9A-Za-z!$()+-.;=@^_`\[]~'</iso:report>
	</iso:rule>
	
	<!-- asset's metadata checks -->
	<iso:rule context="/assetPackages/assetPackage/asset/metadata">
	 <!-- assetID checks -->
  	 <iso:report test="(assetID) and ((string-length(assetID) = 0) or (string-length(assetID) > 50))">ERR-01 : assetID : 1,50</iso:report>
     <iso:report test="count(assetID) = 0">ERR-02 : assetID</iso:report>
     <iso:report test="count(assetID) > 1">ERR-05 : assetID : 1</iso:report>
     <iso:report test="(assetID) and not((matches(assetID, '^([a-zA-Z0-9.])*$')))">ERR-07 : assetID : [a-zA-Z0-9.]</iso:report>
    
     <!-- provider Id checks -->
     <iso:report test="count(providerID) > 1">ERR-05 : providerID : 1</iso:report>
     <iso:report test="(count(providerID) = 1) and ((string-length(providerID) = 0) or (string-length(providerID) > 50))">ERR-01 : providerID : 1,50</iso:report>  
	 <iso:report test="(count(providerID) = 1) and not((matches(providerID, '^([a-zA-Z0-9.])*$')))">ERR-07 : providerID : [a-zA-Z0-9.]</iso:report>  
	
	 <!-- HD checks -->
	 <iso:report test="count(HD) > 1">ERR-05 : HD : 1</iso:report>
	 <iso:report test="(count(HD) = 1) and (HD) and (not(lower-case(HD) castable as xs:boolean))">ERR-07 : HD : boolean</iso:report>
	 
	 <!-- language_iso639  checks -->
	 <iso:report test="count(language_iso639) > 5">ERR-05 : language_iso639 : 5</iso:report>
	 
	 <!-- audio checks -->
	 <iso:report test="count(audio) > 5">ERR-05 : audio : 5</iso:report>
	 
	 <!-- subtitleLanguage_iso639 checks -->
	 <iso:report test="count(subtitleLanguage_iso639) > 5">ERR-05 : subtitleLanguage_iso639 : 5</iso:report>

	 <!-- dubbedLanguage_iso639 checks -->
	 <iso:report test="count(dubbedLanguage_iso639) > 5">ERR-05 : dubbedLanguage_iso639 : 5</iso:report>
	</iso:rule>


	 <iso:rule context="/assetPackages/assetPackage/asset/metadata/audio">
		 <iso:report test="(not(
		 						(text()='Dolby ProLogic') or 
		 						(text()='Dolby Digital') or 
		 						(text()='Stereo') or 
		 						(text()='Mono') or 
		 						(text()='Dolby Digital 5.1') or 
		 						(text()='Dolby Surround')
		 					))">ERR-04 : audio : Dolby ProLogic;Dolby Digital;Stereo;Mono;Dolby Digital 5.1;Dolby Surround</iso:report>	 	
	 </iso:rule>
	
	<!-- rating checks for asset's metadata -->
	<iso:rule context="/assetPackages/assetPackage/asset/metadata/rating">
	  <extends rule="ratingRules" />
	</iso:rule>
	
	<!-- language_iso639 checks -->
	<iso:rule context="/assetPackages/assetPackage/asset/metadata/language_iso639">
	 <extends rule="IsoLanguageCheck" />
	</iso:rule>

	<!-- subtitleLanguage_iso639 checks -->
	<iso:rule context="/assetPackages/assetPackage/asset/metadata/subtitleLanguage_iso639">
	 <extends rule="IsoLanguageCheck" />
	</iso:rule>

	<!-- dubbedLanguage_iso639 checks -->
	<iso:rule context="/assetPackages/assetPackage/asset/metadata/dubbedLanguage_iso639">
	 <extends rule="IsoLanguageCheck" />
	</iso:rule>
	
	<!-- check if the language is specified in the right format e.g. en, en-us
	This does not check if its a valid known language code.-->
	<iso:rule abstract="true" id="IsoLanguageCheck">
	 <iso:report test="not((matches(text(), '^[a-zA-Z]{2}-[a-zA-Z]{2}$')) or (matches(text(), '^([a-zA-Z]{2})$')))">ERR-07 :  <iso:value-of select='name()' /> : ISO Language</iso:report>	 
	</iso:rule>
	
	 <!-- category 2 checks... SO UGLY!!! -->
   <iso:rule context="/assetPackages/assetPackage/metadata/categorization/category1/category2">
      <iso:let name="c2Values" value="'MSEPGC_MV_All;MSEPGC_MV_ActAdv;MSEPGC_MV_AdultsOnly;MSEPGC_MV_Children;MSEPGC_MV_Comedy;MSEPGC_MV_Drama;MSEPGC_MV_Fantasy;MSEPGC_MV_Horror;MSEPGC_MV_Musical;MSEPGC_MV_Mystery;MSEPGC_MV_Romance;MSEPGC_MV_SciFi;MSEPGC_MV_Suspense;MSEPGC_MV_Western;MSEPGC_MV_Other;MSEPGC_Ed_All;MSEPGC_Ed_Arts;MSEPGC_Ed_Biography;MSEPGCEd_Documentary;MSEPGC_Ed_How-to;MSEPGC_Ed_Science;MSEPGC_Ed_Other;MSEPGC_Kids_All;MSEPGC_Kids_Adventure;MSEPGC_Kids_Animated;MSEPGC_Kids_Comedy;MSEPGC_Kids_Educational;MSEPGC_Kids_Special;MSEPGC_Kids_Other;MSEPGC_LS_All;MSEPGC_LS_AdultsOnly;MSEPGC_LS_Collectibles;MSEPGC_LS_Cooking;MSEPGC_LS_Exercise;MSEPGC_LS_Health;MSEPGC_LS_HomeandGarden;MSEPGC_LS_Outdoors;MSEPGC_LS_Religious;MSEPGC_LS_Other;MSEPGC_News_All;MSEPGC_News_Business;MSEPGC_News_CurrentEvts;MSEPGC_News_Interview;MSEPGC_News_PublicAfrs;MSEPGC_News_Sports;MSEPGC_News_Weather;MSEPGC_News_Other;MSEPGC_Series_All;MSEPGC_Series_ActAdv;MSEPGC_Series_Child;MSEPGC_Series_Comedy;MSEPGC_Series_Cooking;MSEPGC_Series_Drama;MSEPGC_Series_Ed;MSEPGC_Series_Game;MSEPGC_Series_HowTo;MSEPGC_Series_Music;MSEPGC_Series_Reality;MSEPGC_Series_Soap;MSEPGC_Series_Talk;MSEPGC_Series_Travel;MSEPGC_Series_Other;MSEPGC_Special_All;MSEPGC_Special_Award;MSEPGC_Special_Holiday;MSEPGC_Special_Music;MSEPGC_Special_Religious;MSEPGC_Special_Sports;MSEPGC_Special_Other;MSEPGC_Sports_All;MSEPGC_Sports_Baseball;MSEPGC_Sports_Basketball;MSEPGC_Sports_Boxing;MSEPGC_Sports_Football;MSEPGC_Sports_Golf;MSEPGC_Sports_Hockey;MSEPGC_Sports_Outdoor;MSEPGC_Sports_Racing;MSEPGC_Sports_Soccer;MSEPGC_Sports_Tennis;MSEPGC_Sports_Other;'" />
   	  <iso:report test="not(
   	     (upper-case(@name) = 'MSEPGC_MV_ALL') or
   	     (upper-case(@name) = 'MSEPGC_MV_ACTADV') or
   	     (upper-case(@name) = 'MSEPGC_MV_ADULTSONLY') or
   	     (upper-case(@name) = 'MSEPGC_MV_CHILDREN') or
   	     (upper-case(@name) = 'MSEPGC_MV_COMEDY') or
   	     (upper-case(@name) = 'MSEPGC_MV_DRAMA') or
   	     (upper-case(@name) = 'MSEPGC_MV_FANTASY') or
   	     (upper-case(@name) = 'MSEPGC_MV_HORROR') or
   	     (upper-case(@name) = 'MSEPGC_MV_MUSICAL') or
   	     (upper-case(@name) = 'MSEPGC_MV_MYSTERY') or
   	     (upper-case(@name) = 'MSEPGC_MV_ROMANCE') or
   	     (upper-case(@name) = 'MSEPGC_MV_SCIFI') or
   	     (upper-case(@name) = 'MSEPGC_MV_SUSPENSE') or
   	     (upper-case(@name) = 'MSEPGC_MV_WESTERN') or
   	     (upper-case(@name) = 'MSEPGC_MV_OTHER') or
   	     (upper-case(@name) = 'MSEPGC_ED_ALL') or
   	     (upper-case(@name) = 'MSEPGC_ED_ARTS') or
   	     (upper-case(@name) = 'MSEPGC_ED_BIOGRAPHY') or
   	     (upper-case(@name) = 'MSEPGC_ED_DOCUMENTARY') or
   	     (upper-case(@name) = 'MSEPGC_ED_HOW-TO') or
   	     (upper-case(@name) = 'MSEPGC_ED_SCIENCE') or
   	     (upper-case(@name) = 'MSEPGC_ED_OTHER') or
   	     (upper-case(@name) = 'MSEPGC_KIDS_ALL') or
   	     (upper-case(@name) = 'MSEPGC_KIDS_ADVENTURE') or
   	     (upper-case(@name) = 'MSEPGC_KIDS_ANIMATED') or
   	     (upper-case(@name) = 'MSEPGC_KIDS_COMEDY') or
   	     (upper-case(@name) = 'MSEPGC_KIDS_EDUCATIONAL') or
   	     (upper-case(@name) = 'MSEPGC_KIDS_SPECIAL') or
   	     (upper-case(@name) = 'MSEPGC_KIDS_OTHER') or
   	     (upper-case(@name) = 'MSEPGC_LS_ALL') or
   	     (upper-case(@name) = 'MSEPGC_LS_ADULTSONLY') or
   	     (upper-case(@name) = 'MSEPGC_LS_COLLECTIBLES') or
   	     (upper-case(@name) = 'MSEPGC_LS_COOKING') or
   	     (upper-case(@name) = 'MSEPGC_LS_EXERCISE') or
   	     (upper-case(@name) = 'MSEPGC_LS_HEALTH') or
   	     (upper-case(@name) = 'MSEPGC_LS_HOMEANDGARDEN') or
   	     (upper-case(@name) = 'MSEPGC_LS_OUTDOORS') or
   	     (upper-case(@name) = 'MSEPGC_LS_RELIGIOUS') or
   	     (upper-case(@name) = 'MSEPGC_LS_OTHER') or
   	     (upper-case(@name) = 'MSEPGC_NEWS_ALL') or
   	     (upper-case(@name) = 'MSEPGC_NEWS_BUSINESS') or
   	     (upper-case(@name) = 'MSEPGC_NEWS_CURRENTEVTS') or
   	     (upper-case(@name) = 'MSEPGC_NEWS_INTERVIEW') or
   	     (upper-case(@name) = 'MSEPGC_NEWS_PUBLICAFRS') or
   	     (upper-case(@name) = 'MSEPGC_NEWS_SPORTS') or
   	     (upper-case(@name) = 'MSEPGC_NEWS_WEATHER') or
   	     (upper-case(@name) = 'MSEPGC_NEWS_OTHER') or
   	     (upper-case(@name) = 'MSEPGC_SERIES_ALL') or
   	     (upper-case(@name) = 'MSEPGC_SERIES_ACTADV') or
   	     (upper-case(@name) = 'MSEPGC_SERIES_CHILD') or
   	     (upper-case(@name) = 'MSEPGC_SERIES_COMEDY') or
   	     (upper-case(@name) = 'MSEPGC_SERIES_COOKING') or
   	     (upper-case(@name) = 'MSEPGC_SERIES_DRAMA') or
   	     (upper-case(@name) = 'MSEPGC_SERIES_ED') or
   	     (upper-case(@name) = 'MSEPGC_SERIES_GAME') or
   	     (upper-case(@name) = 'MSEPGC_SERIES_HOWTO') or
   	     (upper-case(@name) = 'MSEPGC_SERIES_MUSIC') or
   	     (upper-case(@name) = 'MSEPGC_SERIES_REALITY') or
   	     (upper-case(@name) = 'MSEPGC_SERIES_SOAP') or
   	     (upper-case(@name) = 'MSEPGC_SERIES_TALK') or
   	     (upper-case(@name) = 'MSEPGC_SERIES_TRAVEL') or
   	     (upper-case(@name) = 'MSEPGC_SERIES_OTHER') or
   	     (upper-case(@name) = 'MSEPGC_SPECIAL_ALL') or
   	     (upper-case(@name) = 'MSEPGC_SPECIAL_AWARD') or
   	     (upper-case(@name) = 'MSEPGC_SPECIAL_HOLIDAY') or
   	     (upper-case(@name) = 'MSEPGC_SPECIAL_MUSIC') or
   	     (upper-case(@name) = 'MSEPGC_SPECIAL_RELIGIOUS') or
   	     (upper-case(@name) = 'MSEPGC_SPECIAL_SPORTS') or
   	     (upper-case(@name) = 'MSEPGC_SPECIAL_OTHER') or
   	     (upper-case(@name) = 'MSEPGC_SPORTS_ALL') or
   	     (upper-case(@name) = 'MSEPGC_SPORTS_BASEBALL') or
   	     (upper-case(@name) = 'MSEPGC_SPORTS_BASKETBALL') or
   	     (upper-case(@name) = 'MSEPGC_SPORTS_BOXING') or
   	     (upper-case(@name) = 'MSEPGC_SPORTS_FOOTBALL') or
   	     (upper-case(@name) = 'MSEPGC_SPORTS_GOLF') or
   	     (upper-case(@name) = 'MSEPGC_SPORTS_HOCKEY') or
   	     (upper-case(@name) = 'MSEPGC_SPORTS_OUTDOOR') or
   	     (upper-case(@name) = 'MSEPGC_SPORTS_RACING') or
   	     (upper-case(@name) = 'MSEPGC_SPORTS_SOCCER') or
   	     (upper-case(@name) = 'MSEPGC_SPORTS_TENNIS') or
   	     (upper-case(@name) = 'MSEPGC_SPORTS_OTHER') or
   	     (upper-case(@name) = 'MSEPGC_MV_ACTION') or
   	     (upper-case(@name) = 'MSEPGC_MV_ADVENTURE') or
   	     (upper-case(@name) = 'MSEPGC_MV_ANIMATION') or
   	     (upper-case(@name) = 'MSEPGC_MV_CRIME') or
   	     (upper-case(@name) = 'MSEPGC_MV_DOCUMENTARY') or
   	     (upper-case(@name) = 'MSEPGC_MV_FAMILY') or
   	     (upper-case(@name) = 'MSEPGC_MV_FILM-NOIR') or
   	     (upper-case(@name) = 'MSEPGC_MV_SHORT') or
   	     (upper-case(@name) = 'MSEPGC_MV_THRILLER') or
   	     (upper-case(@name) = 'MSEPGC_MV_WAR') or
   	     (upper-case(@name) = 'MSEPGC_MV_SCI-FI')
   	     )">ERR-04 : name : <iso:value-of select="$c2Values"/></iso:report>
   </iso:rule>
   
    <!-- verifies if its a valid 2 letter language code -->
   	<iso:rule abstract="true" id="languageCheck">
	 <iso:report test="not(
		(lower-case(.) = 'aa') or
		(lower-case(.) = 'ab') or
		(lower-case(.) = 'ae') or
		(lower-case(.) = 'af') or
		(lower-case(.) = 'am') or
		(lower-case(.) = 'an') or
		(lower-case(.) = 'ar') or
		(lower-case(.) = 'as') or
		(lower-case(.) = 'ay') or
		(lower-case(.) = 'az') or
		(lower-case(.) = 'ba') or
		(lower-case(.) = 'be') or
		(lower-case(.) = 'bg') or
		(lower-case(.) = 'bh') or
		(lower-case(.) = 'bi') or
		(lower-case(.) = 'bn') or
		(lower-case(.) = 'bo') or
		(lower-case(.) = 'br') or
		(lower-case(.) = 'bs') or
		(lower-case(.) = 'ca') or
		(lower-case(.) = 'ce') or
		(lower-case(.) = 'ch') or
		(lower-case(.) = 'co') or
		(lower-case(.) = 'cs') or
		(lower-case(.) = 'cu') or
		(lower-case(.) = 'cv') or
		(lower-case(.) = 'cy') or
		(lower-case(.) = 'da') or
		(lower-case(.) = 'de') or
		(lower-case(.) = 'dv') or
		(lower-case(.) = 'dz') or
		(lower-case(.) = 'el') or
		(lower-case(.) = 'en') or
		(lower-case(.) = 'eo') or
		(lower-case(.) = 'es') or
		(lower-case(.) = 'et') or
		(lower-case(.) = 'eu') or
		(lower-case(.) = 'fa') or
		(lower-case(.) = 'fi') or
		(lower-case(.) = 'fj') or
		(lower-case(.) = 'fo') or
		(lower-case(.) = 'fr') or
		(lower-case(.) = 'fy') or
		(lower-case(.) = 'ga') or
		(lower-case(.) = 'gd') or
		(lower-case(.) = 'gl') or
		(lower-case(.) = 'gn') or
		(lower-case(.) = 'gu') or
		(lower-case(.) = 'gv') or
		(lower-case(.) = 'ha') or
		(lower-case(.) = 'he') or
		(lower-case(.) = 'hi') or
		(lower-case(.) = 'ho') or
		(lower-case(.) = 'hr') or
		(lower-case(.) = 'ht') or
		(lower-case(.) = 'hu') or
		(lower-case(.) = 'hy') or
		(lower-case(.) = 'hz') or
		(lower-case(.) = 'ia') or
		(lower-case(.) = 'id') or
		(lower-case(.) = 'ie') or
		(lower-case(.) = 'ii') or
		(lower-case(.) = 'ik') or
		(lower-case(.) = 'io') or
		(lower-case(.) = 'is') or
		(lower-case(.) = 'it') or
		(lower-case(.) = 'iu') or
		(lower-case(.) = 'ja') or
		(lower-case(.) = 'jv') or
		(lower-case(.) = 'ka') or
		(lower-case(.) = 'ki') or
		(lower-case(.) = 'kj') or
		(lower-case(.) = 'kk') or
		(lower-case(.) = 'kl') or
		(lower-case(.) = 'km') or
		(lower-case(.) = 'kn') or
		(lower-case(.) = 'ko') or
		(lower-case(.) = 'ks') or
		(lower-case(.) = 'ku') or
		(lower-case(.) = 'kv') or
		(lower-case(.) = 'kw') or
		(lower-case(.) = 'ky') or
		(lower-case(.) = 'la') or
		(lower-case(.) = 'lb') or
		(lower-case(.) = 'li') or
		(lower-case(.) = 'ln') or
		(lower-case(.) = 'lo') or
		(lower-case(.) = 'lt') or
		(lower-case(.) = 'lv') or
		(lower-case(.) = 'mg') or
		(lower-case(.) = 'mh') or
		(lower-case(.) = 'mi') or
		(lower-case(.) = 'mk') or
		(lower-case(.) = 'ml') or
		(lower-case(.) = 'mn') or
		(lower-case(.) = 'mo') or
		(lower-case(.) = 'mr') or
		(lower-case(.) = 'ms') or
		(lower-case(.) = 'mt') or
		(lower-case(.) = 'my') or
		(lower-case(.) = 'na') or
		(lower-case(.) = 'nb') or
		(lower-case(.) = 'nd') or
		(lower-case(.) = 'ne') or
		(lower-case(.) = 'ng') or
		(lower-case(.) = 'nl') or
		(lower-case(.) = 'nn') or
		(lower-case(.) = 'no') or
		(lower-case(.) = 'nr') or
		(lower-case(.) = 'nv') or
		(lower-case(.) = 'ny') or
		(lower-case(.) = 'oc') or
		(lower-case(.) = 'om') or
		(lower-case(.) = 'or') or
		(lower-case(.) = 'os') or
		(lower-case(.) = 'pa') or
		(lower-case(.) = 'pi') or
		(lower-case(.) = 'pl') or
		(lower-case(.) = 'ps') or
		(lower-case(.) = 'pt') or
		(lower-case(.) = 'qu') or
		(lower-case(.) = 'rm') or
		(lower-case(.) = 'rn') or
		(lower-case(.) = 'ro') or
		(lower-case(.) = 'ru') or
		(lower-case(.) = 'rw') or
		(lower-case(.) = 'sa') or
		(lower-case(.) = 'sc') or
		(lower-case(.) = 'sd') or
		(lower-case(.) = 'se') or
		(lower-case(.) = 'sg') or
		(lower-case(.) = 'si') or
		(lower-case(.) = 'sk') or
		(lower-case(.) = 'sl') or
		(lower-case(.) = 'sm') or
		(lower-case(.) = 'sn') or
		(lower-case(.) = 'so') or
		(lower-case(.) = 'sq') or
		(lower-case(.) = 'sr') or
		(lower-case(.) = 'ss') or
		(lower-case(.) = 'st') or
		(lower-case(.) = 'su') or
		(lower-case(.) = 'sv') or
		(lower-case(.) = 'sw') or
		(lower-case(.) = 'ta') or
		(lower-case(.) = 'te') or
		(lower-case(.) = 'tg') or
		(lower-case(.) = 'th') or
		(lower-case(.) = 'ti') or
		(lower-case(.) = 'tk') or
		(lower-case(.) = 'tl') or
		(lower-case(.) = 'tn') or
		(lower-case(.) = 'to') or
		(lower-case(.) = 'tr') or
		(lower-case(.) = 'ts') or
		(lower-case(.) = 'tt') or
		(lower-case(.) = 'tw') or
		(lower-case(.) = 'ty') or
		(lower-case(.) = 'ug') or
		(lower-case(.) = 'uk') or
		(lower-case(.) = 'ur') or
		(lower-case(.) = 'uz') or
		(lower-case(.) = 'vi') or
		(lower-case(.) = 'vo') or
		(lower-case(.) = 'wa') or
		(lower-case(.) = 'wo') or
		(lower-case(.) = 'xh') or
		(lower-case(.) = 'yi') or
		(lower-case(.) = 'yo') or
		(lower-case(.) = 'za') or
		(lower-case(.) = 'zh') or
		(lower-case(.) = 'zu')
	 )">ERR-07 :  <iso:value-of select='name()' /> : valid 2 letter language code</iso:report>	 
	</iso:rule>
   
  </iso:pattern>
</iso:schema>
