/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.job;

import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.Job;
import com.tandbergtv.watchpoint.pmm.entities.RuleType;
import com.tandbergtv.watchpoint.pmm.job.IJobManager;
import com.tandbergtv.watchpoint.pmm.job.dao.JobHDAO;
import com.tandbergtv.watchpoint.pmm.job.dao.JobRuleTypeHDAO;
import com.tandbergtv.watchpoint.pmm.job.scheduling.IJobScheduleManager;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class JobManager
implements IJobManager {
    private static IJobManager instance;
    private static final Logger logger;

    private JobManager() {
    }

    public static synchronized IJobManager getInstance() {
        if (instance == null) {
            instance = new JobManager();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createJob(Job job) {
        Session session = null;
        try {
            session = HibernateContext.getContext().getCurrentSession();
            session.beginTransaction();
            JobHDAO jobDAO = new JobHDAO(session);
            jobDAO.create(job);
            IJobScheduleManager scheduleManager = (IJobScheduleManager)ServiceRegistry.getDefault().lookup(IJobScheduleManager.class);
            scheduleManager.addSchedule(job);
            session.getTransaction().commit();
        }
        catch (Exception e) {
            try {
                session.getTransaction().rollback();
            }
            catch (HibernateException e1) {
                logger.error((Object)("Error while rolling back in createJob: " + e1.toString()), (Throwable)e1);
            }
            logger.error((Object)("Error while creating job: " + e.getMessage()), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean deleteJob(long jobId) {
        Session session = null;
        try {
            session = HibernateContext.getContext().getCurrentSession();
            session.beginTransaction();
            JobHDAO jobDAO = new JobHDAO(session);
            Job j = (Job)jobDAO.findByKey(jobId);
            jobDAO.delete(jobId);
            IJobScheduleManager scheduleManager = (IJobScheduleManager)ServiceRegistry.getDefault().lookup(IJobScheduleManager.class);
            scheduleManager.deleteSchedules(j);
            session.getTransaction().commit();
        }
        catch (Exception e) {
            try {
                session.getTransaction().rollback();
            }
            catch (HibernateException e1) {
                logger.error((Object)("Error while rolling back in deleteJob: " + e1.toString()), (Throwable)e1);
            }
            logger.error((Object)("Error while deleting job(id: " + jobId + "): " + e.getMessage()), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized List<Job> getAllJobs(long contextId) {
        Session session = null;
        List<Job> jobs = new ArrayList<Job>();
        try {
            session = HibernateContext.getContext().getCurrentSession();
            session.beginTransaction();
            JobHDAO jobDAO = new JobHDAO(session);
            Criteria criteria = session.createCriteria(Job.class).add((Criterion)Restrictions.eq((String)"context.id", (Object)contextId));
            jobs = jobDAO.findByCriteria(criteria);
            session.getTransaction().commit();
        }
        catch (Exception e) {
            logger.error((Object)("Error while getting all jobs: " + e.getMessage()), (Throwable)e);
        }
        finally {
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
        return jobs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RuleType getRuleType(String name) {
        Session session = null;
        RuleType ruleType = new RuleType();
        try {
            session = HibernateContext.getContext().getCurrentSession();
            session.beginTransaction();
            JobRuleTypeHDAO ruleTypeDAO = new JobRuleTypeHDAO(session);
            Criteria criteria = session.createCriteria(RuleType.class).add((Criterion)Restrictions.eq((String)"name", (Object)name));
            ruleType = ruleTypeDAO.findUniqueByCriteria(criteria);
            session.getTransaction().commit();
            RuleType ruleType2 = ruleType;
            return ruleType2;
        }
        catch (Exception e) {
            logger.error((Object)("Error while getting rule type(" + name + "): " + e.getMessage()), (Throwable)e);
        }
        finally {
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
        return ruleType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RuleType> getAllRuleTypes() {
        Session session = null;
        ArrayList<RuleType> ruleTypes = new ArrayList();
        try {
            session = HibernateContext.getContext().getCurrentSession();
            session.beginTransaction();
            JobRuleTypeHDAO ruleTypeDAO = new JobRuleTypeHDAO(session);
            ruleTypes = ruleTypeDAO.findAll();
            session.getTransaction().commit();
        }
        catch (Exception e) {
            logger.error((Object)("Error while getting all rule types: " + e.getMessage()), (Throwable)e);
        }
        finally {
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
        return ruleTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RuleType> getRuleTypes(boolean isAssociatedWithTitles) {
        Session session = null;
        List<RuleType> ruleTypes = new ArrayList<RuleType>();
        try {
            session = HibernateContext.getContext().getCurrentSession();
            session.beginTransaction();
            JobRuleTypeHDAO ruleTypeDAO = new JobRuleTypeHDAO(session);
            Criteria criteria = session.createCriteria(RuleType.class).add((Criterion)Restrictions.eq((String)"titlesAssociated", (Object)isAssociatedWithTitles));
            ruleTypes = ruleTypeDAO.findByCriteria(criteria);
            session.getTransaction().commit();
        }
        catch (Exception e) {
            logger.error((Object)("Error while getting rule type(" + isAssociatedWithTitles + "): " + e.getMessage()), (Throwable)e);
        }
        finally {
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
        return ruleTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Job getJob(long jobId) {
        Job j = new Job();
        Session session = null;
        try {
            session = HibernateContext.getContext().getCurrentSession();
            session.beginTransaction();
            JobHDAO jobDAO = new JobHDAO(session);
            j = (Job)jobDAO.findByKey(jobId);
            j.getName();
            session.getTransaction().commit();
        }
        catch (Exception e) {
            logger.error((Object)("Error while getting job(id: " + jobId + "): " + e.getMessage()), (Throwable)e);
        }
        finally {
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
        return j;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean updateJob(Job job) {
        Session session = null;
        try {
            session = HibernateContext.getContext().getCurrentSession();
            session.beginTransaction();
            JobHDAO jobDAO = new JobHDAO(session);
            jobDAO.update(job);
            IJobScheduleManager scheduleManager = (IJobScheduleManager)ServiceRegistry.getDefault().lookup(IJobScheduleManager.class);
            scheduleManager.updateSchedule(job);
            session.getTransaction().commit();
        }
        catch (Exception e) {
            try {
                session.getTransaction().rollback();
            }
            catch (HibernateException exp) {
                logger.error((Object)("Error while rolling back in updateJob: " + exp.toString()), (Throwable)exp);
            }
            logger.error((Object)("Error while updating job(id: " + job.getId() + "): " + e.getMessage()), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
        return true;
    }

    static {
        logger = Logger.getLogger(JobManager.class);
    }
}

