/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.job.callback;

import com.tandbergtv.watchpoint.pmm.entities.IContainer;
import com.tandbergtv.watchpoint.pmm.job.callback.CallbackHelper;
import com.tandbergtv.watchpoint.pmm.job.callback.IJobCallback;
import com.tandbergtv.watchpoint.pmm.job.handler.DefaultHandler;
import com.tandbergtv.watchpoint.pmm.job.util.JobScheduleInfoConstants;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class DefaultCallback
implements IJobCallback,
Job {
    private static final Logger logger = Logger.getLogger(DefaultCallback.class);

    public void execute(JobExecutionContext context) throws JobExecutionException {
        DefaultHandler handler = new DefaultHandler();
        JobDataMap callbackInfo = context.getJobDetail().getJobDataMap();
        try {
            handler.executeJob((Map<String, Object>)callbackInfo, new Date());
        }
        catch (RuntimeException e) {
            IContainer container = CallbackHelper.getContainer((Map<String, Object>)callbackInfo);
            String errorMsg = "Job execution failed for: " + callbackInfo.get(JobScheduleInfoConstants.JOB_NAME) + " [" + (Object)((Object)container.getContainerType()) + ":" + container.getContainerName() + "]";
            logger.error((Object)errorMsg, (Throwable)e);
            throw new JobExecutionException(errorMsg, (Throwable)e);
        }
    }

    @Override
    public void executeJob(Map<String, Object> callbackInfo, Date jobExecutionDate) {
        logger.debug((Object)("Executing job that was missed at: " + jobExecutionDate.toString()));
        DefaultHandler handler = new DefaultHandler();
        try {
            handler.executeJob(callbackInfo, jobExecutionDate);
        }
        catch (RuntimeException e) {
            IContainer container = CallbackHelper.getContainer(callbackInfo);
            String errorMsg = "Job execution failed for missed job: " + callbackInfo.get(JobScheduleInfoConstants.JOB_NAME) + " [" + (Object)((Object)container.getContainerType()) + ":" + container.getContainerName() + "]";
            logger.error((Object)errorMsg, (Throwable)e);
            throw new RuntimeException(errorMsg, e);
        }
    }
}

