/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.job.timers;

import com.tandbergtv.watchpoint.pmm.entities.RuleParameter;
import com.tandbergtv.watchpoint.pmm.entities.RuleParameterDataType;
import com.tandbergtv.watchpoint.pmm.entities.RuleTypeParameter;
import com.tandbergtv.watchpoint.pmm.job.timers.ITimeRepresentation;
import com.tandbergtv.watchpoint.pmm.job.timers.TimerHelper;
import com.tandbergtv.watchpoint.pmm.job.timers.TimerResult;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class EveryNDays
implements ITimeRepresentation {
    private static long MSEC_IN_ONE_DAY = 86400000L;
    private static final Logger logger = Logger.getLogger(EveryNDays.class);

    @Override
    public Object getTime(List<RuleTypeParameter> ruleTypeParams, List<RuleParameter> params, Date startDate) {
        String numberOfDays = TimerHelper.getParameter(ruleTypeParams, params, RuleParameterDataType.INTEGER);
        String jobTime = TimerHelper.getParameter(ruleTypeParams, params, RuleParameterDataType.TIME);
        if (numberOfDays == null) {
            logger.error((Object)"Number of days not specified");
            return null;
        }
        if (Integer.parseInt(numberOfDays) == 0) {
            logger.error((Object)"Number of days cannot be 0");
            return null;
        }
        Date jobStartDate = TimerHelper.getStartDateTime(startDate, jobTime);
        long periodicity = Long.parseLong(numberOfDays) * MSEC_IN_ONE_DAY;
        TimerResult result = new TimerResult(true, periodicity, jobStartDate);
        return result;
    }
}

