/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.schedule.search;

import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.watchpoint.pmm.dao.hibernate.HibernateContext;
import com.tandbergtv.watchpoint.pmm.entities.DistributionSchedule;
import com.tandbergtv.watchpoint.pmm.entities.Planner;
import com.tandbergtv.watchpoint.pmm.entities.Schedule;
import com.tandbergtv.watchpoint.pmm.entities.ScheduleStatus;
import com.tandbergtv.watchpoint.pmm.schedule.ScheduleRuntimeException;
import com.tandbergtv.watchpoint.pmm.schedule.search.IScheduleSearchService;
import com.tandbergtv.watchpoint.pmm.schedule.search.ScheduleSearchKey;
import com.tandbergtv.watchpoint.search.Entity;
import com.tandbergtv.watchpoint.search.QueryBuilder;
import com.tandbergtv.workflow.driver.search.ListParameter;
import com.tandbergtv.workflow.driver.search.RangeParameter;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.search.SortParameter;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import com.tandbergtv.workflow.util.SearchCriteria;
import com.tandbergtv.workflow.util.SortingOrder;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.internal.Conversions;
import org.hibernate.Query;
import org.hibernate.Session;

public class ScheduleSearchService
implements IScheduleSearchService {
    private static final Logger logger = Logger.getLogger(ScheduleSearchService.class);

    @Override
    public Collection<Planner> getPlannersByDateRange(Long partnerId, Date start, Date end) {
        if (start == null && end == null) {
            throw new ScheduleRuntimeException("At least one bound of the interval must be specified");
        }
        SearchCriteria criteria = new SearchCriteria();
        Entity e = new Entity("planner", Planner.class, "p");
        e.addParameter((SearchParameterBase)new ValueParameter(ScheduleSearchKey.ACTIVE.toString(), SearchType.NUMERIC, (Object)1));
        e.addParameter((SearchParameterBase)new ValueParameter(ScheduleSearchKey.PARTNER_ID.toString(), SearchType.NUMERIC, (Object)partnerId));
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        RangeParameter range = new RangeParameter(ScheduleSearchKey.PITCH_DATE.toString(), SearchType.DATE);
        if (start != null) {
            range.setTo(formatter.format(start));
        }
        if (end != null) {
            range.setTo(formatter.format(end));
        }
        e.addParameter((SearchParameterBase)range);
        criteria.addParameter((SearchParameterBase)e);
        return this.search(criteria);
    }

    @Override
    public Collection<Planner> getPlannersByDate(Long partnerId, Date date) {
        if (date == null) {
            throw new ScheduleRuntimeException("Planner arrival date must be specified");
        }
        SearchCriteria criteria = new SearchCriteria();
        Entity e = new Entity("planner", Planner.class, "p");
        e.addParameter((SearchParameterBase)new ValueParameter(ScheduleSearchKey.ACTIVE.toString(), SearchType.NUMERIC, (Object)1));
        e.addParameter((SearchParameterBase)new ValueParameter(ScheduleSearchKey.PARTNER_ID.toString(), SearchType.NUMERIC, (Object)partnerId));
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        e.addParameter((SearchParameterBase)new ValueParameter(ScheduleSearchKey.PITCH_DATE.toString(), SearchType.DATE, (Object)formatter.format(date)));
        criteria.addParameter((SearchParameterBase)e);
        return this.search(criteria);
    }

    @Override
    public Collection<DistributionSchedule> getPitchSchedulesByDateRange(Long contextId, Date start, Date end) {
        if (start == null && end == null) {
            throw new ScheduleRuntimeException("At least one bound of the interval must be specified");
        }
        SearchCriteria criteria = new SearchCriteria();
        Entity e = new Entity("schedule", DistributionSchedule.class, "d");
        e.addParameter((SearchParameterBase)new ValueParameter(ScheduleSearchKey.ACTIVE.toString(), SearchType.NUMERIC, (Object)1));
        e.addParameter((SearchParameterBase)new ValueParameter(ScheduleSearchKey.CONTEXT.toString(), SearchType.NUMERIC, (Object)contextId));
        this.addDateCriterion(e, start, end);
        criteria.addParameter((SearchParameterBase)e);
        return this.search(criteria);
    }

    @Override
    public Collection<DistributionSchedule> getPitchSchedulesByPitchDate(Long contextId, Date date) {
        if (date == null) {
            throw new ScheduleRuntimeException("Pitch date must be specified");
        }
        SearchCriteria criteria = new SearchCriteria();
        Entity e = new Entity("schedule", DistributionSchedule.class, "d");
        e.addParameter((SearchParameterBase)new ValueParameter(ScheduleSearchKey.ACTIVE.toString(), SearchType.NUMERIC, (Object)1));
        e.addParameter((SearchParameterBase)new ValueParameter(ScheduleSearchKey.CONTEXT.toString(), SearchType.NUMERIC, (Object)contextId));
        this.addDateCriterion(e, date, null);
        criteria.addParameter((SearchParameterBase)e);
        return this.search(criteria);
    }

    @Override
    public Collection<DistributionSchedule> getPitchSchedulesByPitchDate(Long contextId, Date date, ScheduleStatus ... status) {
        SearchCriteria criteria = new SearchCriteria();
        Entity e = new Entity("schedule", DistributionSchedule.class, "d");
        e.addParameter((SearchParameterBase)new ValueParameter(ScheduleSearchKey.ACTIVE.toString(), SearchType.NUMERIC, (Object)1));
        e.addParameter((SearchParameterBase)new ValueParameter(ScheduleSearchKey.CONTEXT.toString(), SearchType.NUMERIC, (Object)contextId));
        this.addDateCriterion(e, date, null);
        ListParameter scheduleList = new ListParameter(ScheduleSearchKey.STATUS.toString(), SearchType.NUMERIC);
        Object[] statusOrdinals = new Object[status.length];
        for (int i = 0; i < status.length; ++i) {
            statusOrdinals[i] = status[i].ordinal();
        }
        scheduleList.addValues(statusOrdinals);
        e.addParameter((SearchParameterBase)scheduleList);
        criteria.addParameter((SearchParameterBase)e);
        return this.search(criteria);
    }

    @Override
    public <T extends Schedule> T getPreviousSchedule(T schedule) {
        Collection<T> schedules = this.getPreviousSchedules(schedule, 1);
        if (schedules == null || schedules.isEmpty()) {
            return null;
        }
        return schedules.iterator().next();
    }

    @Override
    public <T extends Schedule> Collection<T> getPreviousSchedules(T schedule, int count) {
        SearchCriteria criteria = new SearchCriteria();
        Entity e = new Entity("schedule", schedule.getClass(), "d");
        e.addParameter((SearchParameterBase)new ValueParameter(ScheduleSearchKey.ACTIVE.toString(), SearchType.NUMERIC, (Object)1));
        if (schedule instanceof Planner) {
            Planner planner = (Planner)Planner.class.cast(schedule);
            e.addParameter((SearchParameterBase)new ValueParameter(ScheduleSearchKey.PARTNER_ID.toString(), SearchType.NUMERIC, (Object)planner.getSourcePartnerID()));
        } else if (schedule instanceof DistributionSchedule) {
            DistributionSchedule pitch = (DistributionSchedule)DistributionSchedule.class.cast(schedule);
            e.addParameter((SearchParameterBase)new ValueParameter(ScheduleSearchKey.CONTEXT.toString(), SearchType.NUMERIC, (Object)pitch.getContextID()));
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        RangeParameter range = new RangeParameter(ScheduleSearchKey.PITCH_DATE.toString(), SearchType.DATE);
        Date to = this.decrementDay(schedule.getDate());
        range.setTo(formatter.format(to));
        e.addParameter((SearchParameterBase)range);
        e.addParameter((SearchParameterBase)new SortParameter(ScheduleSearchKey.PITCH_DATE.toString(), SortingOrder.DESCENDING));
        criteria.addParameter((SearchParameterBase)e);
        criteria.setRecordsCount(count);
        Collection<T> schedules = this.search(criteria);
        return schedules;
    }

    @Override
    @Transactional
    public <T extends Schedule> Collection<T> search(SearchCriteria criteria) {
        SearchCriteria searchCriteria = criteria;
        return (Collection)ScheduleSearchService.search_aroundBody1$advice(this, searchCriteria, TransactionEnforcer.aspectOf(), ScheduleSearchService.class.getDeclaredMethod("search", SearchCriteria.class).getAnnotation(Transactional.class), null);
    }

    @Override
    @Transactional
    public int count(SearchCriteria criteria) {
        SearchCriteria searchCriteria = criteria;
        return Conversions.intValue((Object)ScheduleSearchService.count_aroundBody3$advice(this, searchCriteria, TransactionEnforcer.aspectOf(), ScheduleSearchService.class.getDeclaredMethod("count", SearchCriteria.class).getAnnotation(Transactional.class), null));
    }

    public String getServiceName() {
        return "Schedule Search";
    }

    public void start() {
    }

    public void stop() {
    }

    private void addDateCriterion(Entity e, Date start, Date end) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        if (end != null) {
            RangeParameter range = new RangeParameter(ScheduleSearchKey.PITCH_DATE.toString(), SearchType.DATE, formatter.format(start));
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(end);
            calendar.add(5, -1);
            range.setTo(formatter.format(calendar.getTime()));
            e.addParameter((SearchParameterBase)range);
        } else {
            ValueParameter parameter = new ValueParameter(ScheduleSearchKey.PITCH_DATE.toString(), SearchType.DATE, (Object)new SimpleDateFormat("yyyy-MM-dd").format(start));
            e.addParameter((SearchParameterBase)parameter);
        }
    }

    private Date decrementDay(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(5, -1);
        return calendar.getTime();
    }

    public String getQuery(SearchCriteria criteria) {
        return QueryBuilder.newInstance().buildQuery(criteria);
    }

    private Session getSession() {
        return HibernateContext.getContext().getCurrentSession();
    }

    private static final /* synthetic */ Collection search_aroundBody0(ScheduleSearchService this_, SearchCriteria criteria) {
        String s = this_.getQuery(criteria);
        logger.debug((Object)("Executing query :" + System.getProperty("line.separator") + s));
        Session session = this_.getSession();
        Query query = session.createQuery(s);
        return query.list();
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object search_aroundBody1$advice(ScheduleSearchService this_, SearchCriteria transactional, TransactionEnforcer ajc_aroundClosure, Transactional transactional2, AroundClosure aroundClosure) {
        void e;
        void transactionManager;
        void isTransactionOwner;
        TransactionManager transactionManager2 = null;
        boolean bl = false;
        try {
            transactionManager2 = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            bl = transactionManager2.getTransaction() == null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (!bl) {
            void var9_10 = isTransactionOwner;
            void var10_11 = transactionManager;
            return ScheduleSearchService.search_aroundBody0(this_, transactional);
        }
        try {
            void object;
            e.begin();
            void var11_12 = isTransactionOwner;
            void var12_13 = transactionManager;
            Collection collection = ScheduleSearchService.search_aroundBody0(this_, transactional);
            object.commit();
            return collection;
        }
        catch (Exception exception) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)exception);
            try {
                e.rollback();
            }
            catch (Exception exception2) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)exception2);
            }
            throw new RuntimeException(exception);
        }
    }

    private static final /* synthetic */ int count_aroundBody2(ScheduleSearchService this_, SearchCriteria criteria) {
        String s = QueryBuilder.newInstance().buildCountQuery(criteria);
        logger.debug((Object)("Executing query :" + System.getProperty("line.separator") + s));
        Session session = this_.getSession();
        Query query = session.createQuery(s);
        long count = (Long)query.uniqueResult();
        return (int)count;
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object count_aroundBody3$advice(ScheduleSearchService this_, SearchCriteria transactional, TransactionEnforcer ajc_aroundClosure, Transactional transactional2, AroundClosure aroundClosure) {
        void e;
        void transactionManager;
        void isTransactionOwner;
        TransactionManager transactionManager2 = null;
        boolean bl = false;
        try {
            transactionManager2 = (TransactionManager)new InitialContext().lookup("java:TransactionManager");
            bl = transactionManager2.getTransaction() == null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (!bl) {
            void var9_10 = isTransactionOwner;
            void var10_11 = transactionManager;
            return Conversions.intObject((int)ScheduleSearchService.count_aroundBody2(this_, transactional));
        }
        try {
            void object;
            e.begin();
            void var11_12 = isTransactionOwner;
            void var12_13 = transactionManager;
            Object object2 = Conversions.intObject((int)ScheduleSearchService.count_aroundBody2(this_, transactional));
            object.commit();
            return object2;
        }
        catch (Exception exception) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)exception);
            try {
                e.rollback();
            }
            catch (Exception exception2) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)exception2);
            }
            throw new RuntimeException(exception);
        }
    }
}

