/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.conf;

import com.tandbergtv.metadatamanager.spec.ISpecHandler;
import com.tandbergtv.watchpoint.pmm.title.conf.Specification;
import com.tandbergtv.watchpoint.pmm.title.conf.SpecificationReader;
import com.tandbergtv.watchpoint.pmm.title.conf.SpecificationValidationException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import org.java.plugin.PluginClassLoader;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginRegistry;

public class SpecificationBuilder {
    private static final Logger logger = Logger.getLogger(SpecificationBuilder.class);
    private static final String PLUGIN_ID = "com.tandbergtv.metadata";
    private static final String EXTENSION_POINT_ID = "provider";
    private static final String DEFINITION_PATH_PARAMETER = "definitionResource";
    private static final String TABLE_CONFIG_PARAMETER = "tableConfigurationResource";
    private static final String SPEC_ALIAS = "alias";
    private static final String BUNDLE_NAME = "resourcebundle";
    private PluginManager pluginManager = null;
    private Map<String, ISpecHandler> spechandlers;

    private SpecificationBuilder(PluginManager pluginManager, Map<String, ISpecHandler> spechandlers) {
        this.pluginManager = pluginManager;
        this.spechandlers = spechandlers;
    }

    public static SpecificationBuilder createInstance(PluginManager pluginManager, Map<String, ISpecHandler> spechandlers) {
        return new SpecificationBuilder(pluginManager, spechandlers);
    }

    public Collection<Specification> buildSpecifications() {
        ArrayList<Specification> specifications = new ArrayList<Specification>();
        PluginRegistry pluginRegistry = this.pluginManager.getRegistry();
        ExtensionPoint point = pluginRegistry.getExtensionPoint(PLUGIN_ID, EXTENSION_POINT_ID);
        Collection extensions = point.getAvailableExtensions();
        for (Extension extension : extensions) {
            PluginDescriptor descriptor = extension.getDeclaringPluginDescriptor();
            try {
                if (!this.pluginManager.isPluginActivated(descriptor)) {
                    this.pluginManager.activatePlugin(descriptor.getId());
                }
                this.validateExtension(extension);
                Specification specification = this.buildSpecification(extension);
                this.validateSpecification(specification);
                specifications.add(specification);
                logger.debug((Object)("Added support for " + specification.getName()));
            }
            catch (Exception e) {
                String key = descriptor.getId() + ":" + extension.getId();
                logger.error((Object)("Failed to load title specification extension: " + key), (Throwable)e);
            }
        }
        this.removeDuplicates(specifications);
        return specifications;
    }

    private Specification buildSpecification(Extension extension) throws SpecificationValidationException {
        PluginDescriptor descriptor = extension.getDeclaringPluginDescriptor();
        PluginClassLoader classloader = this.pluginManager.getPluginClassLoader(descriptor);
        String definitionPath = extension.getParameter(DEFINITION_PATH_PARAMETER).valueAsString();
        InputStream stream = classloader.getResourceAsStream(definitionPath);
        SpecificationReader reader = new SpecificationReader();
        Specification specification = reader.unmarshal(stream);
        specification.setClassLoader((ClassLoader)classloader);
        String tableConfigPath = extension.getParameter(TABLE_CONFIG_PARAMETER).valueAsString();
        specification.setDefinitionPath(definitionPath);
        specification.setTableConfigurationPath(tableConfigPath);
        this.setSpecHandler(specification, extension);
        Extension.Parameter bundleparameter = extension.getParameter(BUNDLE_NAME);
        if (bundleparameter != null) {
            logger.debug((Object)("Bundle name " + bundleparameter.valueAsString()));
            ResourceBundle bundle = ResourceBundle.getBundle(bundleparameter.valueAsString(), Locale.getDefault(), (ClassLoader)classloader);
            specification.setBundle(bundle);
        }
        return specification;
    }

    private void setSpecHandler(Specification specification, Extension extension) {
        Extension.Parameter alias = extension.getParameter(SPEC_ALIAS);
        if (alias == null) {
            logger.warn((Object)("No alias found, specification " + specification.getName() + " won't have an ISpecHandler"));
            return;
        }
        ISpecHandler sh = this.spechandlers.get(alias.valueAsString());
        if (sh != null) {
            logger.debug((Object)("Found " + sh.getClass().getName() + " for " + specification.getName()));
        }
        specification.setSpecHandler(sh);
    }

    private void validateExtension(Extension extension) throws SpecificationValidationException {
    }

    private void validateSpecification(Specification specification) throws SpecificationValidationException {
    }

    private void removeDuplicates(Collection<Specification> allSpecifications) {
        HashMap<String, ArrayList<Specification>> specificationNameMap = new HashMap<String, ArrayList<Specification>>();
        for (Specification specification : allSpecifications) {
            String name = specification.getName();
            ArrayList<Specification> specifications = (ArrayList<Specification>)specificationNameMap.get(name);
            if (specifications == null) {
                specifications = new ArrayList<Specification>();
                specificationNameMap.put(name, specifications);
            }
            specifications.add(specification);
        }
        for (String name : specificationNameMap.keySet()) {
            List specifications = (List)specificationNameMap.get(name);
            if (specifications.size() <= 1) continue;
            allSpecifications.removeAll(specifications);
            logger.warn((Object)("Detected duplicate specifications(" + specifications.size() + ") with same name: " + name + ", ignoring all specifications with this name."));
        }
    }
}

