/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.title.provider.internal;

import com.tandbergtv.watchpoint.pmm.title.provider.ITitleProvider;
import com.tandbergtv.watchpoint.pmm.title.provider.ITitleProviderRegistry;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class TitleProviderRegistry
implements ITitleProviderRegistry {
    private Map<String, ITitleProvider> registry = new HashMap<String, ITitleProvider>();
    private static final String SYSTEM_ID = "01";

    @Override
    public void addProvider(ITitleProvider provider) {
        this.registry.put(provider.getSystemID(), provider);
    }

    @Override
    public ITitleProvider getDefaultProvider() {
        return this.registry.get(SYSTEM_ID);
    }

    @Override
    public ITitleProvider getProvider(String id) {
        return this.registry.get(id);
    }

    @Override
    public ITitleProvider getProviderForTitle(String titleExternalLocation) {
        int index;
        String systemId = "";
        if (titleExternalLocation != null && (index = titleExternalLocation.indexOf("-")) != -1) {
            systemId = titleExternalLocation.substring(0, index);
        }
        return this.getProvider(systemId);
    }

    @Override
    public Collection<ITitleProvider> getProviders() {
        return this.registry.values();
    }

    @Override
    public Collection<ITitleProvider> getProviders(String specification) {
        HashSet<ITitleProvider> providers = new HashSet<ITitleProvider>();
        for (ITitleProvider provider : this.registry.values()) {
            if (!provider.supportsSpecification(specification)) continue;
            providers.add(provider);
        }
        return providers;
    }

    @Override
    public void removeProvider(ITitleProvider provider) {
        this.registry.remove(provider.getSystemID());
    }

    public String getServiceName() {
        return "Title Provider Registry";
    }

    public void start() {
    }

    public void stop() {
        this.registry.clear();
    }
}

