/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.ret;

import com.tandbergtv.marvin.ret.RetNode;
import com.tandbergtv.marvin.ret.RetOperand;
import com.tandbergtv.marvin.ret.RetOperator;
import com.tandbergtv.marvin.ret.RetTreeException;
import com.tandbergtv.marvin.udt.TrePredicate;
import java.io.Serializable;
import java.util.Date;

public class RetTree
implements Serializable {
    private static final long serialVersionUID = 925777970875039685L;
    private String treeName;
    private RetNode root;
    private Date createDate;
    private Date updateDate;

    public RetTree() {
    }

    public static RetTree createTree() {
        return new RetTree();
    }

    public RetTree(String treeName) {
        this.treeName = treeName;
    }

    public RetTree(RetNode root) {
        this.root = root;
    }

    public String getTreeName() {
        return this.treeName;
    }

    public RetNode getRoot() {
        return this.root;
    }

    public void setRoot(RetNode root) {
        this.root = root;
    }

    public void setTreeName(String treeName) {
        this.treeName = treeName;
    }

    public void setRootPredicate(TrePredicate op1) {
        this.root = new RetOperand(op1);
    }

    public static RetNode createBinaryExpression(RetOperator op, TrePredicate op1, TrePredicate op2) throws RetTreeException {
        op.setLeft(new RetOperand(op1));
        op.setRight(new RetOperand(op2));
        return op;
    }

    public static void createUnaryExpression(RetOperator op, TrePredicate op1) throws RetTreeException {
    }

    public void appendExpression(RetOperator op, TrePredicate op1) throws RetTreeException {
        if (this.root == null) {
            throw new RetTreeException();
        }
        RetNode node = this.root;
        while (node.right != null) {
            node = node.right;
        }
        RetNode parent = node.parent;
        parent.right = op;
        op.left = node;
        op.right = new RetOperand(op1);
    }

    private String printTree(String s, RetNode node) {
        if (node.left != null) {
            s = this.printTree(s, node.left);
        }
        s = String.valueOf(s) + node.toString();
        if (node.right != null) {
            s = this.printTree(s, node.right);
        }
        return s;
    }

    public String toString() {
        String s = "";
        System.out.println(this.root);
        s = String.valueOf(s) + this.printTree(s, this.root);
        return s;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }
}

