/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.marvin.udt;

import com.tandbergtv.marvin.ret.RetNode;
import com.tandbergtv.marvin.ret.RetOperator;
import com.tandbergtv.marvin.ret.RetTree;
import com.tandbergtv.marvin.udt.TreExpNode;
import com.tandbergtv.marvin.udt.TreExpValue;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class TreExpList
extends TreExpNode {
    private static final long serialVersionUID = -58138914851857917L;
    public static final String AND = "AND";
    public static final String OR = "OR";
    private String operator;
    protected List<TreExpNode> nodes;

    public TreExpList() {
        this.nodes = new ArrayList<TreExpNode>();
        this.operator = AND;
    }

    public TreExpList(Integer nodeId, String operator, List<TreExpNode> nodes) {
        super(nodeId);
        this.nodes = nodes;
        this.operator = operator;
    }

    public TreExpList(Integer nodeId, String operator, Date createDate, Date updateDate, List<TreExpNode> nodes) {
        super(nodeId, createDate, updateDate);
        this.nodes = nodes;
        this.operator = operator;
    }

    public void setNodes(List<TreExpNode> nodes) {
        this.nodes = nodes;
    }

    public List<TreExpNode> getNodes() {
        return this.nodes;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public String getOperator() {
        return this.operator;
    }

    public RetTree getAsOptimizedExpressionTree() {
        return null;
    }

    public void addItem(TreExpNode node) {
        this.nodes.add(node);
    }

    @Override
    public RetTree getAsOptimizedTree() {
        RetTree tree = new RetTree();
        tree.setRoot(this.buildTree(this));
        return tree;
    }

    protected RetNode buildTree(TreExpList currExpList) {
        RetOperator rootNode;
        List<TreExpNode> currList = currExpList.getNodes();
        if (currList.size() == 0) {
            return null;
        }
        if (currList.size() == 1) {
            if (currList.get(0) instanceof TreExpValue) {
                return ((TreExpValue)currList.get(0)).getAsRetOperand();
            }
            if (currList.get(0) instanceof TreExpList) {
                return this.buildTree((TreExpList)currList.get(0));
            }
        }
        RetOperator currOper = rootNode = new RetOperator(currExpList.getOperator());
        int i = 0;
        while (i < currList.size()) {
            TreExpNode currNode = currList.get(i);
            if (i < currList.size() - 1) {
                if (currNode instanceof TreExpValue) {
                    currOper.setLeft(((TreExpValue)currNode).getAsRetOperand());
                } else if (currNode instanceof TreExpList) {
                    currOper.setLeft(this.buildTree((TreExpList)currNode));
                }
                if (i < currList.size() - 2) {
                    RetOperator temp = new RetOperator(currOper.getOperator());
                    currOper.setRight(temp);
                    currOper = temp;
                }
            } else if (currNode instanceof TreExpValue) {
                currOper.setRight(((TreExpValue)currNode).getAsRetOperand());
            } else if (currNode instanceof TreExpList) {
                currOper.setRight(this.buildTree((TreExpList)currNode));
            }
            ++i;
        }
        return rootNode;
    }
}

