/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.registry.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.java.plugin.registry.Identity;
import org.java.plugin.registry.ManifestProcessingException;
import org.java.plugin.registry.PluginAttribute;
import org.java.plugin.registry.xml.ModelAttribute;
import org.java.plugin.registry.xml.PluginDescriptorImpl;
import org.java.plugin.registry.xml.PluginElementImpl;
import org.java.plugin.registry.xml.PluginFragmentImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PluginAttributeImpl
extends PluginElementImpl<PluginAttribute>
implements PluginAttribute {
    private final PluginAttributeImpl superAttribute;
    private final ModelAttribute model;
    private List<PluginAttribute> subAttributes;

    PluginAttributeImpl(PluginDescriptorImpl pluginDescriptorImpl, PluginFragmentImpl pluginFragmentImpl, ModelAttribute modelAttribute, PluginAttributeImpl pluginAttributeImpl) throws ManifestProcessingException {
        super(pluginDescriptorImpl, pluginFragmentImpl, modelAttribute.getId(), modelAttribute.getDocumentation());
        this.model = modelAttribute;
        this.superAttribute = pluginAttributeImpl;
        if (this.model.getValue() == null) {
            this.model.setValue("");
        }
        this.subAttributes = new ArrayList<PluginAttribute>(this.model.getAttributes().size());
        for (ModelAttribute modelAttribute2 : this.model.getAttributes()) {
            this.subAttributes.add(new PluginAttributeImpl(pluginDescriptorImpl, pluginFragmentImpl, modelAttribute2, this));
        }
        this.subAttributes = Collections.unmodifiableList(this.subAttributes);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("object instantiated: " + this));
        }
    }

    @Override
    public PluginAttribute getSubAttribute(String string) {
        PluginAttributeImpl pluginAttributeImpl = null;
        for (PluginAttribute pluginAttribute : this.subAttributes) {
            PluginAttributeImpl pluginAttributeImpl2 = (PluginAttributeImpl)pluginAttribute;
            if (!pluginAttributeImpl2.getId().equals(string)) continue;
            if (pluginAttributeImpl == null) {
                pluginAttributeImpl = pluginAttributeImpl2;
                continue;
            }
            throw new IllegalArgumentException("more than one attribute with ID " + string + " defined in plug-in " + this.getDeclaringPluginDescriptor().getUniqueId());
        }
        return pluginAttributeImpl;
    }

    @Override
    public Collection<PluginAttribute> getSubAttributes() {
        return this.subAttributes;
    }

    @Override
    public Collection<PluginAttribute> getSubAttributes(String string) {
        LinkedList<PluginAttributeImpl> linkedList = new LinkedList<PluginAttributeImpl>();
        for (PluginAttribute pluginAttribute : this.subAttributes) {
            PluginAttributeImpl pluginAttributeImpl = (PluginAttributeImpl)pluginAttribute;
            if (!pluginAttributeImpl.getId().equals(string)) continue;
            linkedList.add(pluginAttributeImpl);
        }
        return Collections.unmodifiableList(linkedList);
    }

    @Override
    public String getValue() {
        return this.model.getValue();
    }

    @Override
    protected boolean isEqualTo(Identity identity) {
        if (!super.isEqualTo(identity)) {
            return false;
        }
        PluginAttributeImpl pluginAttributeImpl = (PluginAttributeImpl)identity;
        if (this.getSuperAttribute() == null && pluginAttributeImpl.getSuperAttribute() == null) {
            return true;
        }
        if (this.getSuperAttribute() == null || pluginAttributeImpl.getSuperAttribute() == null) {
            return false;
        }
        return this.getSuperAttribute().equals(pluginAttributeImpl.getSuperAttribute());
    }

    @Override
    public PluginAttribute getSuperAttribute() {
        return this.superAttribute;
    }
}

