/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.specimpl;

import com.tandbergtv.metadatamanager.exception.SearchException;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.search.AssetSearchService;
import com.tandbergtv.metadatamanager.search.CriteriaBuilder;
import com.tandbergtv.metadatamanager.spec.IIdentifier;
import com.tandbergtv.workflow.util.SearchCriteria;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.springframework.transaction.annotation.Transactional;

public abstract class IdentifierBase
implements IIdentifier,
Serializable {
    private static final long serialVersionUID = 2127389786395783352L;
    private AssetSearchService searchService;
    private URL mappingResourceUrl;

    public URL getMappingResourceUrl() {
        return this.mappingResourceUrl;
    }

    public void setMappingResourceUrl(URL mappingResourceUrl) {
        this.mappingResourceUrl = mappingResourceUrl;
    }

    @Override
    @Transactional
    public Asset getAsset() throws SearchException {
        Collection<Object> assets = new ArrayList();
        com.tandbergtv.metadatamanager.model.SearchCriteria criteriaMap = this.buildSearchCriteriaMap(this.getSpecIdentifiers(), this.getTTVPaths());
        SearchCriteria criteria = this.buildSearchCriteria(criteriaMap);
        if (criteria.getSearchList().size() > 0) {
            assets = this.searchService.search(criteria);
        }
        if (assets.size() == 0) {
            throw new SearchException("No asset found with id: " + criteriaMap.toString());
        }
        if (assets.size() > 1) {
            throw new SearchException("Multiple assets found with id: " + criteria.toString());
        }
        return (Asset)assets.iterator().next();
    }

    protected SearchCriteria buildSearchCriteria(com.tandbergtv.metadatamanager.model.SearchCriteria criteriaMap) {
        criteriaMap.put("rootlevel", "true");
        return CriteriaBuilder.buildFieldSearchCriteria(criteriaMap);
    }

    protected com.tandbergtv.metadatamanager.model.SearchCriteria buildSearchCriteriaMap(Map<String, String> idFields, Map<String, String> ttvXpaths) {
        com.tandbergtv.metadatamanager.model.SearchCriteria criteria = new com.tandbergtv.metadatamanager.model.SearchCriteria();
        for (Map.Entry<String, String> entry : idFields.entrySet()) {
            if (!ttvXpaths.containsKey(entry.getKey())) continue;
            criteria.put(ttvXpaths.get(entry.getKey()), entry.getValue());
        }
        return criteria;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Map<String, String> ids = this.getSpecIdentifiers();
        Iterator<Map.Entry<String, String>> iter = ids.entrySet().iterator();
        while (iter.hasNext()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            Map.Entry<String, String> entry = iter.next();
            sb.append(entry.getKey());
            sb.append("[");
            sb.append(entry.getValue());
            sb.append("]");
        }
        return sb.toString();
    }

    public AssetSearchService getSearchService() {
        return this.searchService;
    }

    public void setSearchService(AssetSearchService searchService) {
        this.searchService = searchService;
    }
}

