/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.binxml;

import java.util.HashMap;
import java.util.Vector;
import javax.xml.namespace.QName;
import oracle.xml.binxml.BinXMLSchema;
import oracle.xml.parser.schema.XSDAnnotation;
import oracle.xml.parser.schema.XSDAny;
import oracle.xml.parser.schema.XSDAttribute;
import oracle.xml.parser.schema.XSDComplexType;
import oracle.xml.parser.schema.XSDConstantValues;
import oracle.xml.parser.schema.XSDDataValue;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.schema.XSDSimpleType;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Attr;

public class BinXMLProperty
implements XSDConstantValues {
    short kidnum = (short)-1;
    HashMap kidnummap;
    Vector kids;
    boolean sequential = true;
    int typeId = -1;
    int propId = -1;
    XSDNode xnode;
    XSDNode typenode;
    QName qname;
    int csxencodingtypeid;
    int xtypecode;
    short maxkidnum = 0;
    Vector enums;
    BinXMLSchema bxschema;
    static final int BIN_XML_PROPERTY_ELEMENT = 1;
    static final int BIN_XML_PROPERTY_ATTRIBUTE = 2;
    static final int BIN_XML_PROPERTY_COMPLEX_TYPE = 4;
    static final int BIN_XML_PROPERTY_SIMPLE_TYPE = 8;

    BinXMLProperty() {
    }

    Vector getKidProperties() {
        return this.kids;
    }

    void setKidProperties(Vector vector) {
        this.kids = vector;
    }

    void addKid(BinXMLProperty binXMLProperty, short s) {
        if (this.kids == null) {
            this.kids = new Vector();
        }
        if (this.kids.contains(binXMLProperty)) {
            return;
        }
        this.kids.add(s - 1, binXMLProperty);
        this.kids.set(s - 1, binXMLProperty);
    }

    void setKidNum(BinXMLProperty binXMLProperty, short s) {
        this.kidnum = s;
        if (this.kidnummap == null) {
            this.kidnummap = new HashMap(5);
        }
        this.kidnummap.put(binXMLProperty, s);
    }

    void setKidNumMap(HashMap hashMap) {
        this.kidnummap = hashMap;
    }

    HashMap getKidNumMap() {
        return this.kidnummap;
    }

    void setBinXMLSchema(BinXMLSchema binXMLSchema) {
        this.bxschema = binXMLSchema;
    }

    BinXMLSchema getBinXMLSchema() {
        return this.bxschema;
    }

    void setXSDTypeCode(int n) {
        this.xtypecode = n;
    }

    public boolean isSequential() {
        return this.sequential;
    }

    void setIsSequential(boolean bl) {
        this.sequential = bl;
    }

    public int getTypeId() {
        return this.typeId;
    }

    void setTypeId(int n) {
        this.typeId = n;
    }

    void setCSXEncodingType(int n) {
        this.csxencodingtypeid = n;
    }

    public int getCSXEncodingType() {
        return this.csxencodingtypeid;
    }

    void setTypeNode(XSDNode xSDNode) {
        this.typenode = xSDNode;
    }

    XSDNode getTypeNode() {
        return this.typenode;
    }

    public QName getQName() {
        return this.qname;
    }

    void setQName(QName qName) {
        this.qname = qName;
    }

    void setPropId(int n) {
        this.propId = n;
    }

    public int getPropId() {
        return this.propId;
    }

    boolean isSubstitutionGroupMember() {
        if (!(this.xnode instanceof XSDElement)) {
            return false;
        }
        XMLElement xMLElement = this.xnode.getDomNode();
        Attr attr = xMLElement.getAttributeNodeNS("", "substitutionGroup");
        return attr != null;
    }

    boolean isAnyAttr() {
        return this.qname.getLocalPart().equals("anyAttribute") && this.qname.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema");
    }

    boolean isAnyElement() {
        return this.xnode instanceof XSDAny;
    }

    boolean isAttribute() {
        return this.xtypecode == 2;
    }

    boolean isElement() {
        return this.xtypecode == 1;
    }

    boolean isSimpleType() {
        return this.xtypecode == 8;
    }

    boolean isComplexType() {
        return this.xtypecode == 4;
    }

    XSDNode getXSDNode() {
        return this.xnode;
    }

    void setXSDNode(XSDNode xSDNode) {
        this.xnode = xSDNode;
        this.enums = this.generateEnumerationVector();
    }

    int getEnumID(XSDDataValue xSDDataValue) {
        if (this.enums == null) {
            return -1;
        }
        for (int i = 0; i < this.enums.size(); ++i) {
            XSDDataValue xSDDataValue2 = (XSDDataValue)this.enums.get(i);
            if (xSDDataValue2 != xSDDataValue) continue;
            return i;
        }
        return -1;
    }

    int getEnumID(String string) {
        if (this.enums == null) {
            return -1;
        }
        for (int i = 0; i < this.enums.size(); ++i) {
            XSDDataValue xSDDataValue = (XSDDataValue)this.enums.get(i);
            if (!xSDDataValue.getLexicalValue().equals(string)) continue;
            return i;
        }
        return -1;
    }

    String getEnum(int n) {
        if (this.enums == null || n >= this.enums.size()) {
            return "";
        }
        String string = (String)this.enums.get(n);
        return string;
    }

    short getKidNum() {
        return this.kidnum;
    }

    public short getKidNum(BinXMLProperty binXMLProperty) {
        if (binXMLProperty == null) {
            return this.kidnum;
        }
        if (this.kidnummap == null) {
            return this.kidnum;
        }
        Short s = (Short)this.kidnummap.get(binXMLProperty);
        if (s == null) {
            XSDNode xSDNode = binXMLProperty.getTypeNode();
            if (xSDNode != null) {
                XSDAnnotation xSDAnnotation = xSDNode.getAnnotation();
                if (xSDAnnotation != null) {
                    BinXMLProperty binXMLProperty2 = (BinXMLProperty)xSDAnnotation.getObject();
                    s = (Short)this.kidnummap.get(binXMLProperty2);
                    return s;
                }
                return -1;
            }
            return -1;
        }
        return s;
    }

    short getMaxKidNum() {
        if (this.kids != null) {
            return (short)this.kids.size();
        }
        return 0;
    }

    private Vector generateEnumerationVector() {
        Vector vector = null;
        int n = this.xnode.getNodeType();
        switch (n) {
            case 3: {
                XSDElement xSDElement = (XSDElement)this.xnode;
                vector = xSDElement.getEnumeratedValues();
                break;
            }
            case 4: {
                XSDAttribute xSDAttribute = (XSDAttribute)this.xnode;
                XSDSimpleType xSDSimpleType = (XSDSimpleType)xSDAttribute.getType();
                vector = xSDSimpleType.getEnumeration();
                break;
            }
            case 2: {
                XSDSimpleType xSDSimpleType = (XSDSimpleType)this.xnode;
                vector = xSDSimpleType.getEnumeration();
                break;
            }
            case 1: {
                XSDComplexType xSDComplexType = (XSDComplexType)this.xnode;
                if (!xSDComplexType.isSimpleContent()) break;
                XSDSimpleType xSDSimpleType = xSDComplexType.getSimpleType();
                vector = xSDSimpleType.getEnumeration();
                break;
            }
        }
        return vector;
    }
}

