/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal;

import com.tandbergtv.workflow.core.Datatype;
import com.tandbergtv.workflow.driver.internal.TypeConversionException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class DatatypeConverter {
    private static DatatypeConverter instance;
    private static final Lock lock;
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private DateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd");

    private DatatypeConverter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatatypeConverter getInstance() {
        lock.lock();
        try {
            if (instance == null) {
                instance = new DatatypeConverter();
            }
        }
        finally {
            lock.unlock();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object convert(Object input, Datatype type) throws TypeConversionException {
        if (input == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        Object ret = input.toString();
        try {
            switch (type) {
                case INT: {
                    ret = Integer.valueOf(input.toString());
                    break;
                }
                case BOOLEAN: {
                    ret = Boolean.valueOf(input.toString());
                    break;
                }
                case DATE: {
                    lock.lock();
                    try {
                        ret = this.dateformat.parse(input.toString());
                        break;
                    }
                    finally {
                        lock.unlock();
                    }
                }
                case DURATION: {
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new TypeConversionException("Failed to convert " + input + " to type " + type, e);
        }
        return ret;
    }

    static {
        lock = new ReentrantLock();
    }
}

