/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.ruleengine;

import com.tandbergtv.ruleengine.RuleEngineAdaptor;
import com.tandbergtv.workflow.adaptor.AdaptorException;
import com.tandbergtv.workflow.adaptor.conf.IAdaptorConfiguration;
import com.tandbergtv.workflow.comm.IDevice;
import com.tandbergtv.workflow.comm.ISource;
import com.tandbergtv.workflow.comm.routing.RoutingServiceFactory;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.MessageUIDImpl;
import com.tandbergtv.workflow.message.WPCLCommand;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.util.WPCLConverter;
import java.util.HashMap;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.naming.InitialContext;
import org.apache.log4j.Logger;

public class NormalizationRulesResponseHandler {
    private IAdaptorConfiguration conf = null;
    private static QueueConnection queueConnection = null;
    private static QueueSession queueSession = null;
    private static Queue queue = null;
    private static final String RESPONSE_QUEUE_NAME = "responseQueue";
    private Logger logger = Logger.getLogger(NormalizationRulesResponseHandler.class);
    private static final String CORRELATION_ID_PARAMETER = "correlationId";
    private static final String STATUS_MESSAGE = "statusMessage";
    private static final String RESPONSE_UID = "re0103";
    private RuleEngineAdaptor adaptor = null;

    public NormalizationRulesResponseHandler(RuleEngineAdaptor adaptor, IAdaptorConfiguration arg0) {
        this.conf = arg0;
        this.adaptor = adaptor;
        this.initializeQueue();
    }

    public NormalizationRulesResponseHandler() {
    }

    private void initializeQueue() {
        try {
            InitialContext context = new InitialContext();
            queue = (Queue)context.lookup((String)this.conf.getParameterValue(RESPONSE_QUEUE_NAME));
            QueueConnectionFactory factory = (QueueConnectionFactory)context.lookup("ConnectionFactory");
            queueConnection = factory.createQueueConnection();
            queueSession = queueConnection.createQueueSession(false, 1);
            queueConnection.start();
            MessageConsumer consumer = queueSession.createConsumer((Destination)queue);
            consumer.setMessageListener((MessageListener)new QueueListener());
            this.logger.debug((Object)"Normalization progress queue listener initialized");
        }
        catch (Exception e) {
            this.logger.error((Object)"Error creating normalization progress queue listener", (Throwable)e);
        }
    }

    private IMessage prepareTaskCompleteMessage(String id, String status) throws AdaptorException {
        WorkflowMessage response = new WorkflowMessage((IMessageUID)new MessageUIDImpl(RESPONSE_UID));
        response.setType(WorkflowMessage.MessageType.notification);
        response.putValue(CORRELATION_ID_PARAMETER, id);
        response.putValue(STATUS_MESSAGE, status);
        response.setCommand(new WPCLCommand("task-complete"));
        IDevice rulesDevice = this.adaptor.getRulesDevice();
        if (rulesDevice == null) {
            this.logger.warn((Object)"Cannot get rules source URL");
        }
        response.setSource((ISource)rulesDevice);
        try {
            return new WPCLConverter().convert(response);
        }
        catch (Exception ex) {
            throw new AdaptorException((Throwable)ex);
        }
    }

    private IMessage prepareTaskUpdateMessage(int percent, String id, String status) throws AdaptorException {
        WorkflowMessage response = new WorkflowMessage((IMessageUID)new MessageUIDImpl(RESPONSE_UID));
        IDevice rulesDevice = this.adaptor.getRulesDevice();
        if (rulesDevice == null) {
            this.logger.warn((Object)"Cannot get rules source URL");
        }
        response.setSource((ISource)rulesDevice);
        response.setType(WorkflowMessage.MessageType.notification);
        response.putValue(CORRELATION_ID_PARAMETER, id);
        response.putValue(STATUS_MESSAGE, status);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("percent", new Integer(percent).toString());
        response.setCommand(new WPCLCommand("task-update", paramMap));
        try {
            return new WPCLConverter().convert(response);
        }
        catch (Exception ex) {
            throw new AdaptorException((Throwable)ex);
        }
    }

    private IMessage prepareNackMessage(String correlationID, String errorMessage) throws AdaptorException {
        WorkflowMessage response = new WorkflowMessage((IMessageUID)new MessageUIDImpl(RESPONSE_UID));
        response.setType(WorkflowMessage.MessageType.nack);
        response.putValue(CORRELATION_ID_PARAMETER, correlationID);
        IDevice rulesDevice = this.adaptor.getRulesDevice();
        if (rulesDevice == null) {
            this.logger.warn((Object)"Cannot get rules source URL");
        }
        response.setSource((ISource)rulesDevice);
        response.getPayload().putValue("error-message", errorMessage);
        response.setCommand(new WPCLCommand("task-complete"));
        try {
            IMessage res = new WPCLConverter().convert(response);
            this.logger.debug((Object)("Nack message = " + res.getPayload().getContent()));
            return res;
        }
        catch (Exception ex) {
            throw new AdaptorException((Throwable)ex);
        }
    }

    public void destroy() {
        this.logger.info((Object)"Destroying Normalization Response handler");
        try {
            if (queueConnection != null) {
                this.logger.info((Object)"Closing queue connection");
                queueConnection.close();
            }
            if (queueSession != null) {
                this.logger.info((Object)"Closing queue session");
                queueSession.close();
            }
        }
        catch (Exception e) {
            this.logger.warn((Object)("Error closing queue session : " + e.getMessage()), (Throwable)e);
        }
    }

    private class QueueListener
    implements MessageListener {
        private QueueListener() {
        }

        public void onMessage(Message message) {
            IMessage wfsMessage = null;
            String correlationID = "";
            try {
                int percent;
                NormalizationRulesResponseHandler.this.logger.debug((Object)("Handling message with correlation id : " + message.getJMSCorrelationID()));
                String status = message.getStringProperty("status");
                boolean success = message.getBooleanProperty("success");
                correlationID = message.getJMSCorrelationID();
                wfsMessage = success ? ((percent = message.getIntProperty("percent")) == 100 ? NormalizationRulesResponseHandler.this.prepareTaskCompleteMessage(correlationID, status) : NormalizationRulesResponseHandler.this.prepareTaskUpdateMessage(percent, correlationID, status)) : NormalizationRulesResponseHandler.this.prepareNackMessage(correlationID, status);
            }
            catch (Exception e) {
                NormalizationRulesResponseHandler.this.logger.warn((Object)("Error reading progress - " + e.getMessage()), (Throwable)e);
                try {
                    wfsMessage = NormalizationRulesResponseHandler.this.prepareNackMessage(correlationID, e.getMessage());
                }
                catch (Exception ex) {
                    NormalizationRulesResponseHandler.this.logger.warn((Object)("Error creating Nack message : " + ex.getMessage()), (Throwable)ex);
                }
            }
            IMessage response = null;
            try {
                response = RoutingServiceFactory.newInstance().createRoutingService().send(wfsMessage);
                NormalizationRulesResponseHandler.this.logger.debug((Object)("Response receieved:" + response.getPayload().getContent()));
            }
            catch (Exception e) {
                NormalizationRulesResponseHandler.this.logger.error((Object)("Error sending message - " + e.getMessage()), (Throwable)e);
            }
        }
    }
}

