/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.ruleengine;

import com.tandbergtv.ruleengine.CreateProcessHandler;
import com.tandbergtv.ruleengine.NormalizationRulesResponseHandler;
import com.tandbergtv.ruleengine.RunNormalizationRuleHandler;
import com.tandbergtv.workflow.adaptor.AdaptorException;
import com.tandbergtv.workflow.adaptor.IAdaptor;
import com.tandbergtv.workflow.adaptor.IAdaptorRequest;
import com.tandbergtv.workflow.adaptor.IAdaptorResponse;
import com.tandbergtv.workflow.adaptor.conf.IAdaptorConfiguration;
import com.tandbergtv.workflow.comm.IDevice;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.util.WPCLConverter;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public class RuleEngineAdaptor
implements IAdaptor {
    private static final String CREATE_PROCESS_UID = "re0101";
    private static final String RUN_NORMALIZATION_RULE_UID = "01re02";
    private static final String SEND_NORMALIZATION_PROGRESS_UID = "re0103";
    private static final List<String> messages = Arrays.asList("re0101", "01re02", "re0103");
    private Logger logger = Logger.getLogger(RuleEngineAdaptor.class);
    IAdaptorConfiguration conf = null;
    private IDevice rulesDevice = null;

    public boolean canDeliver(IAdaptorRequest arg0) {
        try {
            WPCLConverter converter = new WPCLConverter();
            WorkflowMessage wfsMessage = converter.convert(arg0.getMessage());
            if (messages.contains(wfsMessage.getMessageUID().getUID())) {
                return true;
            }
        }
        catch (Exception ex) {
            this.logger.warn((Object)("Unable to handle message " + arg0.getMessage().getPayload().getContent()), (Throwable)ex);
        }
        return false;
    }

    public void init(IAdaptorConfiguration arg0) {
        this.conf = arg0;
        try {
            new NormalizationRulesResponseHandler(this, arg0);
        }
        catch (Exception e) {
            this.logger.error((Object)"Problem initialzing Rules Engine Adaptor", (Throwable)e);
        }
        this.logger.info((Object)"Initialized");
    }

    public IAdaptorResponse transmit(IAdaptorRequest arg0) throws AdaptorException {
        IAdaptorResponse response = null;
        WorkflowMessage message = null;
        try {
            message = new WPCLConverter().convert(arg0.getMessage());
        }
        catch (Exception e) {
            throw new AdaptorException((Throwable)e);
        }
        IMessageUID messageUID = message.getMessageUID();
        this.logger.debug((Object)("Processing message[" + messageUID.getUID() + "] - " + messageUID.getName()));
        if (messageUID.getUID().equals(CREATE_PROCESS_UID)) {
            response = new CreateProcessHandler().handleMessage(message);
        } else if (messageUID.getUID().equals(RUN_NORMALIZATION_RULE_UID)) {
            this.setRulesDevice(arg0);
            response = new RunNormalizationRuleHandler(this.conf).handleMessage(message);
        }
        return response;
    }

    public void destroy() {
        new NormalizationRulesResponseHandler().destroy();
        this.logger.info((Object)"Destroyed");
    }

    private void setRulesDevice(IAdaptorRequest req) {
        IDevice destination;
        this.rulesDevice = destination = (IDevice)req.getDestinations().get(0);
    }

    public IDevice getRulesDevice() {
        return this.rulesDevice;
    }
}

