/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.adaptor.handler;

import com.tandbergtv.workflow.adaptor.conf.IHandlerConfiguration;
import com.tandbergtv.workflow.adaptor.handler.AbstractHandler;
import com.tandbergtv.workflow.adaptor.handler.HandlerException;
import com.tandbergtv.workflow.message.HTTPAttachment;
import com.tandbergtv.workflow.message.HTTPMessage;
import com.tandbergtv.workflow.message.HTTPPayload;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.util.XMLDocumentUtility;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteFilesHandler
extends AbstractHandler {
    private static final Logger logger = Logger.getLogger(DeleteFilesHandler.class);
    private static final String SOAP_NAMESPACE = "http://schemas.xmlsoap.org/soap/envelope/";
    private static final String SOAP_ENVELOPE_TAG = "Envelope";
    private static final String SOAP_BODY_TAG = "Body";
    private static final String SOAP_PREFIX = "soapenv";
    private static final String SCHEMA_ATTR = "xml:xsd";
    private static final String SCHEMA_INSTANCE_ATTR = "xml:xsi";

    public DeleteFilesHandler() {
    }

    public DeleteFilesHandler(IHandlerConfiguration conf) {
        super(conf);
    }

    public IMessage process(IMessage msg) throws HandlerException {
        logger.debug((Object)("Processing message: " + msg));
        String messageContent = msg.getPayload().getContent();
        try {
            messageContent = this.convertCommaSepPathsToListOfPath(messageContent);
        }
        catch (Exception e) {
            throw new HandlerException("Cannot convert PathList(comma-separated list) parameter to list of Path parameters", (Throwable)e);
        }
        String soapEnvelope = this.createSOAPEnvelope(messageContent);
        HTTPMessage result = this.constructMessage(soapEnvelope, msg);
        logger.debug((Object)("Processed Message: " + result));
        return result;
    }

    public IMessage postProcess(IMessage msg) throws HandlerException {
        logger.debug((Object)("Post processing message: " + msg));
        String response = this.removeSOAPEnvelope(msg.getPayload().getContent());
        HTTPMessage result = this.constructMessage(response, msg);
        logger.debug((Object)("Post processed Response: " + msg));
        return result;
    }

    private String convertCommaSepPathsToListOfPath(String content) throws Exception {
        Node pathListNode;
        logger.debug((Object)("Content: " + content));
        Document doc = XMLDocumentUtility.loadXml((String)content);
        XPath xpath = XPathFactory.newInstance().newXPath();
        Node parameterListNode = (Node)xpath.evaluate("//WFSMessage/MessageBody/ParameterList", doc, XPathConstants.NODE);
        if (parameterListNode != null && (pathListNode = (Node)xpath.evaluate("Parameter[@Name='PathList']", parameterListNode, XPathConstants.NODE)) != null) {
            String pathList = (String)xpath.evaluate("Value", pathListNode, XPathConstants.STRING);
            pathListNode.getParentNode().removeChild(pathListNode);
            int i = 1;
            for (String path : this.convertCommaSepListToList(pathList)) {
                parameterListNode.appendChild(this.createWPCLParamElement(doc, "Path" + i++, path.trim()));
            }
        }
        return XMLDocumentUtility.convertToString((Node)doc);
    }

    private Element createWPCLParamElement(Document doc, String name, String value) {
        Element paramElement = doc.createElement("Parameter");
        paramElement.setAttribute("DataType", "String");
        paramElement.setAttribute("Name", name);
        Element valueElement = doc.createElement("Value");
        valueElement.setTextContent(value);
        paramElement.appendChild(valueElement);
        return paramElement;
    }

    private List<String> convertCommaSepListToList(String str) {
        ArrayList<String> result = new ArrayList<String>();
        if (str != null) {
            StringTokenizer st = new StringTokenizer(str, ",");
            while (st.hasMoreTokens()) {
                result.add(st.nextToken());
            }
        }
        return result;
    }

    private HTTPMessage constructMessage(String content, IMessage originalMessage) {
        HTTPPayload payload = new HTTPPayload(content);
        HTTPAttachment attachment = null;
        if (originalMessage.getAttachment() != null) {
            Object attachContent = originalMessage.getAttachment().getContent();
            String attachType = originalMessage.getAttachment().getContentType();
            attachment = new HTTPAttachment(attachContent, attachType);
        }
        return new HTTPMessage(payload, attachment);
    }

    private String createSOAPEnvelope(String xmlString) throws HandlerException {
        try {
            Document soapDocument = XMLDocumentUtility.loadXml((String)xmlString, (boolean)true);
            Element documentElement = soapDocument.getDocumentElement();
            Element envelope = soapDocument.createElementNS(SOAP_NAMESPACE, SOAP_ENVELOPE_TAG);
            envelope.setPrefix(SOAP_PREFIX);
            envelope.setAttribute(SCHEMA_ATTR, "http://www.w3.org/2001/XMLSchema");
            envelope.setAttribute(SCHEMA_INSTANCE_ATTR, "http://www.w3.org/2001/XMLSchema-instance");
            Element body = soapDocument.createElementNS(SOAP_NAMESPACE, SOAP_BODY_TAG);
            body.setPrefix(SOAP_PREFIX);
            body.appendChild(documentElement);
            envelope.appendChild(body);
            soapDocument.appendChild(envelope);
            return XMLDocumentUtility.convertToString((Node)soapDocument);
        }
        catch (Exception ex) {
            String error = "Failed to create a SOAP Envelope around the XML message payload.";
            throw new HandlerException(error, (Throwable)ex);
        }
    }

    private String removeSOAPEnvelope(String xmlString) throws HandlerException {
        try {
            Document doc = XMLDocumentUtility.loadXml((String)xmlString, (boolean)true);
            NodeList nodeList = doc.getElementsByTagNameNS(SOAP_NAMESPACE, SOAP_ENVELOPE_TAG);
            Element envelope = (Element)nodeList.item(0);
            nodeList = envelope.getElementsByTagNameNS(SOAP_NAMESPACE, SOAP_BODY_TAG);
            Element body = (Element)nodeList.item(0);
            nodeList = body.getChildNodes();
            doc.removeChild(envelope);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                doc.appendChild(nodeList.item(i));
                break;
            }
            return XMLDocumentUtility.convertToString((Node)doc);
        }
        catch (Exception ex) {
            String error = "Failed to remove the SOAP Envelope around the XML message payload";
            throw new HandlerException(error, (Throwable)ex);
        }
    }
}

