/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.adaptor.dispatcher;

import com.systinet.wsdl.com.n2bb.manager.webservice.common.Catcher;
import com.systinet.wsdl.com.n2bb.manager.webservice.common.CatcherGroup;
import com.systinet.wsdl.com.n2bb.manager.webservice.server.SchedulerService;
import com.systinet.wsdl.com.n2bb.manager.webservice.server.SchedulerService_getCatcherGroups_comN2BbManagerWebserviceCommonServiceException_Fault;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.adaptor.dispatcher.DispatcherException;
import com.tandbergtv.workflow.adaptor.dispatcher.MediaPathAPIException;
import com.tandbergtv.workflow.adaptor.dispatcher.MediaPathDispatcher;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.MessageKeyImpl;
import com.tandbergtv.workflow.message.MessageUIDImpl;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowPayload;
import com.tandbergtv.workflow.util.XMLDocumentUtility;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.rmi.RemoteException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class CatcherGroupDispatcher
extends MediaPathDispatcher {
    private static final Logger logger = Logger.getLogger(CatcherGroupDispatcher.class);

    public CatcherGroupDispatcher(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    protected WorkflowMessage generateResponse(IMessage msg, URL url) throws DispatcherException {
        logger.debug((Object)("payload=" + msg.getPayload().getContent()));
        try {
            Node catcherGroupNameNode;
            Document doc = XMLDocumentUtility.loadXml((String)msg.getPayload().getContent());
            String catcherGroupName = null;
            XPath xpath = XPathFactory.newInstance().newXPath();
            Node parameterListNode = (Node)xpath.evaluate("//WFSMessage/MessageBody/ParameterList", doc, XPathConstants.NODE);
            if (parameterListNode != null && (catcherGroupNameNode = (Node)xpath.evaluate("Parameter[@Name='CatcherGroupName']", parameterListNode, XPathConstants.NODE)) != null) {
                catcherGroupName = (String)xpath.evaluate("Value", catcherGroupNameNode, XPathConstants.STRING);
            }
            Node wfsMessageNode = (Node)xpath.evaluate("//WFSMessage", doc, XPathConstants.NODE);
            String messUID = wfsMessageNode.getAttributes().getNamedItem("UID").getTextContent();
            String requestKey = wfsMessageNode.getAttributes().getNamedItem("RequestKey").getTextContent();
            logger.debug((Object)("messUID=" + messUID + ", requestKey=" + requestKey));
            WorkflowMessage response = new WorkflowMessage((IMessageUID)new MessageUIDImpl(messUID), (IMessageKey)new MessageKeyImpl((Object)requestKey));
            WorkflowPayload payload = response.getPayload();
            try {
                SchedulerService service = this.getService(url);
                String catcherIds = this.getCatcherIds(service, catcherGroupName);
                payload.putValue("CatcherIds", catcherIds);
                response.setType(WorkflowMessage.MessageType.ack);
            }
            catch (MediaPathAPIException de) {
                logger.error((Object)"Error occurred whilce getting CatcherIds: ", (Throwable)de);
                StringWriter writer = new StringWriter();
                de.printStackTrace(new PrintWriter(writer));
                payload.putValue("error-message", de.getMessage());
                payload.putValue("error-stack", writer.toString());
                response.setType(WorkflowMessage.MessageType.nack);
            }
            return response;
        }
        catch (Exception e) {
            throw new DispatcherException((Throwable)e);
        }
    }

    private String getCatcherIds(SchedulerService service, String catcherGroupName) throws MediaPathAPIException {
        CatcherGroup[] catcherGroups;
        String catcherIds = "";
        Catcher[] catchers = null;
        try {
            catcherGroups = service.getCatcherGroups();
        }
        catch (SchedulerService_getCatcherGroups_comN2BbManagerWebserviceCommonServiceException_Fault e) {
            throw new MediaPathAPIException(e);
        }
        catch (RemoteException e) {
            throw new MediaPathAPIException(e);
        }
        for (int i = 0; i < catcherGroups.length; ++i) {
            if (!catcherGroups[i].getName().equalsIgnoreCase(catcherGroupName)) continue;
            catchers = catcherGroups[i].getCatchers();
            break;
        }
        if (catchers != null) {
            for (int j = 0; j < catchers.length; ++j) {
                catcherIds = catcherIds + catchers[j].getId().toString() + ",";
            }
            catcherIds = catcherIds.substring(0, catcherIds.length() - 1);
            logger.debug((Object)("catcherIds=" + catcherIds));
        }
        return catcherIds;
    }
}

