/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.adaptor.dispatcher;

import com.systinet.wsdl.com.n2bb.manager.webservice.common.Catcher;
import com.systinet.wsdl.com.n2bb.manager.webservice.common.PitchItem;
import com.systinet.wsdl.com.n2bb.manager.webservice.common.ScheduledItem;
import com.systinet.wsdl.com.n2bb.manager.webservice.server.SchedulerService;
import com.systinet.wsdl.com.n2bb.manager.webservice.server.SchedulerService_getAllScheduledPitchDetails_comN2BbManagerWebserviceCommonServiceException_Fault;
import com.systinet.wsdl.com.n2bb.manager.webservice.server.SchedulerService_getCatchers_comN2BbManagerWebserviceCommonServiceException_Fault;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.adaptor.dispatcher.DispatcherException;
import com.tandbergtv.workflow.adaptor.dispatcher.MediaPathAPIException;
import com.tandbergtv.workflow.adaptor.dispatcher.MediaPathDispatcher;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.MessageKeyImpl;
import com.tandbergtv.workflow.message.MessageUIDImpl;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowPayload;
import com.tandbergtv.workflow.util.XMLDocumentUtility;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.rmi.RemoteException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class GetPitchStatusDispatcher
extends MediaPathDispatcher {
    private static final Logger logger = Logger.getLogger(GetPitchStatusDispatcher.class);

    public GetPitchStatusDispatcher(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    protected WorkflowMessage generateResponse(IMessage msg, URL url) throws DispatcherException {
        logger.debug((Object)("payload=" + msg.getPayload().getContent()));
        try {
            Node pitchIdNode;
            Document doc = XMLDocumentUtility.loadXml((String)msg.getPayload().getContent());
            String pitchId = null;
            XPath xpath = XPathFactory.newInstance().newXPath();
            Node parameterListNode = (Node)xpath.evaluate("//WFSMessage/MessageBody/ParameterList", doc, XPathConstants.NODE);
            if (parameterListNode != null && (pitchIdNode = (Node)xpath.evaluate("Parameter[@Name='PitchId']", parameterListNode, XPathConstants.NODE)) != null) {
                pitchId = (String)xpath.evaluate("Value", pitchIdNode, XPathConstants.STRING);
            }
            Node wfsMessageNode = (Node)xpath.evaluate("//WFSMessage", doc, XPathConstants.NODE);
            String messUID = wfsMessageNode.getAttributes().getNamedItem("UID").getTextContent();
            String requestKey = wfsMessageNode.getAttributes().getNamedItem("RequestKey").getTextContent();
            logger.debug((Object)("messUID=" + messUID + ", requestKey=" + requestKey));
            WorkflowMessage response = new WorkflowMessage((IMessageUID)new MessageUIDImpl(messUID), (IMessageKey)new MessageKeyImpl((Object)requestKey));
            WorkflowPayload payload = response.getPayload();
            try {
                SchedulerService service = this.getService(url);
                PitchItem[] pitchItems = this.getPitchItems(service, pitchId);
                Long pitchStatusLong = pitchItems[0].getStatus();
                this.setPitchStatusValue(payload, pitchStatusLong);
                if (pitchStatusLong.intValue() != 2) {
                    String failedCatchersNames = this.getFailedCatchersNames(service, pitchItems[0]);
                    payload.putValue("FailedCatchersNames", failedCatchersNames);
                }
                response.setType(WorkflowMessage.MessageType.ack);
            }
            catch (MediaPathAPIException e) {
                String excMsg = "Error occurred while getting the pitch status for a package: ";
                logger.error((Object)excMsg, (Throwable)e);
                StringWriter writer = new StringWriter();
                e.printStackTrace(new PrintWriter(writer));
                payload.putValue("error-message", e.getMessage());
                payload.putValue("error-stack", writer.toString());
                response.setType(WorkflowMessage.MessageType.nack);
            }
            return response;
        }
        catch (Exception e) {
            throw new DispatcherException((Throwable)e);
        }
    }

    private void setPitchStatusValue(WorkflowPayload payload, Long pitchStatusLong) {
        String pitchStatus = "UNKNOWN";
        switch (pitchStatusLong.intValue()) {
            case 0: {
                pitchStatus = "IN_QUEUE";
                break;
            }
            case 1: {
                pitchStatus = "IN_PROGRESS";
                break;
            }
            case 2: {
                pitchStatus = "SUCCESS";
                break;
            }
            case 3: {
                pitchStatus = "ATTEMPTED";
                break;
            }
            case 4: {
                pitchStatus = "STOP_REQUESTED";
                break;
            }
            case 5: {
                pitchStatus = "STOPPED";
                break;
            }
            case 6: {
                pitchStatus = "FAILED";
                break;
            }
            case 7: {
                pitchStatus = "DELETED";
                break;
            }
            case 8: {
                pitchStatus = "ENCRYPTING";
                break;
            }
            default: {
                pitchStatus = "UNKNOWN";
            }
        }
        payload.putValue("PitchStatus", pitchStatus);
    }

    private String getFailedCatchersNames(SchedulerService service, PitchItem pitchItem) throws MediaPathAPIException {
        Catcher[] catchers;
        String failedCatchersNames = "";
        ScheduledItem[] schItems = pitchItem.getItems();
        try {
            catchers = service.getCatchers();
        }
        catch (SchedulerService_getCatchers_comN2BbManagerWebserviceCommonServiceException_Fault e) {
            throw new MediaPathAPIException(e);
        }
        catch (RemoteException e) {
            throw new MediaPathAPIException(e);
        }
        for (int i = 0; i < schItems.length; ++i) {
            String catcherName;
            if (schItems[i].getStatus().intValue() == 2 || (catcherName = this.getCatcherNameById(catchers, schItems[i].getCatcher())).equals("")) continue;
            failedCatchersNames = failedCatchersNames + catcherName + ",";
        }
        if (failedCatchersNames.length() > 0) {
            failedCatchersNames = failedCatchersNames.substring(0, failedCatchersNames.length() - 1);
        }
        logger.debug((Object)("failedCatchersNames=" + failedCatchersNames));
        return failedCatchersNames;
    }

    private String getCatcherNameById(Catcher[] catchers, Long catcherId) throws MediaPathAPIException {
        String catcherName = "";
        for (int i = 0; i < catchers.length; ++i) {
            if (catchers[i].getId().longValue() != catcherId.longValue()) continue;
            catcherName = catchers[i].getDisplayName();
            break;
        }
        return catcherName;
    }

    private PitchItem[] getPitchItems(SchedulerService service, String pitchId) throws MediaPathAPIException {
        long[] pitchIds = new long[]{Long.valueOf(pitchId)};
        try {
            return service.getAllScheduledPitchDetails(pitchIds);
        }
        catch (SchedulerService_getAllScheduledPitchDetails_comN2BbManagerWebserviceCommonServiceException_Fault e) {
            throw new MediaPathAPIException(e);
        }
        catch (RemoteException e) {
            throw new MediaPathAPIException(e);
        }
    }
}

