/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.adaptor.dispatcher;

import com.systinet.wsdl.com.n2bb.manager.webservice.server.SchedulerService;
import com.systinet.wsdl.com.n2bb.manager.webservice.server.SchedulerService_schedule_comN2BbManagerWebserviceCommonServiceException_Fault;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.adaptor.dispatcher.DispatcherException;
import com.tandbergtv.workflow.adaptor.dispatcher.MediaPathAPIException;
import com.tandbergtv.workflow.adaptor.dispatcher.MediaPathDispatcher;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.MessageKeyImpl;
import com.tandbergtv.workflow.message.MessageUIDImpl;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowPayload;
import com.tandbergtv.workflow.util.XMLDocumentUtility;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.rmi.RemoteException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.StringTokenizer;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class PackageSchedulerDispatcher
extends MediaPathDispatcher {
    private static final Logger logger = Logger.getLogger(PackageSchedulerDispatcher.class);
    private static final String DATE_FORMAT = "EEE MMM d HH:mm:ss z yyyy";

    public PackageSchedulerDispatcher(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    protected WorkflowMessage generateResponse(IMessage msg, URL url) throws DispatcherException {
        logger.debug((Object)("payload=" + msg.getPayload().getContent()));
        try {
            Document doc = XMLDocumentUtility.loadXml((String)msg.getPayload().getContent());
            String scheduleDate = null;
            String packageToPitchId = null;
            String encryptPackage = null;
            String pitcherId = null;
            String catcherIdsValues = null;
            XPath xpath = XPathFactory.newInstance().newXPath();
            Node parameterListNode = (Node)xpath.evaluate("//WFSMessage/MessageBody/ParameterList", doc, XPathConstants.NODE);
            if (parameterListNode != null) {
                Node catcherIdsNode;
                Node pitcheIdNode;
                Node encryptPackageNode;
                Node packageIdNode;
                Node scheduleDateNode = (Node)xpath.evaluate("Parameter[@Name='ScheduleDate']", parameterListNode, XPathConstants.NODE);
                if (scheduleDateNode != null) {
                    scheduleDate = (String)xpath.evaluate("Value", scheduleDateNode, XPathConstants.STRING);
                }
                if ((packageIdNode = (Node)xpath.evaluate("Parameter[@Name='PackageId']", parameterListNode, XPathConstants.NODE)) != null) {
                    packageToPitchId = (String)xpath.evaluate("Value", packageIdNode, XPathConstants.STRING);
                }
                if ((encryptPackageNode = (Node)xpath.evaluate("Parameter[@Name='EncryptPackage']", parameterListNode, XPathConstants.NODE)) != null) {
                    encryptPackage = (String)xpath.evaluate("Value", encryptPackageNode, XPathConstants.STRING);
                }
                if ((pitcheIdNode = (Node)xpath.evaluate("Parameter[@Name='PitcherId']", parameterListNode, XPathConstants.NODE)) != null) {
                    pitcherId = (String)xpath.evaluate("Value", pitcheIdNode, XPathConstants.STRING);
                }
                if ((catcherIdsNode = (Node)xpath.evaluate("Parameter[@Name='CatcherIds']", parameterListNode, XPathConstants.NODE)) != null) {
                    catcherIdsValues = (String)xpath.evaluate("Value", catcherIdsNode, XPathConstants.STRING);
                }
            }
            Node wfsMessageNode = (Node)xpath.evaluate("//WFSMessage", doc, XPathConstants.NODE);
            String messUID = wfsMessageNode.getAttributes().getNamedItem("UID").getTextContent();
            String requestKey = wfsMessageNode.getAttributes().getNamedItem("RequestKey").getTextContent();
            logger.debug((Object)("messUID=" + messUID + ", requestKey=" + requestKey));
            WorkflowMessage response = new WorkflowMessage((IMessageUID)new MessageUIDImpl(messUID), (IMessageKey)new MessageKeyImpl((Object)requestKey));
            WorkflowPayload payload = response.getPayload();
            try {
                SchedulerService service = this.getService(url);
                String pitchId = this.getPitchId(service, packageToPitchId, pitcherId, encryptPackage, catcherIdsValues, scheduleDate);
                payload.putValue("PitchId", pitchId);
                response.setType(WorkflowMessage.MessageType.ack);
            }
            catch (MediaPathAPIException de) {
                logger.error((Object)"Error occurred while scheduling pitch of a package: ", (Throwable)de);
                StringWriter writer = new StringWriter();
                de.printStackTrace(new PrintWriter(writer));
                payload.putValue("error-message", de.getMessage());
                payload.putValue("error-stack", writer.toString());
                response.setType(WorkflowMessage.MessageType.nack);
            }
            return response;
        }
        catch (Exception e) {
            throw new DispatcherException((Throwable)e);
        }
    }

    private String getPitchId(SchedulerService service, String packageToPitchId, String pitcherId, String encryptPackage, String catcherIdsValues, String scheduleDate) throws MediaPathAPIException {
        Long[] pitchIds;
        String pitchId = "";
        Long[] packageToPitch = new Long[]{Long.valueOf(packageToPitchId)};
        long pitcherIdLong = Long.valueOf(pitcherId);
        boolean videoSecure = Boolean.valueOf(encryptPackage);
        Long[] catcherIds = this.convertCommaSepListToList(catcherIdsValues);
        try {
            SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
            Calendar pitchDate = Calendar.getInstance();
            pitchDate.setTime(format.parse(scheduleDate));
            pitchIds = service.schedule(packageToPitch, catcherIds, pitchDate, videoSecure, pitcherIdLong);
        }
        catch (SchedulerService_schedule_comN2BbManagerWebserviceCommonServiceException_Fault e) {
            throw new MediaPathAPIException(e);
        }
        catch (RemoteException e) {
            throw new MediaPathAPIException(e);
        }
        catch (ParseException e) {
            throw new MediaPathAPIException(e);
        }
        pitchId = pitchIds[0].toString();
        return pitchId;
    }

    private Long[] convertCommaSepListToList(String str) {
        Long[] catcherIds = null;
        if (str != null) {
            StringTokenizer st = new StringTokenizer(str, ",");
            catcherIds = new Long[st.countTokens()];
            int i = -1;
            while (st.hasMoreTokens()) {
                catcherIds[++i] = Long.valueOf(st.nextToken().trim());
            }
        }
        return catcherIds;
    }
}

