/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.adaptor.dispatcher;

import com.systinet.wsdl.com.n2bb.manager.webservice.server.SchedulerService;
import com.systinet.wsdl.com.n2bb.manager.webservice.server.SchedulerService_reschedule_comN2BbManagerWebserviceCommonServiceException_Fault;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.adaptor.dispatcher.DispatcherException;
import com.tandbergtv.workflow.adaptor.dispatcher.MediaPathAPIException;
import com.tandbergtv.workflow.adaptor.dispatcher.MediaPathDispatcher;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.MessageKeyImpl;
import com.tandbergtv.workflow.message.MessageUIDImpl;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowPayload;
import com.tandbergtv.workflow.util.XMLDocumentUtility;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.rmi.RemoteException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ReschedulePitchDispatcher
extends MediaPathDispatcher {
    private static final Logger logger = Logger.getLogger(ReschedulePitchDispatcher.class);
    private static final String DATE_FORMAT = "EEE MMM d HH:mm:ss z yyyy";

    public ReschedulePitchDispatcher(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    protected WorkflowMessage generateResponse(IMessage msg, URL url) throws DispatcherException {
        logger.debug((Object)("payload=" + msg.getPayload().getContent()));
        try {
            Document doc = XMLDocumentUtility.loadXml((String)msg.getPayload().getContent());
            String pitchId = null;
            String rescheduleDate = null;
            XPath xpath = XPathFactory.newInstance().newXPath();
            Node parameterListNode = (Node)xpath.evaluate("//WFSMessage/MessageBody/ParameterList", doc, XPathConstants.NODE);
            if (parameterListNode != null) {
                Node rescheduleDateNode;
                Node pitchIdNode = (Node)xpath.evaluate("Parameter[@Name='PitchId']", parameterListNode, XPathConstants.NODE);
                if (pitchIdNode != null) {
                    pitchId = (String)xpath.evaluate("Value", pitchIdNode, XPathConstants.STRING);
                }
                if ((rescheduleDateNode = (Node)xpath.evaluate("Parameter[@Name='RescheduleDate']", parameterListNode, XPathConstants.NODE)) != null) {
                    rescheduleDate = (String)xpath.evaluate("Value", rescheduleDateNode, XPathConstants.STRING);
                }
            }
            Node wfsMessageNode = (Node)xpath.evaluate("//WFSMessage", doc, XPathConstants.NODE);
            String messUID = wfsMessageNode.getAttributes().getNamedItem("UID").getTextContent();
            String requestKey = wfsMessageNode.getAttributes().getNamedItem("RequestKey").getTextContent();
            logger.debug((Object)("messUID=" + messUID + ", requestKey=" + requestKey));
            WorkflowMessage response = new WorkflowMessage((IMessageUID)new MessageUIDImpl(messUID), (IMessageKey)new MessageKeyImpl((Object)requestKey));
            WorkflowPayload payload = response.getPayload();
            try {
                SchedulerService service = this.getService(url);
                String rescheduledPitchId = this.getRescheduledPitchId(service, pitchId, rescheduleDate);
                if (rescheduledPitchId != null && !rescheduledPitchId.equals("")) {
                    payload.putValue("RescheduledPitchId", rescheduledPitchId);
                    payload.putValue("PackageRescheduled", "true");
                    response.setType(WorkflowMessage.MessageType.ack);
                } else {
                    payload.putValue("PackageRescheduled", "false");
                    response.setType(WorkflowMessage.MessageType.nack);
                }
            }
            catch (MediaPathAPIException de) {
                logger.error((Object)"Error occurred while getting the rescheduled pitch status for a package: ", (Throwable)de);
                StringWriter writer = new StringWriter();
                de.printStackTrace(new PrintWriter(writer));
                payload.putValue("error-message", de.getMessage());
                payload.putValue("PackageRescheduled", "false");
                response.setType(WorkflowMessage.MessageType.nack);
            }
            return response;
        }
        catch (Exception e) {
            logger.error((Object)"Error while loading XML document", (Throwable)e);
            throw new DispatcherException((Throwable)e);
        }
    }

    private String getRescheduledPitchId(SchedulerService service, String pitchId, String rescheduleDate) throws MediaPathAPIException {
        Long[] rescheduledPitchIds;
        String rescheduledPitchId = null;
        try {
            SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
            Calendar pitchDate = Calendar.getInstance();
            pitchDate.setTime(format.parse(rescheduleDate));
            rescheduledPitchIds = service.reschedule(Long.valueOf(pitchId).longValue(), pitchDate);
        }
        catch (SchedulerService_reschedule_comN2BbManagerWebserviceCommonServiceException_Fault e) {
            throw new MediaPathAPIException(e);
        }
        catch (NumberFormatException e) {
            throw new MediaPathAPIException(e);
        }
        catch (RemoteException e) {
            throw new MediaPathAPIException(e);
        }
        catch (ParseException e) {
            throw new MediaPathAPIException(e);
        }
        rescheduledPitchId = rescheduledPitchIds[0].toString();
        return rescheduledPitchId;
    }
}

