/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.mgmt.heartbeat;

import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.mgmt.heartbeat.AbstractBaseHeartBeatStrategy;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public abstract class AbstractHeartBeatStrategy
extends AbstractBaseHeartBeatStrategy {
    protected ScheduledExecutorService service = null;
    protected ScheduledFuture future = null;
    private static final Logger logger = Logger.getLogger(AbstractHeartBeatStrategy.class);
    private static final long DEFAULT_FREQUENCY = 60L;

    @Override
    public synchronized void startHeartBeatMonitor() {
        Resource resource = this.getResource();
        String name = this.getResourceDisplayName();
        if (this.future != null) {
            logger.warn((Object)("Attempting to start HeartBeat Monitoring for " + name + " when the heartbeats have already been started, ignoring command."));
            return;
        }
        this.service = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new /* Unavailable Anonymous Inner Class!! */);
        Runnable command = this.getHeartBeatCommand();
        Long frequencyValue = resource.getHeartbeatFrequency();
        long frequency = frequencyValue != null ? frequencyValue : 60L;
        logger.debug((Object)("Starting Heartbeats for " + name + " with frequency: " + frequency + " seconds."));
        this.future = this.service.scheduleAtFixedRate(command, 0L, frequency, TimeUnit.SECONDS);
    }

    @Override
    public synchronized void stopHeartBeatMonitor() {
        String name = this.getResourceDisplayName();
        if (this.future == null) {
            logger.warn((Object)("Attempting to stop HeartBeat Monitoring for " + name + " when the heartbeats are not being sent, ignoring command."));
            return;
        }
        logger.debug((Object)("Stopping Heartbeats for " + name));
        boolean result = this.future.cancel(false);
        this.future = null;
        this.service.shutdown();
        this.service = null;
        logger.debug((Object)("Status of attempt to stop the HeartBeat Messages for " + name + ": " + result));
    }

    @Override
    public synchronized boolean isMonitoringHeartBeats() {
        return this.future != null;
    }

    protected String getResourceDisplayName() {
        String display = "Resource[id=" + this.getResource().getId() + "]: " + this.getResource().getName();
        return display;
    }

    protected abstract Runnable getHeartBeatCommand();
}

