/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.mgmt.initialization;

import com.tandbergtv.workflow.resourcemanager.mgmt.initialization.AbstractBaseInitializationStrategy;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public abstract class AbstractInitializationStrategy
extends AbstractBaseInitializationStrategy {
    protected ScheduledExecutorService service = null;
    protected ScheduledFuture future = null;
    private static final Logger logger = Logger.getLogger(AbstractInitializationStrategy.class);

    @Override
    public synchronized void initializeResource() {
        String name = this.getResourceDisplayName();
        if (this.future != null) {
            logger.warn((Object)("Attempting to start Initialization for " + name + " when the initialization is already in progress, ignoring command."));
            return;
        }
        this.service = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new /* Unavailable Anonymous Inner Class!! */);
        Runnable command = this.getInitializationCommand();
        long delay = this.getInitializationRetryDelay();
        if (delay <= 0L) {
            delay = 1L;
        }
        logger.debug((Object)("Initializing " + name + " with retry attempts sent every " + delay + " seconds."));
        this.future = this.service.scheduleWithFixedDelay(command, 0L, delay, TimeUnit.SECONDS);
    }

    @Override
    public synchronized void stopInitializingResource() {
        String name = this.getResourceDisplayName();
        if (this.future == null) {
            logger.warn((Object)("Attempting to stop Resource Initialization for " + name + " which is not in progress, ignoring command."));
            return;
        }
        logger.debug((Object)("Stopping Initialization for " + name));
        boolean result = this.future.cancel(false);
        this.future = null;
        this.service.shutdown();
        this.service = null;
        logger.debug((Object)("Status of attempt to stop the Initialization for " + name + ": " + result));
    }

    @Override
    public synchronized boolean isInitializing() {
        return this.future != null;
    }

    protected String getResourceDisplayName() {
        String display = "Resource[id=" + this.getResource().getId() + "]: " + this.getResource().getName();
        return display;
    }

    protected abstract Runnable getInitializationCommand();

    protected abstract long getInitializationRetryDelay();
}

