/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.plugins.directv.adaptor;

import com.tandbergtv.workflow.adaptor.AdaptorRequestImpl;
import com.tandbergtv.workflow.adaptor.IAdaptorRequest;
import com.tandbergtv.workflow.adaptor.conf.IDispatcherConfiguration;
import com.tandbergtv.workflow.adaptor.dispatcher.DispatcherException;
import com.tandbergtv.workflow.adaptor.dispatcher.TCPReadWriteDispatcher;
import com.tandbergtv.workflow.adaptor.internal.AbstractDefaultAdaptor;
import com.tandbergtv.workflow.adaptor.registry.IAdaptorRegistry;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.comm.ISource;
import com.tandbergtv.workflow.comm.TCPDevice;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.IPayload;
import com.tandbergtv.workflow.message.MessageImpl;
import com.tandbergtv.workflow.message.MessageUIDImpl;
import com.tandbergtv.workflow.message.StringPayload;
import com.tandbergtv.workflow.message.TCPMessage;
import com.tandbergtv.workflow.message.TCPPayload;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.util.Marshaller;
import com.tandbergtv.workflow.plugins.directv.adaptor.VTPSResponseConstants;
import com.tandbergtv.workflow.plugins.directv.adaptor.VTPSResponseMessageConstants;
import com.tandbergtv.workflow.util.XMLDocumentUtility;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class VTPSDispatcher
extends TCPReadWriteDispatcher {
    private static final Logger logger = Logger.getLogger(VTPSDispatcher.class);
    private Thread pingThread = new Thread();
    private int pingResponseTimeout = -1;

    public VTPSDispatcher(IDispatcherConfiguration conf, IDestination destination) {
        super(conf, destination);
    }

    protected TCPMessage sendMessage(IMessage msg) throws DispatcherException {
        if (msg.getPayload() instanceof TCPPayload) {
            String payload = msg.getPayload().getContent();
            if (payload != null && payload.equals(VTPSResponseMessageConstants.PING.toString())) {
                try {
                    this.setPingResponseTimeout();
                    logger.debug((Object)("Sending : " + payload));
                    this.getWriter().println(payload);
                }
                catch (Exception ex) {
                    throw new DispatcherException("Could not send message", (Throwable)ex);
                }
                return this.getResponseForPing();
            }
            throw new DispatcherException("Cannot handle anything other than PING for now, payload was: " + payload);
        }
        throw new DispatcherException("Cannot handle anything other than TCPPayload");
    }

    protected void setPingResponseTimeout() {
        String pingResponseTimeoutString = this.getConfiguration().getParameterValue(VTPSResponseMessageConstants.ResponseTimeout.toString());
        this.pingResponseTimeout = Integer.parseInt(pingResponseTimeoutString);
    }

    protected TCPMessage getResponseForPing() throws DispatcherException {
        try {
            this.pingThread = Thread.currentThread();
            logger.debug((Object)("Sent PING to destination: " + this.getDestination() + " , waiting for PONG for " + this.pingResponseTimeout + " seconds ..."));
            Thread.sleep(this.pingResponseTimeout * 1000);
        }
        catch (InterruptedException ie) {
            logger.debug((Object)"After interupting the thread, sending response for PING");
            TCPPayload responsePayload = new TCPPayload(VTPSResponseMessageConstants.PONG.toString());
            TCPMessage responseMessage = new TCPMessage(responsePayload);
            return responseMessage;
        }
        throw new DispatcherException("PING Response timed out");
    }

    protected void processReadMessage(String readString) throws DispatcherException {
        logger.debug((Object)("Processing the message: " + readString));
        if (readString.length() >= 3) {
            int responseCode = Integer.parseInt(readString.substring(0, 3));
            String responseString = readString.substring(3).trim();
            logger.debug((Object)("Responsecode:" + responseCode + " ResponseString:" + responseString));
            if (VTPSResponseConstants.PERCENTAGE_COMPLETE.isWithinRange(responseCode)) {
                logger.debug((Object)"Received Percentage complete... sending back to adaptor...");
                this.analyzeStatusMessage(readString);
            } else if (VTPSResponseConstants.ASYNCHRONOUS_EVENT_FAILURE_MESSAGES.isWithinRange(responseCode)) {
                logger.debug((Object)"Received a asynchronous event error message... sending back to adaptor...");
                this.analyzeStatusMessage(readString);
            } else if (VTPSResponseConstants.SUCCESSFUL_COMMAND_COMPLETION.isWithinRange(responseCode)) {
                logger.debug((Object)"Reponse code is within the successful command completion");
                if (responseString.indexOf(VTPSResponseMessageConstants.PONG.toString()) != -1) {
                    this.pingThread.interrupt();
                }
            } else if (VTPSResponseConstants.ERROR_MESSAGES.isWithinRange(responseCode)) {
                if (responseString.indexOf(VTPSResponseMessageConstants.Disconnect.toString()) != -1) {
                    logger.info((Object)"Received disconnect");
                    this.destroy();
                } else {
                    logger.warn((Object)("Cannot handle error message: " + readString));
                }
            } else if (VTPSResponseConstants.APPLICATION_DOWN.isWithinRange(responseCode)) {
                logger.info((Object)"Received application down");
                this.destroy();
            } else {
                logger.debug((Object)("Not Handling the message: " + readString));
            }
        }
    }

    private void analyzeStatusMessage(String responseString) throws DispatcherException {
        StringPayload strPayload;
        MessageUIDImpl messageUID = new MessageUIDImpl(VTPSResponseMessageConstants.STATUS_MESSAGE_FAKE_UID.toString());
        ISource source = (ISource)this.getDestination();
        WorkflowMessage msg = new WorkflowMessage((IMessageUID)messageUID);
        msg.putValue(VTPSResponseMessageConstants.CONTENT.toString(), responseString);
        msg.setSource(source);
        try {
            strPayload = new StringPayload(XMLDocumentUtility.convertToString((Node)Marshaller.newMarshaller().marshal(msg)));
        }
        catch (Exception e) {
            throw new DispatcherException("Could not marshal message into WPCL." + e);
        }
        MessageImpl messageToSend = new MessageImpl((IPayload)strPayload);
        this.sendBackToAdaptor((IMessage)messageToSend);
    }

    private void sendBackToAdaptor(IMessage msg) {
        try {
            logger.debug((Object)"Constructing the adaptor request and sending back to adaptor");
            IAdaptorRegistry registry = (IAdaptorRegistry)ServiceRegistry.getDefault().lookup(IAdaptorRegistry.class);
            AbstractDefaultAdaptor adaptor = registry.getDefaultAdaptor();
            AdaptorRequestImpl adaptorRequest = new AdaptorRequestImpl(msg);
            logger.debug((Object)"Sending message back to Adaptor for reprocessing");
            adaptor.transmit((IAdaptorRequest)adaptorRequest);
            logger.debug((Object)"The message has been transmitted successfully");
        }
        catch (Exception ex) {
            logger.warn((Object)"Could not sent back to adaptor", (Throwable)ex);
        }
    }

    protected String getDeviceIP() {
        return "VTPS (" + ((TCPDevice)this.getDestination()).getIP() + ")";
    }
}

