/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.plugins.directv.adaptor;

import com.tandbergtv.workflow.adaptor.conf.IHandlerConfiguration;
import com.tandbergtv.workflow.adaptor.handler.HandlerException;
import com.tandbergtv.workflow.adaptor.handler.IHandler;
import com.tandbergtv.workflow.adaptor.handler.XMLTemplateHandler;
import com.tandbergtv.workflow.message.HTTPMessage;
import com.tandbergtv.workflow.message.HTTPPayload;
import com.tandbergtv.workflow.message.IMessage;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class CMSHandler
extends XMLTemplateHandler
implements IHandler {
    private static final Logger logger = Logger.getLogger(CMSHandler.class);
    private static final String BUNDLE_NAME = CMSHandler.class.getPackage().getName() + ".cmshandler";
    private static final String CONTENT_TYPE_TRAILER = "CONTENT_TYPE_TRAILER";
    private static final String CONTENT_TYPE_MOVIE = "CONTENT_TYPE_MOVIE";
    private static final String CONTENT_TYPE_CLIP = "CONTENT_TYPE_CLIP";
    private ResourceBundle bundle;

    public CMSHandler() {
        this.bundle = ResourceBundle.getBundle(BUNDLE_NAME);
    }

    public CMSHandler(IHandlerConfiguration conf) {
        super(conf);
        ClassLoader loader = conf.getClassLoader();
        this.bundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault(), loader);
    }

    public IMessage process(IMessage message) throws HandlerException {
        HTTPMessage ret = (HTTPMessage)super.process(message);
        HTTPPayload payload = (HTTPPayload)ret.getPayload();
        String input = message.getPayload().getContent();
        String output = payload.getContent();
        Document source = this.getDOMDocumentFromString(input);
        Document destination = this.getDOMDocumentFromString(output);
        String type = this.getContentType(source);
        if (!(this.bundle.getString(CONTENT_TYPE_TRAILER).equals(type) || this.bundle.getString(CONTENT_TYPE_MOVIE).equals(type) || this.bundle.getString(CONTENT_TYPE_CLIP).equals(type))) {
            return ret;
        }
        Element e = this.getElement(destination, this.bundle.getString("WPCL_HOUSE_MATERIAL_ID_XPATH"));
        e.getParentNode().removeChild(e);
        e = this.getElement(destination, this.bundle.getString("WPCL_BROADCAST_MATERIAL_ID_XPATH"));
        e.getParentNode().removeChild(e);
        NodeList materials = this.getMaterials(source);
        for (int i = 0; i < materials.getLength(); ++i) {
            this.transformMaterial(materials.item(i), destination);
        }
        output = this.getXMLFromDocument(destination);
        payload.setContent(output);
        return ret;
    }

    public IMessage postProcess(IMessage message) throws HandlerException {
        HTTPMessage ret = (HTTPMessage)super.postProcess(message);
        HTTPPayload payload = (HTTPPayload)ret.getPayload();
        String output = payload.getContent();
        Document destination = this.getDOMDocumentFromString(output);
        this.removeEmptyElements(destination);
        output = this.getXMLFromDocument(destination);
        payload.setContent(output);
        return ret;
    }

    private void removeEmptyElements(Document source) throws HandlerException {
        String path = this.bundle.getString("HOUSE_MATERIAL_ID_XPATH");
        this.removeEmptyMaterialIdElements(source, path);
        path = this.bundle.getString("BROADCAST_MATERIAL_ID_XPATH");
        this.removeEmptyMaterialIdElements(source, path);
        path = this.bundle.getString("MATERIAL_XPATH");
        this.removeEmptyMaterialElements(source, path);
    }

    private void removeEmptyMaterialElements(Document source, String path) throws HandlerException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            NodeList nodes = (NodeList)xpath.evaluate(path, source, XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                int count = node.getChildNodes().getLength();
                boolean remove = true;
                for (int j = 0; j < count; ++j) {
                    Node child = node.getChildNodes().item(j);
                    remove = remove && child instanceof Text;
                }
                if (!remove) continue;
                Node parent = node.getParentNode();
                parent.removeChild(node);
            }
        }
        catch (Exception e) {
            throw new HandlerException((Throwable)e);
        }
    }

    private void removeEmptyMaterialIdElements(Document source, String path) throws HandlerException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            NodeList nodes = (NodeList)xpath.evaluate(path, source, XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                if (node.hasChildNodes()) continue;
                Node parent = node.getParentNode();
                parent.removeChild(node);
            }
        }
        catch (Exception e) {
            throw new HandlerException((Throwable)e);
        }
    }

    private String getContentType(Node source) throws HandlerException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        String type = null;
        String path = this.bundle.getString("CONTENT_TYPE_XPATH");
        try {
            type = xpath.evaluate(path, source);
        }
        catch (Exception e) {
            throw new HandlerException((Throwable)e);
        }
        return type;
    }

    private NodeList getMaterials(Document source) throws HandlerException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        NodeList nodes = null;
        String path = this.bundle.getString("MATERIAL_XPATH");
        try {
            nodes = (NodeList)xpath.evaluate(path, source, XPathConstants.NODESET);
        }
        catch (Exception e) {
            throw new HandlerException((Throwable)e);
        }
        return nodes;
    }

    private void transformMaterial(Node node, Document destination) throws HandlerException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            String broadcast;
            String target = xpath.evaluate(this.bundle.getString("TARGET_XPATH"), node);
            if (target == null || target.length() == 0) {
                throw new HandlerException("No target specified");
            }
            logger.debug((Object)("Target " + target));
            Element e = this.getElement(destination, "//Parameter[@Name='target" + target + "']/Value");
            e.setTextContent(Boolean.TRUE.toString());
            String house = xpath.evaluate(this.bundle.getString("HOUSE_MATERIAL_ID"), node);
            if (house.length() > 0) {
                logger.debug((Object)("House " + house));
                e = this.getElement(destination, "//Parameter[@Name='houseMaterialId" + target + "']/Value");
                if (e != null) {
                    e.setTextContent(house);
                }
            }
            if ((broadcast = xpath.evaluate(this.bundle.getString("BROADCAST_MATERIAL_ID"), node)).length() > 0) {
                logger.debug((Object)("Broadcast " + broadcast));
                e = this.getElement(destination, "//Parameter[@Name='broadcastMaterialId" + target + "']/Value");
                if (e != null) {
                    e.setTextContent(broadcast);
                }
            }
        }
        catch (Exception e) {
            throw new HandlerException((Throwable)e);
        }
    }

    private Element getElement(Node node, String name) throws HandlerException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        Element element = null;
        try {
            element = (Element)xpath.evaluate(name, node, XPathConstants.NODE);
        }
        catch (Exception e) {
            throw new HandlerException((Throwable)e);
        }
        return element;
    }
}

