/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.plugins.directv.adaptor;

import com.tandbergtv.workflow.adaptor.messageidentifier.IMessageIdentifier;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.MessageUIDImpl;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class CMSMessageIdentifier
implements IMessageIdentifier {
    private static final String BBV_NAME_SPACE = "bbv";
    private static final String ASSET_DELIVERY_DATA = "bbv:asset-delivery-data";
    private static final String ASSET_PURGE = "bbv:purge-asset";
    private static final String ASSET_DELIVERY_DATA_UID = "020101";
    private static final String ASSET_PURGE_UID = "020102";

    public IMessageUID identify(IMessage message) {
        Element root;
        try {
            root = this.getRootElement(message.getPayload().getContent());
        }
        catch (Exception e) {
            return null;
        }
        String name = root.getNodeName();
        if (this.isCMSMessage(root)) {
            if (ASSET_DELIVERY_DATA.equals(name)) {
                return new MessageUIDImpl(ASSET_DELIVERY_DATA_UID);
            }
            if (ASSET_PURGE.equals(name)) {
                return new MessageUIDImpl(ASSET_PURGE_UID);
            }
        }
        return null;
    }

    private boolean isCMSMessage(Element root) {
        return BBV_NAME_SPACE.equals(root.getPrefix());
    }

    private Element getRootElement(String message) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        return factory.newDocumentBuilder().parse(new InputSource(new StringReader(message))).getDocumentElement();
    }
}

