/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.executionhandler.handlers;

import com.tandbergtv.workflow.executionhandler.handlers.ExecutionHandlerException;
import com.tandbergtv.workflow.util.adi.ADI11Parser;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

public class ADITitleParser
implements ActionHandler {
    private static final long serialVersionUID = 6709074445697694794L;
    private static final Logger logger = Logger.getLogger(ADITitleParser.class);
    private static final String METADATA_FILE_PATH_VARIABLE = "metadataFilePath";
    private static final String TITLE_BRIEF_VARIABLE = "titleBrief";

    public void execute(ExecutionContext ec) {
        String path = (String)ec.getVariable(METADATA_FILE_PATH_VARIABLE);
        if (path == null || path.trim().length() == 0) {
            throw new ExecutionHandlerException(ec.getProcessInstance() + " ADI metadata file path is not defined");
        }
        logger.debug((Object)(ec.getProcessInstance() + " path to ADI metadata file is " + path));
        ADI11Parser parser = ADI11Parser.newInstance();
        try {
            parser.load(path);
            String title = parser.getBriefTitle();
            logger.debug((Object)(ec.getProcessInstance() + ", read title from ADI metadata: " + title));
            ec.getContextInstance().createVariable(TITLE_BRIEF_VARIABLE, (Object)title);
        }
        catch (Exception e) {
            throw new ExecutionHandlerException("Failed to read title ", e);
        }
    }
}

